/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.query;

import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.listtext.lta.search.ISearchHandler;
import com.agfa.pacs.listtext.lta.search.ISearchThread;
import com.agfa.pacs.listtext.lta.search.SearchHandlerListener;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public class DataInfoQueryManager {
    private ProgressStateModel psm = null;
    private Map<ISearchHandler, IFilter> searchHandlers = new HashMap<ISearchHandler, IFilter>();
    private int nRunningThreads = 0;
    private IRootInfo result = null;
    private ISearchControlListener l;

    public void addSearchHandler(ISearchHandler iSearchHandler, IFilter iFilter) {
        if (!this.searchHandlers.containsKey(iSearchHandler)) {
            this.searchHandlers.put(iSearchHandler, iFilter);
        }
    }

    public void removeSearchHandler(ISearchHandler iSearchHandler) {
        if (this.searchHandlers.containsKey(iSearchHandler)) {
            this.searchHandlers.remove(iSearchHandler);
        }
    }

    public synchronized void reset() {
        this.psm = null;
        this.nRunningThreads = 0;
        this.searchHandlers.clear();
        this.result = null;
    }

    public synchronized ProgressStateModel startSearches(ISearchControlListener iSearchControlListener, boolean bl) {
        if (this.searchRunning()) {
            this.stopSearches();
        }
        this.nRunningThreads = this.searchHandlers.size();
        this.psm = new ProgressStateModel("Search", null, new Attributes[0]);
        this.result = null;
        this.l = iSearchControlListener;
        if (this.searchHandlers.size() > 0) {
            for (Map.Entry<ISearchHandler, IFilter> entry : this.searchHandlers.entrySet()) {
                ISearchHandler iSearchHandler = entry.getKey();
                this.psm.addCancelable(iSearchHandler.search(entry.getValue(), new SearchListener(iSearchHandler), bl));
            }
        } else {
            this.psm.setState(JobState.FINISHED);
            if (iSearchControlListener != null) {
                iSearchControlListener.searchFinished(DataInfoUtilities.createRoot());
            }
        }
        return this.psm;
    }

    public synchronized void stopSearches() {
        if (this.searchRunning() && this.psm != null) {
            this.psm.cancelAll();
        }
    }

    public boolean searchRunning() {
        return this.nRunningThreads > 0;
    }

    public IRootInfo getSearchResult() {
        return this.result;
    }

    private synchronized void searchStarted(ISearchHandler iSearchHandler) {
        if (this.nRunningThreads == this.searchHandlers.size()) {
            this.psm.setState(JobState.STARTED);
        }
        if (this.l != null) {
            this.l.searchStarted();
        }
    }

    private synchronized void searchSuccess(ISearchHandler iSearchHandler, IDataInfoSource iDataInfoSource) {
        if (this.l != null) {
            this.l.searchSuccess(iDataInfoSource);
        }
    }

    private synchronized void searchFailure(ISearchHandler iSearchHandler, IDataInfoSource iDataInfoSource, Throwable throwable) {
        if (this.l != null) {
            this.l.searchFailure(iDataInfoSource, throwable);
        }
    }

    private synchronized void searchFinished(ISearchHandler iSearchHandler, IRootInfo iRootInfo) {
        --this.nRunningThreads;
        this.psm.setProgress((float)this.searchHandlers.size() / (float)(this.searchHandlers.size() - this.nRunningThreads));
        if (this.result == null) {
            this.result = iRootInfo;
        } else {
            DataInfoUtilities.mergeRoots((IRootInfo)this.result, (IRootInfo)iRootInfo);
        }
        if (this.nRunningThreads <= 0) {
            this.psm.setState(JobState.FINISHED);
            if (this.l != null) {
                this.l.searchFinished(this.result);
            }
        }
    }

    public static interface ISearchControlListener {
        public void searchStarted();

        public void searchSuccess(IDataInfoSource var1);

        public void searchFailure(IDataInfoSource var1, Throwable var2);

        public void searchFinished(IRootInfo var1);
    }

    private class SearchListener
    implements SearchHandlerListener {
        private ISearchHandler searchHandler;

        public SearchListener(ISearchHandler iSearchHandler) {
            this.searchHandler = iSearchHandler;
        }

        @Override
        public void searchStarted(ISearchHandler iSearchHandler, ISearchThread iSearchThread) {
            DataInfoQueryManager.this.searchStarted(this.searchHandler);
        }

        @Override
        public void searchFinished(ISearchHandler iSearchHandler, ISearchThread iSearchThread) {
            DataInfoQueryManager.this.searchFinished(iSearchHandler, iSearchThread.getResult());
        }

        @Override
        public void searchSuccess(ISearchHandler iSearchHandler, ISearchThread iSearchThread, IDataInfoSource iDataInfoSource, IDataInfo iDataInfo) {
            DataInfoQueryManager.this.searchSuccess(iSearchHandler, iDataInfoSource);
        }

        @Override
        public void searchFailure(ISearchHandler iSearchHandler, ISearchThread iSearchThread, IDataInfoSource iDataInfoSource, Throwable throwable) {
            DataInfoQueryManager.this.searchFailure(iSearchHandler, iDataInfoSource, throwable);
        }
    }
}

