/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.shared.data.DicomDataListenerAdapter;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationStateRelationship;
import com.agfa.pacs.listtext.dicomobject.module.ps.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.lta.util.CancelManager;
import com.agfa.pacs.listtext.lta.util.DataFinderUtilities;
import com.agfa.pacs.listtext.lta.util.referencedobject.IReferencedObjectRetrievalListener;
import com.agfa.pacs.listtext.lta.util.referencedobject.IReferencedObjectRetriever;
import com.agfa.pacs.listtext.lta.util.referencedobject.InvalidSessionLoadAbortion;
import com.agfa.pacs.listtext.lta.util.referencedobject.KeyObjectParser;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.listtext.lta.util.referencedobject.TypeOfKOSearch;
import com.agfa.pacs.listtext.lta.util.referencedobject.UnresolvedReferencedObjectsUtil;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.dcm4che3.data.Attributes;

public class DefaultReferencedObjectRetriever
implements Runnable,
IReferencedObjectRetriever {
    private static final ALogger log = ALogger.getLogger(DefaultReferencedObjectRetriever.class);
    private final List<IObjectInfo> referringObjects;
    private final List<ReferringObjectType> types;
    private IReferencedObjectRetrievalListener l;
    private List<ReferencedObject> result;
    private int totalReferencedObjectCount;
    private CancelManager cancelManager;
    private boolean running;
    private boolean cancelled;
    private Exception exception;
    private final List<IObjectInfo> cachedObjects;
    private final boolean requireFrameNumbers;
    private boolean reportMissing = false;

    DefaultReferencedObjectRetriever(List<IObjectInfo> list, List<IObjectInfo> list2, List<ReferringObjectType> list3, IReferencedObjectRetrievalListener iReferencedObjectRetrievalListener, boolean bl, boolean bl2) {
        this.referringObjects = list;
        this.cachedObjects = list2;
        this.types = list3;
        this.l = iReferencedObjectRetrievalListener;
        this.reportMissing = bl2;
        this.result = new ArrayList<ReferencedObject>();
        this.totalReferencedObjectCount = 0;
        this.cancelManager = new CancelManager();
        this.cancelled = false;
        this.running = false;
        this.requireFrameNumbers = bl;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void cancel() {
        if (this.isRunning()) {
            this.cancelled = true;
            this.cancelManager.cancelAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReferencedObject> getResult() {
        ArrayList<ReferencedObject> arrayList;
        List<ReferencedObject> list = this.result;
        synchronized (list) {
            arrayList = new ArrayList<ReferencedObject>(this.result);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalReferencedObjectCount() {
        int n;
        List<ReferencedObject> list = this.result;
        synchronized (list) {
            n = this.totalReferencedObjectCount;
        }
        return n;
    }

    @Override
    public Exception getLastException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.result.clear();
        this.running = true;
        this.cancelled = false;
        this.exception = null;
        if (this.l != null) {
            this.l.retrievalStarted();
        }
        try {
            List<ReferencedObject> list = this.getReferencedObjects();
            List<ReferencedObject> list2 = this.result;
            synchronized (list2) {
                this.result.addAll(list);
            }
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        this.running = false;
        if (this.l != null) {
            this.l.retrievalFinished(this.result);
        }
    }

    private List<ReferencedObject> findReferencedObjects(Map<IObjectInfo, Attributes> map) throws InvalidSessionLoadAbortion {
        ArrayList<ReferencedObject> arrayList = new ArrayList<ReferencedObject>();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<IObjectInfo, Attributes> entry : map.entrySet()) {
                Attributes attributes = entry.getValue();
                if (this.types != null && !ReferencedObjectUtilities.matches(attributes, this.types)) continue;
                IObjectInfo iObjectInfo = entry.getKey();
                Attributes attributes2 = attributes;
                ReferringObject referringObject = new ReferringObject(ReferringObjectType.valueOf(iObjectInfo), iObjectInfo);
                referringObject.setAttributes(attributes2);
                try {
                    PresentationStateRelationship presentationStateRelationship;
                    String string = attributes2.getString(524310);
                    if (UIDUtilities.isType((String)string, (UIDType)UIDType.KeyObject) || UIDUtilities.isType((String)string, (UIDType)UIDType.StructuredReport)) {
                        presentationStateRelationship = this.findKOReferencedObjects(attributes2, referringObject);
                        arrayList.addAll((Collection<ReferencedObject>)presentationStateRelationship);
                        continue;
                    }
                    if (!UIDUtilities.isType((String)string, (UIDType)UIDType.Presentation)) continue;
                    presentationStateRelationship = PresentationStateRelationship.create((Attributes)attributes2);
                    List<ReferencedObject> list = DefaultReferencedObjectRetriever.findPSReferencedObjects(referringObject, presentationStateRelationship);
                    arrayList.addAll(list);
                }
                catch (InvalidSessionLoadAbortion invalidSessionLoadAbortion) {
                    throw invalidSessionLoadAbortion;
                }
                catch (Exception exception) {
                    log.error("Extracting/Retrieving referenced object descriptors failed! Skip...", (Throwable)exception);
                }
            }
            log.debug(String.valueOf(arrayList.size()) + " referenced objects extracted/retrieved");
            return arrayList;
        }
        return Collections.emptyList();
    }

    private List<ReferencedObject> getReferencedObjects() throws InvalidSessionLoadAbortion {
        if (this.referringObjects != null && !this.referringObjects.isEmpty()) {
            Map<IObjectInfo, Attributes> map = null;
            if (!this.cancelled && !this.referringObjects.isEmpty()) {
                log.trace("Retrieving " + this.referringObjects.size() + " dicom objects ...");
                map = this.retrieveObjects(this.referringObjects);
                log.trace(String.valueOf(map.size()) + " dicom objects retrieved");
            }
            return this.findReferencedObjects(map);
        }
        if (this.cancelled) {
            log.trace("Retrieving referring objects cancelled by the user");
        }
        return Collections.emptyList();
    }

    private Map<IObjectInfo, Attributes> retrieveObjects(List<IObjectInfo> list) {
        final Hashtable<IObjectInfo, Attributes> hashtable = new Hashtable<IObjectInfo, Attributes>();
        if (list != null) {
            for (final IObjectInfo iObjectInfo : list) {
                try {
                    IDicomDataRequest iDicomDataRequest = DicomDataRequester.getInstance().createDicomDataRequest(iObjectInfo, (byte)0);
                    iDicomDataRequest.setListener((IDicomDataListener)new DicomDataListenerAdapter(){

                        public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
                            hashtable.put(iObjectInfo, attributes);
                        }
                    });
                    DicomDataRequester.getInstance().addRequest(iDicomDataRequest);
                    iDicomDataRequest.waitUntilFinished();
                }
                catch (Exception exception) {
                    log.error("Referring object retrieval failed! Skipping...");
                }
            }
        }
        return hashtable;
    }

    private List<ReferencedObject> findKOReferencedObjects(Attributes attributes, ReferringObject referringObject) throws InvalidSessionLoadAbortion {
        Map<String, ReferencedSOP> map = KeyObjectParser.getAllImageReferences(KeyObjectParser.getKOReferences(attributes));
        Map<String, SRReferencedImage> map2 = null;
        if (this.requireFrameNumbers && (map2 = KeyObjectParser.getDetailedImageReferences(attributes)).isEmpty()) {
            map2 = null;
        }
        ArrayList<ReferencedObject> arrayList = new ArrayList<ReferencedObject>();
        if (this.cachedObjects != null && !this.cachedObjects.isEmpty()) {
            IObjectInfo iObjectInfo2;
            HashMap<String, IObjectInfo> hashMap = new HashMap<String, IObjectInfo>();
            for (IObjectInfo iObjectInfo2 : this.cachedObjects) {
                if (!map.containsKey(iObjectInfo2.getSOPInstanceUID())) continue;
                hashMap.put(iObjectInfo2.getSOPInstanceUID(), iObjectInfo2);
            }
            iObjectInfo2 = map.entrySet().iterator();
            if (!hashMap.isEmpty()) {
                while (iObjectInfo2.hasNext()) {
                    ReferencedSOP referencedSOP = (ReferencedSOP)((Map.Entry)iObjectInfo2.next()).getValue();
                    IObjectInfo iObjectInfo3 = (IObjectInfo)hashMap.get(referencedSOP.getSOPInstanceUID());
                    if (iObjectInfo3 == null) continue;
                    if (map2 == null) {
                        arrayList.add(new ReferencedObject(referringObject, iObjectInfo3, null));
                    } else {
                        SRReferencedImage sRReferencedImage = map2.get(referencedSOP.getSOPInstanceUID());
                        if (sRReferencedImage == null || sRReferencedImage.getReferencedFrameNumbers() == null) {
                            arrayList.add(new ReferencedObject(referringObject, iObjectInfo3, null));
                        } else {
                            int[] nArray = sRReferencedImage.getReferencedFrameNumbers();
                            int n = nArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int n3 = nArray[n2];
                                arrayList.add(new ReferencedObject(referringObject, iObjectInfo3, n3));
                                ++n2;
                            }
                        }
                    }
                    iObjectInfo2.remove();
                }
            }
        }
        this.createObjectList(referringObject, map, map2, arrayList);
        return arrayList;
    }

    public static List<IDataInfoSource> getDataNodesForKOReferences(String string) {
        return DefaultReferencedObjectRetriever.getDataNodesForKOReferences((IDataInfoSource)Base.getConfiguredDataInfoNodeByName(string));
    }

    public static List<IDataInfoSource> getDataNodesForKOReferences(IDataInfoSource iDataInfoSource) {
        List<IDataInfoSource> list;
        ArrayList<IDataInfoSource> arrayList = new ArrayList<IDataInfoSource>();
        if (iDataInfoSource != null) {
            arrayList.add(iDataInfoSource);
        }
        if ((list = DefaultReferencedObjectRetriever.getDataNodesForKOReferences()) != null) {
            String string = iDataInfoSource == null ? null : iDataInfoSource.getIdentifier().getName();
            for (IDataInfoSource iDataInfoSource2 : list) {
                if (Objects.equals(string, iDataInfoSource2.getIdentifier().getName())) continue;
                arrayList.add(iDataInfoSource2);
            }
        }
        return arrayList;
    }

    private static List<IDataInfoSource> getDataNodesForKOReferences() {
        switch (TypeOfKOSearch.valueOf(ConfigurationProviderFactory.getConfig().getString("listtext.searchForKOReferences"))) {
            case Source: {
                return new ArrayList<IDataInfoSource>(1);
            }
            case All: {
                return new ArrayList<IDataInfoNode>(Base.getDataInfoNodes());
            }
            case Configured: {
                return new ArrayList<IDataInfoSource>(CollectionUtils.union(Base.getDataNodesUserSearchable(), Base.getDataNodesForServices()));
            }
        }
        return new ArrayList<IDataInfoSource>(1);
    }

    private void createObjectList(ReferringObject referringObject, Map<String, ReferencedSOP> map, Map<String, SRReferencedImage> map2, List<ReferencedObject> list) throws InvalidSessionLoadAbortion {
        if (!map.isEmpty()) {
            Object object;
            Object object2;
            Attributes attributes;
            String string = null;
            if (!referringObject.isTemporaryMergedPatient()) {
                attributes = referringObject.getObject().getPatient().getAttributes();
                object2 = attributes.getString(0x100020);
                if (object2 == null) {
                    log.warn("Disabling support for MPI sessions due to missing patient ID");
                } else {
                    string = PatientKeyUtils.generatePatientKey((String)object2, null, (String)attributes.getString(0x100021));
                }
            }
            attributes = new ArrayList();
            object2 = DefaultReferencedObjectRetriever.compileKOSourceMap(referringObject, map.values());
            for (Map.Entry iObjectInfo : object2.entrySet()) {
                List<IDataInfoSource> list2 = iObjectInfo.getKey() == null ? DefaultReferencedObjectRetriever.getDataNodesForKOReferences(referringObject.getObject().getSource()) : Collections.singletonList((IDataInfoSource)iObjectInfo.getKey());
                if (list2.size() >= 1 && list2.get(0).getIdentifier().getType().equals("DICOMCACHE")) {
                    log.info("For set-aside use all searchable datanodes");
                    object = list2.get(0);
                    list2 = new ArrayList<IDataInfoSource>();
                    list2.add((IDataInfoSource)object);
                    list2.addAll(Base.getDataNodesUserSearchable());
                    List<IDataInfoNode> list3 = Base.getDataNodesForServices();
                    if (list3 != null) {
                        for (IDataInfoNode iDataInfoNode : list3) {
                            if (list2.contains(iDataInfoNode)) continue;
                            list2.add((IDataInfoSource)iDataInfoNode);
                        }
                    }
                }
                if ((object = DataFinderUtilities.findObjectsIncremental(list2, (Collection)iObjectInfo.getValue(), referringObject.getType() == ReferringObjectType.SESSION, string)) == null) continue;
                attributes.addAll(object);
            }
            for (IObjectInfo iObjectInfo : attributes) {
                if (map2 == null) {
                    list.add(new ReferencedObject(referringObject, iObjectInfo, null));
                    continue;
                }
                object = map2.get(iObjectInfo.getSOPInstanceUID());
                if (object == null || object.getReferencedFrameNumbers() == null) {
                    list.add(new ReferencedObject(referringObject, iObjectInfo, null));
                    continue;
                }
                int[] nArray = object.getReferencedFrameNumbers();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    list.add(new ReferencedObject(referringObject, iObjectInfo, n3));
                    ++n2;
                }
            }
            if (attributes.size() < map.size()) {
                int n = list.size();
                for (Iterator iterator : attributes) {
                    map.remove(iterator.getSOPInstanceUID());
                }
                if (!UnresolvedReferencedObjectsUtil.isUnresolvedReferencedObjectsAcceptable(referringObject, n, map.values(), this.reportMissing)) {
                    throw new InvalidSessionLoadAbortion();
                }
            }
        }
    }

    private static List<ReferencedObject> findPSReferencedObjects(ReferringObject referringObject, PresentationStateRelationship presentationStateRelationship) {
        IDataInfoSource iDataInfoSource = DefaultReferencedObjectRetriever.getPSSource(referringObject.getObject(), presentationStateRelationship);
        Collection<String> collection = DefaultReferencedObjectRetriever.extractPSReferencedInstanceUIDs(presentationStateRelationship);
        List<IObjectInfo> list = DataFinderUtilities.findObjects(iDataInfoSource, collection);
        ArrayList<ReferencedObject> arrayList = new ArrayList<ReferencedObject>();
        for (IObjectInfo iObjectInfo : list) {
            arrayList.add(new ReferencedObject(referringObject, iObjectInfo));
        }
        return arrayList;
    }

    private static Collection<String> extractPSReferencedInstanceUIDs(PresentationStateRelationship presentationStateRelationship) {
        List list;
        HashSet<String> hashSet = new HashSet<String>();
        if (presentationStateRelationship != null && (list = presentationStateRelationship.referencedSeries()) != null) {
            for (ReferencedSeries referencedSeries : list) {
                Map map = referencedSeries.referencedImages();
                if (map == null) continue;
                for (ReferencedImage referencedImage : map.values()) {
                    if (hashSet.contains(referencedImage.getSOPInstanceUID()) || !DefaultReferencedObjectRetriever.isReferencedObjectSOPClassSupported(referencedImage.getSOPClassUID())) continue;
                    hashSet.add(referencedImage.getSOPInstanceUID());
                }
            }
        }
        return hashSet;
    }

    private static boolean isReferencedObjectSOPClassSupported(String string) {
        return UIDUtilities.isType((String)string, (UIDType)UIDType.Image) || UIDUtilities.isType((String)string, (UIDType)UIDType.Lossless) || UIDUtilities.isType((String)string, (UIDType)UIDType.Lossy) || UIDUtilities.isType((String)string, (UIDType)UIDType.Multiframe) || UIDUtilities.isType((String)string, (UIDType)UIDType.SecondaryCapture) || UIDUtilities.isType((String)string, (UIDType)UIDType.Waveform);
    }

    private static Map<IDataInfoSource, List<ReferencedSOP>> compileKOSourceMap(ReferringObject referringObject, Collection<ReferencedSOP> collection) {
        HashMap<IDataInfoSource, List<ReferencedSOP>> hashMap = new HashMap<IDataInfoSource, List<ReferencedSOP>>(3);
        hashMap.put(null, new ArrayList());
        List list = (List)hashMap.get(null);
        for (ReferencedSOP referencedSOP : collection) {
            String[] stringArray = referencedSOP.getSeries().getRetrieveAETs();
            if (stringArray != null && stringArray.length >= 1) {
                IDataInfoNode iDataInfoNode = Base.getConfiguredDataInfoNodeByAET(stringArray[0]);
                if (iDataInfoNode != null) {
                    ArrayList<ReferencedSOP> arrayList = (ArrayList<ReferencedSOP>)hashMap.get(iDataInfoNode);
                    if (arrayList == null) {
                        arrayList = new ArrayList<ReferencedSOP>();
                        hashMap.put((IDataInfoSource)iDataInfoNode, arrayList);
                    }
                    arrayList.add(referencedSOP);
                    continue;
                }
                list.add(referencedSOP);
                continue;
            }
            list.add(referencedSOP);
        }
        if (list.isEmpty()) {
            hashMap.remove(null);
        }
        return hashMap;
    }

    private static IDataInfoSource getPSSource(IObjectInfo iObjectInfo, PresentationStateRelationship presentationStateRelationship) {
        List list;
        if (presentationStateRelationship != null && (list = presentationStateRelationship.referencedSeries()) != null) {
            for (ReferencedSeries referencedSeries : list) {
                IDataInfoNode iDataInfoNode;
                String string = referencedSeries.getRetrieveAET();
                if (string == null || (iDataInfoNode = Base.getConfiguredDataInfoNodeByAET(string)) == null) continue;
                return iDataInfoNode;
            }
        }
        return iObjectInfo.getSource();
    }
}

