/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.util.DataFinderUtilities;
import com.agfa.pacs.listtext.lta.util.PerformanceUtils;
import com.agfa.pacs.listtext.lta.util.referencedobject.IReferencedObjectRetriever;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

class FullStudySessionRetriever
implements IReferencedObjectRetriever {
    private static final ALogger log = ALogger.getLogger(FullStudySessionRetriever.class);
    private IObjectInfo session;
    private Exception lastException = null;
    private List<ReferencedObject> references = new ArrayList<ReferencedObject>();

    FullStudySessionRetriever(List<IObjectInfo> list) {
        this.session = list.get(0);
    }

    static boolean supports(List<IObjectInfo> list) {
        if (list.size() == 1 && ReferringObjectType.SESSION.match((IDataInfo)list.get(0))) {
            IObjectInfo iObjectInfo = list.get(0);
            if (FullStudySessionRetriever.isLoadedFromSetAsideStatus(iObjectInfo)) {
                return false;
            }
            Sequence sequence = iObjectInfo.getAttributes().getSequence(4236149);
            if (sequence == null) {
                return false;
            }
            for (Attributes attributes : sequence) {
                boolean bl = Boolean.parseBoolean(attributes.getString("TIANI", 2687065, "false"));
                if (bl) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isLoadedFromSetAsideStatus(IObjectInfo iObjectInfo) {
        return (Boolean)iObjectInfo.getTreeParent().getTreeParent().getAttributes().getProperty("SET_ASIDE_STATUS", (Object)Boolean.FALSE);
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public void cancel() {
    }

    @Override
    public List<ReferencedObject> getResult() {
        return this.references;
    }

    @Override
    public int getTotalReferencedObjectCount() {
        return this.references.size();
    }

    @Override
    public Exception getLastException() {
        return this.lastException;
    }

    @Override
    public void run() {
        String string = null;
        ReferringObject referringObject = new ReferringObject(ReferringObjectType.SESSION, this.session);
        for (Attributes attributes : this.session.getAttributes().getSequence(4236149)) {
            String string2 = attributes.getString(0x20000D);
            List<IStudyInfo> list = DataFinderUtilities.findStudiesReferencedInSession(this.session.getSource(), string2);
            if (list.size() != 1) {
                if (list.size() > 1) {
                    log.warn("Multiple studies found for{}", (Object)string2);
                    this.lastException = new IllegalStateException("Multiple studies found four " + string2);
                    return;
                }
                if (list.size() == 0) {
                    log.warn("Studies not found for{}", (Object)string2);
                    this.lastException = new IllegalStateException("Studies not found four " + string2);
                    return;
                }
            }
            if (string == null) {
                string = list.get(0).getPatient().getKey();
            } else if (!Objects.equals(string, list.get(0).getPatient().getKey())) {
                this.references.clear();
                this.lastException = new UnsupportedOperationException("Patient merge");
                return;
            }
            for (IObjectInfo iObjectInfo : PerformanceUtils.getObjectLevel(list.get(0))) {
                this.references.add(new ReferencedObject(referringObject, iObjectInfo));
            }
        }
    }
}

