/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.hap.pacs.data.keyobject.KeyObjectBuilder;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.dicom.config.DicomConfigurationFactory;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.util.Modality;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class KeyObjectAttributes
implements DatasetSource {
    private final ISeriesInfo seriesInfo;
    private final KeyObjectBuilder builder;
    private volatile IObjectInfo objectInfo;
    private boolean isAutoGenerated;

    public KeyObjectAttributes(ReferringObjectType referringObjectType, IStudyInfo iStudyInfo, IDataInfoSource iDataInfoSource) {
        this.seriesInfo = iStudyInfo.createSeries(Modality.KO.dicom());
        if (iDataInfoSource != null) {
            this.seriesInfo.setSource(iDataInfoSource);
        }
        this.builder = KeyObjectAttributes.initKeyObjectBuilder(referringObjectType, this.seriesInfo);
    }

    public KeyObjectAttributes(ReferringObjectType referringObjectType, IStudyInfo iStudyInfo) {
        this(referringObjectType, iStudyInfo, null);
    }

    public void setAutoGenerated(boolean bl) {
        this.isAutoGenerated = bl;
    }

    private static KeyObjectBuilder initKeyObjectBuilder(ReferringObjectType referringObjectType, ISeriesInfo iSeriesInfo) {
        boolean bl;
        boolean bl2 = bl = referringObjectType == ReferringObjectType.FOR_XDS;
        if (bl) {
            referringObjectType = ReferringObjectType.OF_INTEREST;
        }
        iSeriesInfo.getAttributes().setString(528446, VR.LO, "Flag [" + referringObjectType.getDicomCode().getCodeMeaning() + ']');
        Attributes attributes = new Attributes();
        attributes.addSelected(iSeriesInfo.getDicomObjectMerged(), DicomCFindConst.SERIES_MERGED_TAGS);
        attributes.setString(524293, VR.CS, DicomConfigurationFactory.getConfiguration().getDefaultCharacterSet());
        attributes.setString(524400, VR.LO, Product.getProductVendor());
        attributes.setString(528528, VR.LO, Product.getProductName());
        attributes.setString(1576992, VR.LO, Product.getVersionString());
        return new KeyObjectBuilder(referringObjectType.getDicomCode(), attributes, bl);
    }

    public Attributes toDataset() {
        Attributes attributes = this.builder.toDataset();
        if (this.isAutoGenerated) {
            attributes.setString("TIANI", 7405672, VR.SH, "true");
        }
        return attributes;
    }

    public synchronized IObjectInfo toObjectInfo() {
        if (this.objectInfo == null) {
            Attributes attributes = this.toDataset();
            this.objectInfo = DataInfoFactoryProvider.getInstance().createObjectInfo(this.seriesInfo, attributes, attributes.getString(524312));
            this.seriesInfo.addChild((IDataInfo)this.objectInfo);
        }
        return this.objectInfo;
    }

    public void insertReference(String string, String string2, String string3, String string4, int[] nArray) {
        if (this.objectInfo != null) {
            throw new IllegalStateException("Object info already created, no more modification allowed.");
        }
        this.builder.insertReference(UIDUtilities.getBaseType((String)string), string, string2, string3, string4, nArray);
    }
}

