/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.SingleObjectDataListener;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomParser;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.DicomCacheInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.IMPAXEEWADOInstanceInfo;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoFactory;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.dicomobject.type.ValueType;
import com.agfa.pacs.listtext.lta.filter.FilterEntryCriterion;
import com.agfa.pacs.listtext.lta.filter.FilterEntryTypes;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.SimpleFilter;
import com.agfa.pacs.listtext.lta.filter.SimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionFactory;
import com.agfa.pacs.listtext.lta.util.referencedobject.XDSILoadable;
import com.agfa.pacs.listtext.lta.util.referencedobject.XDSStudyInfo;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class KeyObjectParser {
    private static final ALogger log = ALogger.getLogger(KeyObjectParser.class);
    private static final FilterEntryCriterion instanceCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524312);
    private static final FilterEntryCriterion seriesCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000E);
    private static final FilterEntryCriterion studyCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000D);

    public static List<SOPInstanceReference> getKOReferences(Attributes attributes) {
        ArrayList<SOPInstanceReference> arrayList = new ArrayList<SOPInstanceReference>(3);
        if (!attributes.contains(4236149)) {
            return Collections.emptyList();
        }
        Sequence sequence = attributes.getSequence(4236149);
        if (sequence != null) {
            int n = 0;
            while (n < sequence.size()) {
                Attributes attributes2 = (Attributes)sequence.get(n);
                SOPInstanceReference sOPInstanceReference = new SOPInstanceReference(attributes2.getString(0x20000D));
                Sequence sequence2 = attributes2.getSequence(528661);
                if (sequence2 != null) {
                    int n2 = 0;
                    while (n2 < sequence2.size()) {
                        Sequence sequence3;
                        Attributes attributes3 = (Attributes)sequence2.get(n2);
                        ReferencedSeries referencedSeries = new ReferencedSeries(attributes3.getString(0x20000E));
                        if (attributes3.containsValue(524372)) {
                            referencedSeries.setRetrieveAETs(attributes3.getStrings(524372));
                        }
                        if (attributes3.containsValue(4251665)) {
                            referencedSeries.setRetrieveLocationUID(attributes3.getString(4251665));
                        }
                        if ((sequence3 = attributes3.getSequence(528793)) != null) {
                            referencedSeries.addReferencedSOPs(ReferencedSOP.createList((Attributes)attributes3, (int)528793));
                        }
                        if (!referencedSeries.referencedSOP().isEmpty()) {
                            sOPInstanceReference.addReferencedSeries(referencedSeries);
                        }
                        ++n2;
                    }
                }
                if (!sOPInstanceReference.referencedSeries().isEmpty()) {
                    arrayList.add(sOPInstanceReference);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static Map<String, SRReferencedImage> getDetailedImageReferences(Attributes attributes) {
        Sequence sequence = attributes.getSequence(4237104);
        if (sequence == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SRReferencedImage> hashMap = new HashMap<String, SRReferencedImage>(sequence.size());
        int n = 0;
        while (n < sequence.size()) {
            Attributes attributes2;
            Attributes attributes3 = (Attributes)sequence.get(n);
            ValueType valueType = ValueType.get((String)attributes3.getString(0x40A040));
            if (valueType == ValueType.Image && (attributes2 = (Attributes)attributes3.getSequence(528793).get(0)).contains(528736)) {
                SRReferencedImage sRReferencedImage = SRReferencedImage.create((Attributes)attributes2);
                hashMap.put(sRReferencedImage.getSOPInstanceUID(), sRReferencedImage);
            }
            ++n;
        }
        if (hashMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return hashMap;
    }

    public static Map<String, ReferencedSOP> getAllImageReferences(List<SOPInstanceReference> list) {
        HashMap<String, ReferencedSOP> hashMap = new HashMap<String, ReferencedSOP>();
        for (SOPInstanceReference sOPInstanceReference : list) {
            for (ReferencedSeries referencedSeries : sOPInstanceReference.referencedSeries()) {
                for (ReferencedSOP referencedSOP : referencedSeries.referencedSOP()) {
                    hashMap.put(referencedSOP.getSOPInstanceUID(), referencedSOP);
                }
            }
        }
        return hashMap;
    }

    public static IPersistantFilter getFilter(ReferencedSOP referencedSOP) {
        SimpleFilter simpleFilter = new SimpleFilter("KO Search");
        simpleFilter.addEntry(new SimpleFilterEntry(Level.Object, instanceCriterion, FilterEntryTypes.instanceEquals, new String[]{referencedSOP.getSOPInstanceUID()}));
        ReferencedSeries referencedSeries = referencedSOP.getSeries();
        if (referencedSeries != null) {
            simpleFilter.addEntry(new SimpleFilterEntry(Level.Series, seriesCriterion, FilterEntryTypes.instanceEquals, new String[]{referencedSeries.getSeriesInstanceUID()}));
            SOPInstanceReference sOPInstanceReference = referencedSeries.getStudyRef();
            if (sOPInstanceReference != null) {
                simpleFilter.addEntry(new SimpleFilterEntry(Level.Study, studyCriterion, FilterEntryTypes.instanceEquals, new String[]{sOPInstanceReference.getStudyInstanceUID()}));
            }
        }
        return simpleFilter;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<IStudyInfo> performWADOSearchForKOReferences(IPatientInfo iPatientInfo, Collection<ReferencedSOP> collection, IDataInfoNode iDataInfoNode) {
        HashMap<String, IDataInfoNode> hashMap = new HashMap<String, IDataInfoNode>();
        HashSet<IDataInfoNode> hashSet = new HashSet<IDataInfoNode>(3);
        for (IDataInfoNode iDataInfoNode2 : Base.getDataInfoNodes()) {
            if (!iDataInfoNode2.getType().contains("WADO")) continue;
            hashMap.put(iDataInfoNode2.getSourceAET(), iDataInfoNode2);
        }
        HashMap hashMap2 = new HashMap();
        IDicomDataRequester iDicomDataRequester = DicomDataRequester.getInstance();
        IDataInfoFactory iDataInfoFactory = DataInfoFactoryProvider.getInstance();
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        IDataInfoNode iDataInfoNode3 = null;
        for (ReferencedSOP referencedSOP : collection) {
            SingleObjectDataListener singleObjectDataListener;
            block13: {
                SingleObjectDataListener singleObjectDataListener2 = referencedSOP.getSeries().getRetrieveAETs();
                if (singleObjectDataListener2 == null) {
                    if (iDataInfoNode != null) {
                        iDataInfoNode3 = iDataInfoNode;
                        break block13;
                    } else {
                        log.warn("Object:" + referencedSOP + " is missing retrieve node");
                        continue;
                    }
                }
                singleObjectDataListener = singleObjectDataListener2;
                int n = ((String[])singleObjectDataListener).length;
                int n2 = 0;
                while (n2 < n) {
                    String string = singleObjectDataListener[n2];
                    iDataInfoNode3 = (IDataInfoNode)hashMap.get(string);
                    if (iDataInfoNode3 != null && !hashSet.contains(iDataInfoNode3)) break;
                    ++n2;
                }
            }
            DicomCacheInstanceInfo dicomCacheInstanceInfo = new DicomCacheInstanceInfo();
            if (iDataInfoNode3 == null) {
                log.warn("Source not found for:" + referencedSOP.getSOPInstanceUID());
                continue;
            }
            if (hashSet.contains(iDataInfoNode3)) {
                log.warn("Node '" + iDataInfoNode3.toString() + "' is unavailable at the moment. Can not retrieve " + referencedSOP.getSOPInstanceUID());
                continue;
            }
            URL uRL = IMPAXEEWADOInstanceInfo.makeFullURL((IDataInfoSource)iDataInfoNode3, (String)referencedSOP.getSeries().getStudyRef().getStudyInstanceUID(), (String)referencedSOP.getSeries().getSeriesInstanceUID(), (String)referencedSOP.getSOPInstanceUID());
            IDicomDataRequest iDicomDataRequest = iDicomDataRequester.createDicomDataRequest((ILoadableInfo)new XDSILoadable(referencedSOP, iPatientInfo, (IDataInfoSource)iDataInfoNode3), iDicomDataRequester.getDefaultPrority());
            singleObjectDataListener = new SingleObjectDataListener(referencedSOP.getSOPInstanceUID());
            iDicomDataRequest.setListener((IDicomDataListener)singleObjectDataListener);
            iDicomDataRequest.setFromCache(false);
            try {
                Attributes attributes;
                Attributes attributes2;
                InputStream inputStream = uRL.openConnection().getInputStream();
                IDicomParser iDicomParser = iDicomDataRequester.createParser(inputStream, referencedSOP.getSOPInstanceUID(), iDicomDataRequest, (IDicomDataListener)iDicomDataRequest);
                iDicomParser.parse();
                inputStream.close();
                Attributes attributes3 = singleObjectDataListener.getDataset();
                String string = String.valueOf(attributes3.getString(0x20000D, null)) + Level.Study;
                String string2 = String.valueOf(attributes3.getString(0x20000E, null)) + Level.Series;
                IDataInfo iDataInfo = (IDataInfo)hashMap2.get(string);
                if (iDataInfo == null) {
                    attributes2 = new Attributes();
                    attributes2.addSelected(attributes3, DicomCFindConst.STUDIES_MERGED_TAGS);
                    IStudyInfo iStudyInfo = iDataInfoFactory.createStudyInfo(iPatientInfo, attributes2, attributes3.getString(0x20000D, null));
                    XDSStudyInfo xDSStudyInfo = new XDSStudyInfo(iStudyInfo);
                    xDSStudyInfo.setSource((IDataInfoSource)iDataInfoNode3);
                    iPatientInfo.addChild((IDataInfo)xDSStudyInfo);
                    arrayList.add((IStudyInfo)xDSStudyInfo);
                    hashMap2.put(string, xDSStudyInfo);
                }
                if ((attributes2 = (IDataInfo)hashMap2.get(string2)) == null) {
                    void var22_29;
                    attributes = new Attributes();
                    attributes.addSelected(attributes3, DicomCFindConst.SERIES_MERGED_TAGS);
                    attributes2 = iDataInfoFactory.createSeriesInfo((IStudyInfo)var22_29, attributes, attributes3.getString(0x20000E, null));
                    attributes2.setSource((IDataInfoSource)iDataInfoNode3);
                    var22_29.addChild((IDataInfo)attributes2);
                    hashMap2.put(string2, attributes2);
                }
                attributes = iDataInfoFactory.createObjectInfo((ISeriesInfo)attributes2, attributes3, attributes3.getString(524312, null));
                attributes.setSource((IDataInfoSource)iDataInfoNode3);
                attributes.setInstanceInfo((IInstanceInfo)dicomCacheInstanceInfo);
                attributes2.addChild((IDataInfo)attributes);
            }
            catch (ConnectException connectException) {
                hashSet.add(iDataInfoNode3);
            }
            catch (IOException iOException) {
                log.error("Retrieve problem", (Throwable)iOException);
            }
        }
        return arrayList;
    }
}

