/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.util.PerformanceUtils;
import com.agfa.pacs.listtext.lta.util.referencedobject.IObjectReference;
import com.agfa.pacs.listtext.lta.util.referencedobject.IReferencedObjectProvider;
import com.agfa.pacs.listtext.lta.util.referencedobject.InvalidSessionLoadAbortion;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectProviderFactory;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencesNotFoundException;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectTypeCode;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.Attributes;

public class ReferencedObjectUtilities {
    private static final ALogger log = ALogger.getLogger(ReferencedObjectUtilities.class);

    public static List<IObjectInfo> extractReferencedObjects(Collection<? extends IObjectReference> collection) {
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        if (collection != null) {
            for (IObjectReference iObjectReference : collection) {
                IObjectInfo iObjectInfo = iObjectReference.getObject();
                if (iObjectInfo == null || arrayList.contains(iObjectInfo)) continue;
                arrayList.add(iObjectInfo);
            }
        }
        return arrayList;
    }

    public static List<IObjectInfo> findReferringObjects(IDataInfo iDataInfo, Collection<ReferringObjectType> collection) {
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        if (iDataInfo != null && collection != null && !collection.isEmpty()) {
            List list = iDataInfo.getHierarchyLevel() == Level.Study ? PerformanceUtils.getObjectLevel((IStudyInfo)iDataInfo) : DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IObjectInfo.class);
            for (IObjectInfo iObjectInfo : list) {
                if (!ReferencedObjectUtilities.matches(iObjectInfo, collection)) continue;
                arrayList.add(iObjectInfo);
            }
        }
        return arrayList;
    }

    public static List<ReferringObjectType> getAllTypes() {
        ArrayList<ReferringObjectType> arrayList = new ArrayList<ReferringObjectType>();
        arrayList.add(ReferringObjectType.ALL_KO);
        arrayList.add(ReferringObjectType.PRESENTATION_STATE);
        arrayList.add(ReferringObjectType.TEACHING_FILE_REPORT);
        arrayList.add(ReferringObjectType.SESSION);
        return arrayList;
    }

    public static ReferencedResult getReferencedObjects(Collection<? extends IDataInfo> collection, List<ReferringObjectType> list, boolean bl) throws InvalidSessionLoadAbortion, ReferencesNotFoundException {
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>(collection);
        ReferencedResult referencedResult = new ReferencedResult(arrayList);
        Set<String> set = null;
        for (IDataInfo iDataInfo : collection) {
            IReferencedObjectProvider iReferencedObjectProvider = ReferencedObjectProviderFactory.getInstance().getSupportedReferencedObjectProvider(iDataInfo.getSource());
            if (iReferencedObjectProvider == null || !iReferencedObjectProvider.referencedObjectsAvailable(iDataInfo, list, false)) continue;
            if (set == null) {
                set = ReferencedObjectUtilities.createDataKeysSet(collection);
            }
            try {
                List<ReferencedObject> list2 = iReferencedObjectProvider.getReferencedObjects(iDataInfo, list, false, bl);
                if (list2 == null || list2.isEmpty()) continue;
                for (ReferencedObject referencedObject : list2) {
                    IObjectInfo iObjectInfo = referencedObject.getObject();
                    ISeriesInfo iSeriesInfo = iObjectInfo.getSeries();
                    IStudyInfo iStudyInfo = iSeriesInfo.getStudy();
                    IPatientInfo iPatientInfo = iStudyInfo.getPatient();
                    if (set.contains(String.valueOf(iObjectInfo.getKey()) + iObjectInfo.getHierarchyLevel()) || set.contains(String.valueOf(iSeriesInfo.getKey()) + iSeriesInfo.getHierarchyLevel()) || set.contains(String.valueOf(iStudyInfo.getKey()) + iStudyInfo.getHierarchyLevel()) || set.contains(String.valueOf(iPatientInfo.getKey()) + iPatientInfo.getHierarchyLevel())) continue;
                    arrayList.add((IDataInfo)iObjectInfo);
                    set.add(String.valueOf(iObjectInfo.getKey()) + iObjectInfo.getHierarchyLevel());
                }
                referencedResult.addReferringObject(list2.get(0).getReferringObject());
            }
            catch (InvalidSessionLoadAbortion invalidSessionLoadAbortion) {
                throw invalidSessionLoadAbortion;
            }
            catch (ReferencesNotFoundException referencesNotFoundException) {
                log.error("Getting referenced objects of '" + iDataInfo.getKey() + "' failed", (Throwable)referencesNotFoundException);
                throw referencesNotFoundException;
            }
        }
        return referencedResult;
    }

    private static Set<String> createDataKeysSet(Collection<? extends IDataInfo> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (IDataInfo iDataInfo : collection) {
            ReferencedObjectUtilities.addDataKeys(hashSet, iDataInfo);
        }
        return hashSet;
    }

    private static void addDataKeys(Set<String> set, IDataInfo iDataInfo) {
        boolean bl;
        switch (iDataInfo.getHierarchyLevel()) {
            case Patient: {
                bl = false;
                break;
            }
            case Study: {
                bl = ReferencedObjectUtilities.isCompleteStudy(iDataInfo);
                break;
            }
            case Series: {
                bl = ReferencedObjectUtilities.isCompleteSeries(iDataInfo);
                break;
            }
            case Object: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            set.add(String.valueOf(iDataInfo.getKey()) + iDataInfo.getHierarchyLevel());
        } else {
            for (IDataInfo iDataInfo2 : iDataInfo.children()) {
                ReferencedObjectUtilities.addDataKeys(set, iDataInfo2);
            }
        }
    }

    public static boolean isCompleteStudy(IDataInfo iDataInfo) {
        if (iDataInfo.childrenAvailable() && iDataInfo.getAttributes().containsValue(2101766)) {
            int n = iDataInfo.getInt(2101766);
            return iDataInfo.children().size() >= n;
        }
        int n = DataInfoUtilities.getExpandedObjects((IDataInfo)iDataInfo).size();
        return n > 0 && n == ReferencedObjectUtilities.getNumberOfStudyRelatedInstances(iDataInfo);
    }

    private static boolean isCompleteSeries(IDataInfo iDataInfo) {
        int n = DataInfoUtilities.getExpandedObjects((IDataInfo)iDataInfo).size();
        return n == 0 || n == ReferencedObjectUtilities.getNumberOfSeriesRelatedInstances(iDataInfo);
    }

    private static int getNumberOfStudyRelatedInstances(IDataInfo iDataInfo) {
        if (iDataInfo.getAttributes().containsValue(2101768)) {
            return iDataInfo.getInt(2101768);
        }
        return -1;
    }

    private static int getNumberOfSeriesRelatedInstances(IDataInfo iDataInfo) {
        if (iDataInfo.getAttributes().containsValue(2101769)) {
            return iDataInfo.getInt(2101769);
        }
        return -1;
    }

    public static boolean hasKOType(Collection<ReferringObjectType> collection) {
        if (collection != null) {
            for (ReferringObjectType referringObjectType : collection) {
                if (!referringObjectType.isKOType()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPresentationStateType(Collection<ReferringObjectType> collection) {
        if (collection != null) {
            for (ReferringObjectType referringObjectType : collection) {
                if (!referringObjectType.isPresentationStateType()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matches(Attributes attributes, Collection<ReferringObjectType> collection) {
        if (collection == null) {
            return true;
        }
        if (attributes != null) {
            for (ReferringObjectType referringObjectType : collection) {
                if (!referringObjectType.match(attributes)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matches(IObjectInfo iObjectInfo, Collection<ReferringObjectType> collection) {
        if (collection == null) {
            return true;
        }
        if (iObjectInfo != null) {
            for (ReferringObjectType referringObjectType : collection) {
                if (!referringObjectType.match((IDataInfo)iObjectInfo)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsMatchingObject(Collection<IObjectInfo> collection, Collection<ReferringObjectType> collection2) {
        for (IObjectInfo iObjectInfo : collection) {
            if (!UIDUtilities.isType((String)iObjectInfo.getSOPClassUID(), (UIDType)UIDType.KeyObject)) continue;
            return ReferencedObjectUtilities.matchPreferedKOTypes(iObjectInfo, collection2);
        }
        return false;
    }

    public static boolean matchPreferedKOTypes(IObjectInfo iObjectInfo, Collection<ReferringObjectType> collection) {
        Code code = Code.create((Attributes)iObjectInfo.getAttributes(), (int)4235331);
        if (code == null) {
            return false;
        }
        ReferringObjectTypeCode enum_ = null;
        ReferringObjectTypeCode[] referringObjectTypeCodeArray = ReferringObjectTypeCode.values();
        int n = referringObjectTypeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferringObjectTypeCode enum_2 = referringObjectTypeCodeArray[n2];
            if (enum_2.getTitle() != null && enum_2.getTitle().getCodeValue().equals(code.getCodeValue())) {
                enum_ = enum_2;
                break;
            }
            ++n2;
        }
        if (enum_ == null) {
            return false;
        }
        for (ReferringObjectType referringObjectType : collection) {
            if (!referringObjectType.hasCode(enum_)) continue;
            return true;
        }
        return false;
    }

    public static class ReferencedResult {
        public final List<IDataInfo> toOpen;
        private final List<ReferringObject> mergedData;

        public ReferencedResult(List<IDataInfo> list) {
            this.toOpen = list;
            this.mergedData = new ArrayList<ReferringObject>(2);
        }

        void addReferringObject(ReferringObject referringObject) {
            if (referringObject.isTemporaryMergedPatient()) {
                this.mergedData.add(referringObject);
            }
        }

        public boolean containsMergedData() {
            return !this.mergedData.isEmpty();
        }

        public int getMergedDataCount() {
            return this.mergedData.size();
        }

        public ReferringObject getMergedData(int n) {
            return this.mergedData.get(0);
        }
    }
}

