/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.lta.util.referencedobject.IObjectReference;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.tools.CompareUtils;
import org.dcm4che3.data.Attributes;

public final class ReferringObject
implements IObjectReference {
    private ReferringObjectType type;
    private boolean isTemporaryMergedPatient = false;
    private boolean isAutoGeneratedKeyImage;
    private IObjectInfo object;

    public ReferringObject(ReferringObjectType referringObjectType, IObjectInfo iObjectInfo) {
        this.object = iObjectInfo;
        this.type = referringObjectType;
    }

    public void setAttributes(Attributes attributes) {
        if (ReferringObject.isTemporaryMergedPatientSession(attributes)) {
            this.isTemporaryMergedPatient = true;
        }
        if (ReferringObject.isAutoGeneratedKeyImage(attributes)) {
            this.isAutoGeneratedKeyImage = true;
        }
    }

    public static boolean isTemporaryMergedPatientSession(Attributes attributes) {
        return attributes.contains("TIANI", 2687059);
    }

    public static boolean isAutoGeneratedKeyImage(Attributes attributes) {
        String string = attributes.getString("TIANI", 7405672);
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public boolean isTemporaryMergedPatient() {
        return this.isTemporaryMergedPatient;
    }

    public boolean isAutoGeneratedKeyImage() {
        return this.isAutoGeneratedKeyImage;
    }

    @Override
    public IObjectInfo getObject() {
        return this.object;
    }

    public ReferringObjectType getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReferringObject)) {
            return false;
        }
        ReferringObject referringObject = (ReferringObject)object;
        return CompareUtils.equals((Object)((Object)this.type), (Object)((Object)referringObject.type)) && this.object.equalsKey((IDataInfo)referringObject.object);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.type.hashCode();
        n = 37 * n + this.object.getKey().hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("Referring Object '");
        stringBuilder.append((Object)this.type);
        stringBuilder.append("': ");
        stringBuilder.append(this.object);
        return stringBuilder.toString();
    }
}

