/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectTypeCode;
import org.dcm4che3.data.Attributes;

public enum ReferringObjectType {
    SESSION(ReferringObjectTypeCode.SESSION),
    PRESENTATION_STATE(ReferringObjectTypeCode.PRESENTATION_STATE),
    TEACHING_FILE_REPORT(ReferringObjectTypeCode.TEACHING_FILE_REPORT),
    OF_INTEREST(true, ReferringObjectTypeCode.OF_INTEREST),
    FOR_CONFERENCE(true, ReferringObjectTypeCode.FOR_CONFERENCE),
    FOR_PRINTING(true, ReferringObjectTypeCode.FOR_PRINTING, ReferringObjectTypeCode.FOR_PRINTING_TIANI),
    FOR_XDS(true, ReferringObjectTypeCode.FOR_XDS),
    QUALITY_ISSUE(ReferringObjectTypeCode.QUALITY_ISSUE, ReferringObjectTypeCode.QUALITY_ISSUE_DETECTOR_ARTEFACTS, ReferringObjectTypeCode.QUALITY_ISSUE_DOUBLE_EXPOSURE, ReferringObjectTypeCode.QUALITY_ISSUE_ELECTRICAL_FAILURE, ReferringObjectTypeCode.QUALITY_ISSUE_GRID_ARTEFACTS, ReferringObjectTypeCode.QUALITY_ISSUE_IMAGE_ARTEFACTS, ReferringObjectTypeCode.QUALITY_ISSUE_INAPPROPRIATE_IMAGEPROCESSING, ReferringObjectTypeCode.QUALITY_ISSUE_MECHANICAL_FAILURE, ReferringObjectTypeCode.QUALITY_ISSUE_MOTION_BLUR, ReferringObjectTypeCode.QUALITY_ISSUE_NO_IMAGE, ReferringObjectTypeCode.QUALITY_ISSUE_OTHER_ARTEFACTS, ReferringObjectTypeCode.QUALITY_ISSUE_OTHER_FAILURE, ReferringObjectTypeCode.QUALITY_ISSUE_OVEREXPOSED, ReferringObjectTypeCode.QUALITY_ISSUE_UNDEREXPOSED, ReferringObjectTypeCode.QUALITY_ISSUE_POSITIONING, ReferringObjectTypeCode.QUALITY_ISSUE_SOFTWARE_FAILURE, ReferringObjectTypeCode.QUALITY_ISSUE_UNKNOWN_FAILURE),
    REJECTED_FOR_QUALITY_REASONS(ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_DETECTOR_ARTEFACTS, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_DOUBLE_EXPOSURE, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_ELECTRICAL_FAILURE, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_GRID_ARTEFACTS, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_IMAGE_ARTEFACTS, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_INAPPROPRIATE_IMAGEPROCESSING, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_MECHANICAL_FAILURE, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_MOTION_BLUR, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_NO_IMAGE, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_OTHER_ARTEFACTS, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_OTHER_FAILURE, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_OVEREXPOSED, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_UNDEREXPOSED, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_POSITIONING, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_SOFTWARE_FAILURE, ReferringObjectTypeCode.REJECTED_FOR_QUALITY_REASONS_UNKNOWN_FAILURE),
    ALL_KO(ReferringObjectTypeCode.OF_INTEREST, ReferringObjectTypeCode.FOR_CONFERENCE, ReferringObjectTypeCode.FOR_PRINTING, ReferringObjectTypeCode.FOR_PRINTING_TIANI, ReferringObjectTypeCode.FOR_PEER_REVIEW, ReferringObjectTypeCode.FOR_SURGERY, ReferringObjectTypeCode.FOR_RESEARCH, ReferringObjectTypeCode.FOR_TEACHING, ReferringObjectTypeCode.FOR_THERAPY, ReferringObjectTypeCode.FOR_REPORT_ATTACHMENT, ReferringObjectTypeCode.FOR_PATIENT, ReferringObjectTypeCode.FOR_REFERRING_PROVIDER, ReferringObjectTypeCode.BEST_IN_SET, ReferringObjectTypeCode.MANIFEST, ReferringObjectTypeCode.SIGNED_MANIFEST, ReferringObjectTypeCode.COMPLETE_STUDY_CONTENT, ReferringObjectTypeCode.SIGNED_COMPLETE_STUDY_CONTENT, ReferringObjectTypeCode.COMPLETE_ACQUISITION_CONTENT, ReferringObjectTypeCode.SIGNED_COMPLETE_ACQUISITION_CONTENT);

    private ReferringObjectTypeCode[] codes;
    private boolean saveable;

    private ReferringObjectType(ReferringObjectTypeCode ... referringObjectTypeCodeArray) {
        this(false, referringObjectTypeCodeArray);
    }

    private ReferringObjectType(boolean bl, ReferringObjectTypeCode ... referringObjectTypeCodeArray) {
        this.codes = referringObjectTypeCodeArray;
        this.saveable = bl;
    }

    public static ReferringObjectType[] koValues() {
        return new ReferringObjectType[]{ALL_KO, OF_INTEREST, FOR_CONFERENCE, FOR_PRINTING};
    }

    public String toString() {
        return Messages.getString("ReferringObjectType." + this.name());
    }

    public ReferringObjectTypeCode[] getCodes() {
        return this.codes;
    }

    public boolean hasCode(ReferringObjectTypeCode referringObjectTypeCode) {
        if (this.codes == null) {
            return false;
        }
        ReferringObjectTypeCode[] referringObjectTypeCodeArray = this.codes;
        int n = this.codes.length;
        int n2 = 0;
        while (n2 < n) {
            ReferringObjectTypeCode referringObjectTypeCode2 = referringObjectTypeCodeArray[n2];
            if (referringObjectTypeCode2 == referringObjectTypeCode) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Code getDicomCode() {
        return this.codes[0].getTitle();
    }

    public String getDescription() {
        return CodeDictionary.getLocalizedCodeMeaning((Code)this.codes[0].getTitle());
    }

    public boolean match(IDataInfo iDataInfo) {
        if (this.codes != null) {
            ReferringObjectTypeCode[] referringObjectTypeCodeArray = this.codes;
            int n = this.codes.length;
            int n2 = 0;
            while (n2 < n) {
                ReferringObjectTypeCode referringObjectTypeCode = referringObjectTypeCodeArray[n2];
                if (referringObjectTypeCode.match(iDataInfo)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean match(Attributes attributes) {
        if (this.codes != null) {
            ReferringObjectTypeCode[] referringObjectTypeCodeArray = this.codes;
            int n = this.codes.length;
            int n2 = 0;
            while (n2 < n) {
                ReferringObjectTypeCode referringObjectTypeCode = referringObjectTypeCodeArray[n2];
                if (referringObjectTypeCode.match(attributes)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isKOType() {
        return !this.isPresentationStateType() && !this.isTeachingFileReportType();
    }

    public boolean isPresentationStateType() {
        return PRESENTATION_STATE == this;
    }

    public boolean isSessionType() {
        return SESSION == this;
    }

    public boolean isTeachingFileReportType() {
        return TEACHING_FILE_REPORT == this;
    }

    public boolean isSaveable() {
        return this.saveable;
    }

    public static ReferringObjectType valueOf(String string) {
        return Enum.valueOf(ReferringObjectType.class, string);
    }
}

