/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.util.Modality;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

enum ReferringObjectTypeCode {
    SESSION(CodeDictionary.TianiKeyObjectSelectionDocumentTitle.Session),
    PRESENTATION_STATE(Modality.PR, UIDType.Presentation, null),
    TEACHING_FILE_REPORT(Modality.SR, UIDType.StructuredReport, new Code("IHERADTF", "TCE006", "Additional Teaching File Information")),
    OF_INTEREST(CodeDictionary.KeyObjectSelectionDocumentTitle.OfInterest),
    FOR_CONFERENCE(CodeDictionary.KeyObjectSelectionDocumentTitle.ForConference),
    FOR_PRINTING(CodeDictionary.KeyObjectSelectionDocumentTitle.ForPrinting),
    FOR_PRINTING_TIANI(CodeDictionary.TianiKeyObjectSelectionDocumentTitle.ForPrinting),
    FOR_PEER_REVIEW(CodeDictionary.KeyObjectSelectionDocumentTitle.ForPeerReview),
    FOR_SURGERY(CodeDictionary.KeyObjectSelectionDocumentTitle.ForSurgery),
    FOR_RESEARCH(CodeDictionary.KeyObjectSelectionDocumentTitle.ForResearch),
    FOR_TEACHING(CodeDictionary.KeyObjectSelectionDocumentTitle.ForTeaching),
    FOR_THERAPY(CodeDictionary.KeyObjectSelectionDocumentTitle.ForTherapy),
    FOR_REPORT_ATTACHMENT(CodeDictionary.KeyObjectSelectionDocumentTitle.ForReportAttachment),
    FOR_PATIENT(CodeDictionary.KeyObjectSelectionDocumentTitle.ForPatient),
    FOR_REFERRING_PROVIDER(CodeDictionary.KeyObjectSelectionDocumentTitle.ForReferringProvider),
    FOR_XDS(CodeDictionary.KeyObjectSelectionDocumentTitle.ForXDS),
    BEST_IN_SET(CodeDictionary.KeyObjectSelectionDocumentTitle.BestInSet),
    MANIFEST(CodeDictionary.KeyObjectSelectionDocumentTitle.Manifest),
    SIGNED_MANIFEST(CodeDictionary.KeyObjectSelectionDocumentTitle.SignedManifest),
    COMPLETE_STUDY_CONTENT(CodeDictionary.KeyObjectSelectionDocumentTitle.CompleteStudyContent),
    SIGNED_COMPLETE_STUDY_CONTENT(CodeDictionary.KeyObjectSelectionDocumentTitle.SignedCompleteStudyContent),
    COMPLETE_ACQUISITION_CONTENT(CodeDictionary.KeyObjectSelectionDocumentTitle.CompleteAcquisitionContent),
    SIGNED_COMPLETE_ACQUISITION_CONTENT(CodeDictionary.KeyObjectSelectionDocumentTitle.SignedCompleteAcquisitionContent),
    QUALITY_ISSUE(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue),
    QUALITY_ISSUE_DETECTOR_ARTEFACTS(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.DetectorArtefacts),
    QUALITY_ISSUE_DOUBLE_EXPOSURE(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.DoubleExposure),
    QUALITY_ISSUE_ELECTRICAL_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.ElectricalFailure),
    QUALITY_ISSUE_GRID_ARTEFACTS(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.GridArtefacts),
    QUALITY_ISSUE_IMAGE_ARTEFACTS(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.ImageArtefacts),
    QUALITY_ISSUE_INAPPROPRIATE_IMAGEPROCESSING(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.InappropriateImageProcessing),
    QUALITY_ISSUE_MECHANICAL_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.MechanicalFailure),
    QUALITY_ISSUE_MOTION_BLUR(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.MotionBlur),
    QUALITY_ISSUE_NO_IMAGE(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.NoImage),
    QUALITY_ISSUE_OTHER_ARTEFACTS(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.OtherArtefacts),
    QUALITY_ISSUE_OTHER_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.OtherFailure),
    QUALITY_ISSUE_OVEREXPOSED(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.OverExposed),
    QUALITY_ISSUE_UNDEREXPOSED(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.UnderExposed),
    QUALITY_ISSUE_POSITIONING(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.Positioning),
    QUALITY_ISSUE_SOFTWARE_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.SoftwareFailure),
    QUALITY_ISSUE_UNKNOWN_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.QualityIssue, CodeDictionary.RejectedForQualityReasons.UnknownFailure),
    REJECTED_FOR_QUALITY_REASONS(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons),
    REJECTED_FOR_QUALITY_REASONS_DETECTOR_ARTEFACTS(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.DetectorArtefacts),
    REJECTED_FOR_QUALITY_REASONS_DOUBLE_EXPOSURE(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.DoubleExposure),
    REJECTED_FOR_QUALITY_REASONS_ELECTRICAL_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.ElectricalFailure),
    REJECTED_FOR_QUALITY_REASONS_GRID_ARTEFACTS(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.GridArtefacts),
    REJECTED_FOR_QUALITY_REASONS_IMAGE_ARTEFACTS(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.ImageArtefacts),
    REJECTED_FOR_QUALITY_REASONS_INAPPROPRIATE_IMAGEPROCESSING(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.InappropriateImageProcessing),
    REJECTED_FOR_QUALITY_REASONS_MECHANICAL_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.MechanicalFailure),
    REJECTED_FOR_QUALITY_REASONS_MOTION_BLUR(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.MotionBlur),
    REJECTED_FOR_QUALITY_REASONS_NO_IMAGE(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.NoImage),
    REJECTED_FOR_QUALITY_REASONS_OTHER_ARTEFACTS(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.OtherArtefacts),
    REJECTED_FOR_QUALITY_REASONS_OTHER_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.OtherFailure),
    REJECTED_FOR_QUALITY_REASONS_OVEREXPOSED(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.OverExposed),
    REJECTED_FOR_QUALITY_REASONS_UNDEREXPOSED(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.UnderExposed),
    REJECTED_FOR_QUALITY_REASONS_POSITIONING(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.Positioning),
    REJECTED_FOR_QUALITY_REASONS_SOFTWARE_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.SoftwareFailure),
    REJECTED_FOR_QUALITY_REASONS_UNKNOWN_FAILURE(CodeDictionary.KeyObjectSelectionDocumentTitle.RejectedForQualityReasons, CodeDictionary.RejectedForQualityReasons.UnknownFailure);

    private final Modality modality;
    private final UIDType uidType;
    private Code title;
    private Code titleModification;

    private ReferringObjectTypeCode(Code code) {
        this(code, null);
    }

    private ReferringObjectTypeCode(Code code, Code code2) {
        this(Modality.KO, UIDType.KeyObject, code, code2);
    }

    private ReferringObjectTypeCode(Modality modality, UIDType uIDType, Code code) {
        this(modality, uIDType, code, null);
    }

    private ReferringObjectTypeCode(Modality modality, UIDType uIDType, Code code, Code code2) {
        this.modality = modality;
        this.uidType = uIDType;
        this.title = code;
        this.titleModification = code2;
    }

    public Code getTitle() {
        return this.title;
    }

    public Code getTitleModifier() {
        return this.titleModification;
    }

    public boolean match(IDataInfo iDataInfo) {
        return this.match(iDataInfo, false);
    }

    public boolean match(Attributes attributes) {
        try {
            if (this.title != null) {
                boolean bl;
                Code code = ReferringObjectTypeCode.getKeyObjectDocumentTitle(attributes);
                Collection<Code> collection = ReferringObjectTypeCode.getKeyObjectDocumentTitleModifiers(attributes);
                boolean bl2 = this.title.getCodeValue().equals(code.getCodeValue());
                if (this.titleModification != null && !collection.isEmpty()) {
                    bl = false;
                    for (Code code2 : collection) {
                        if (!this.titleModification.getCodeValue().equals(code2.getCodeValue())) continue;
                        bl = true;
                        break;
                    }
                } else {
                    bl = true;
                }
                return bl2 && bl;
            }
            if (UIDUtilities.isType((String)attributes.getString(524310), (UIDType)this.uidType)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private boolean match(IDataInfo iDataInfo, boolean bl) {
        if (iDataInfo instanceof IPatientInfo || iDataInfo instanceof IStudyInfo) {
            List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IStudyInfo.class);
            for (IStudyInfo iStudyInfo : list) {
                Object[] objectArray = iStudyInfo.getAttributes().getStrings(524385);
                if (objectArray == null) continue;
                if (!ArrayUtils.contains((Object[])objectArray, (Object)this.modality.dicom())) {
                    return false;
                }
                if (bl) {
                    if (SESSION.equals((Object)this)) {
                        return objectArray.length == 1;
                    }
                    return true;
                }
                List list2 = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, ISeriesInfo.class);
                for (ISeriesInfo iSeriesInfo : list2) {
                    if (!this.match((IDataInfo)iSeriesInfo, false)) continue;
                    return true;
                }
            }
        } else if (iDataInfo instanceof ISeriesInfo) {
            if (this.modality.dicom().equals(iDataInfo.getAttributes().getString(524384, null))) {
                return this.title == null || bl || this.containsMatchingObject(DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IObjectInfo.class));
            }
        } else if (iDataInfo instanceof IObjectInfo) {
            block14: {
                block15: {
                    try {
                        String string = ((IObjectInfo)iDataInfo).getSOPClassUID();
                        if (!UIDUtilities.isType((String)string, (UIDType)this.uidType)) break block14;
                        if (this.title != null) break block15;
                        return true;
                    }
                    catch (Exception exception) {}
                }
                Code code = Code.create((Attributes)iDataInfo.getAttributes(), (int)4235331);
                return this.title.getCodeValue().equals(code.getCodeValue());
            }
            return false;
        }
        return false;
    }

    private boolean containsMatchingObject(List<IObjectInfo> list) {
        for (IObjectInfo iObjectInfo : list) {
            if (!this.match((IDataInfo)iObjectInfo, false)) continue;
            return true;
        }
        return false;
    }

    private static Code getKeyObjectDocumentTitle(Attributes attributes) {
        try {
            return Code.create((Attributes)attributes, (int)4235331);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Collection<Code> getKeyObjectDocumentTitleModifiers(Attributes attributes) {
        try {
            ArrayList<Code> arrayList = new ArrayList<Code>();
            Sequence sequence = attributes.getSequence(4237104);
            if (sequence != null) {
                int n = 0;
                while (n < sequence.size()) {
                    Attributes attributes2 = (Attributes)sequence.get(n);
                    if ("CODE".equals(attributes2.getString(0x40A040))) {
                        arrayList.add(Code.create((Attributes)attributes2));
                    }
                    ++n;
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

