/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.otp;

import com.agfa.pacs.listtext.otp.BaseNCodec;
import com.agfa.pacs.listtext.otp.StringUtils;

public class Base32
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 5;
    private static final int BYTES_PER_ENCODED_BLOCK = 8;
    private static final int BYTES_PER_UNENCODED_BLOCK = 5;
    private static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] DECODE_TABLE;
    private static final byte[] ENCODE_TABLE;
    private static final byte[] HEX_DECODE_TABLE;
    private static final byte[] HEX_ENCODE_TABLE;
    private static final int MASK_5BITS = 31;
    private final int decodeSize;
    private final byte[] decodeTable;
    private final int encodeSize;
    private final byte[] encodeTable;
    private final byte[] lineSeparator;

    static {
        byte[] byArray = new byte[123];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[48] = -1;
        byArray[49] = -1;
        byArray[50] = 26;
        byArray[51] = 27;
        byArray[52] = 28;
        byArray[53] = 29;
        byArray[54] = 30;
        byArray[55] = 31;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[98] = 1;
        byArray[99] = 2;
        byArray[100] = 3;
        byArray[101] = 4;
        byArray[102] = 5;
        byArray[103] = 6;
        byArray[104] = 7;
        byArray[105] = 8;
        byArray[106] = 9;
        byArray[107] = 10;
        byArray[108] = 11;
        byArray[109] = 12;
        byArray[110] = 13;
        byArray[111] = 14;
        byArray[112] = 15;
        byArray[113] = 16;
        byArray[114] = 17;
        byArray[115] = 18;
        byArray[116] = 19;
        byArray[117] = 20;
        byArray[118] = 21;
        byArray[119] = 22;
        byArray[120] = 23;
        byArray[121] = 24;
        byArray[122] = 25;
        DECODE_TABLE = byArray;
        ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
        byte[] byArray2 = new byte[119];
        byArray2[0] = -1;
        byArray2[1] = -1;
        byArray2[2] = -1;
        byArray2[3] = -1;
        byArray2[4] = -1;
        byArray2[5] = -1;
        byArray2[6] = -1;
        byArray2[7] = -1;
        byArray2[8] = -1;
        byArray2[9] = -1;
        byArray2[10] = -1;
        byArray2[11] = -1;
        byArray2[12] = -1;
        byArray2[13] = -1;
        byArray2[14] = -1;
        byArray2[15] = -1;
        byArray2[16] = -1;
        byArray2[17] = -1;
        byArray2[18] = -1;
        byArray2[19] = -1;
        byArray2[20] = -1;
        byArray2[21] = -1;
        byArray2[22] = -1;
        byArray2[23] = -1;
        byArray2[24] = -1;
        byArray2[25] = -1;
        byArray2[26] = -1;
        byArray2[27] = -1;
        byArray2[28] = -1;
        byArray2[29] = -1;
        byArray2[30] = -1;
        byArray2[31] = -1;
        byArray2[32] = -1;
        byArray2[33] = -1;
        byArray2[34] = -1;
        byArray2[35] = -1;
        byArray2[36] = -1;
        byArray2[37] = -1;
        byArray2[38] = -1;
        byArray2[39] = -1;
        byArray2[40] = -1;
        byArray2[41] = -1;
        byArray2[42] = -1;
        byArray2[43] = -1;
        byArray2[44] = -1;
        byArray2[45] = -1;
        byArray2[46] = -1;
        byArray2[47] = -1;
        byArray2[49] = 1;
        byArray2[50] = 2;
        byArray2[51] = 3;
        byArray2[52] = 4;
        byArray2[53] = 5;
        byArray2[54] = 6;
        byArray2[55] = 7;
        byArray2[56] = 8;
        byArray2[57] = 9;
        byArray2[58] = -1;
        byArray2[59] = -1;
        byArray2[60] = -1;
        byArray2[61] = -1;
        byArray2[62] = -1;
        byArray2[63] = -1;
        byArray2[64] = -1;
        byArray2[65] = 10;
        byArray2[66] = 11;
        byArray2[67] = 12;
        byArray2[68] = 13;
        byArray2[69] = 14;
        byArray2[70] = 15;
        byArray2[71] = 16;
        byArray2[72] = 17;
        byArray2[73] = 18;
        byArray2[74] = 19;
        byArray2[75] = 20;
        byArray2[76] = 21;
        byArray2[77] = 22;
        byArray2[78] = 23;
        byArray2[79] = 24;
        byArray2[80] = 25;
        byArray2[81] = 26;
        byArray2[82] = 27;
        byArray2[83] = 28;
        byArray2[84] = 29;
        byArray2[85] = 30;
        byArray2[86] = 31;
        byArray2[87] = -1;
        byArray2[88] = -1;
        byArray2[89] = -1;
        byArray2[90] = -1;
        byArray2[91] = -1;
        byArray2[92] = -1;
        byArray2[93] = -1;
        byArray2[94] = -1;
        byArray2[95] = -1;
        byArray2[96] = -1;
        byArray2[97] = 10;
        byArray2[98] = 11;
        byArray2[99] = 12;
        byArray2[100] = 13;
        byArray2[101] = 14;
        byArray2[102] = 15;
        byArray2[103] = 16;
        byArray2[104] = 17;
        byArray2[105] = 18;
        byArray2[106] = 19;
        byArray2[107] = 20;
        byArray2[108] = 21;
        byArray2[109] = 22;
        byArray2[110] = 23;
        byArray2[111] = 24;
        byArray2[112] = 25;
        byArray2[113] = 26;
        byArray2[114] = 27;
        byArray2[115] = 28;
        byArray2[116] = 29;
        byArray2[117] = 30;
        byArray2[118] = 31;
        HEX_DECODE_TABLE = byArray2;
        HEX_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86};
    }

    public Base32() {
        this(false);
    }

    public Base32(byte by) {
        this(false, by);
    }

    public Base32(boolean bl) {
        this(0, null, bl, 61);
    }

    public Base32(boolean bl, byte by) {
        this(0, null, bl, by);
    }

    public Base32(int n) {
        this(n, CHUNK_SEPARATOR);
    }

    public Base32(int n, byte[] byArray) {
        this(n, byArray, false, 61);
    }

    public Base32(int n, byte[] byArray, boolean bl) {
        this(n, byArray, bl, 61);
    }

    public Base32(int n, byte[] byArray, boolean bl, byte by) {
        super(5, 8, n, byArray == null ? 0 : byArray.length, by);
        if (bl) {
            this.encodeTable = HEX_ENCODE_TABLE;
            this.decodeTable = HEX_DECODE_TABLE;
        } else {
            this.encodeTable = ENCODE_TABLE;
            this.decodeTable = DECODE_TABLE;
        }
        if (n > 0) {
            if (byArray == null) {
                throw new IllegalArgumentException("lineLength " + n + " > 0, but lineSeparator is null");
            }
            if (this.containsAlphabetOrPad(byArray)) {
                String string = StringUtils.newStringUtf8(byArray);
                throw new IllegalArgumentException("lineSeparator must not contain Base32 characters: [" + string + "]");
            }
            this.encodeSize = 8 + byArray.length;
            this.lineSeparator = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.lineSeparator, 0, byArray.length);
        } else {
            this.encodeSize = 8;
            this.lineSeparator = null;
        }
        this.decodeSize = this.encodeSize - 1;
        if (this.isInAlphabet(by) || Base32.isWhiteSpace(by)) {
            throw new IllegalArgumentException("pad must not be in alphabet or whitespace");
        }
    }

    @Override
    void decode(byte[] byArray, int n, int n2, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n2 < 0) {
            context.eof = true;
        }
        int n3 = 0;
        while (n3 < n2) {
            byte by;
            byte by2;
            if ((by2 = byArray[n++]) == this.pad) {
                context.eof = true;
                break;
            }
            byte[] byArray2 = this.ensureBufferSize(this.decodeSize, context);
            if (by2 >= 0 && by2 < this.decodeTable.length && (by = this.decodeTable[by2]) >= 0) {
                context.modulus = (context.modulus + 1) % 8;
                context.lbitWorkArea = (context.lbitWorkArea << 5) + (long)by;
                if (context.modulus == 0) {
                    byArray2[context.pos++] = (byte)(context.lbitWorkArea >> 32 & 0xFFL);
                    byArray2[context.pos++] = (byte)(context.lbitWorkArea >> 24 & 0xFFL);
                    byArray2[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                    byArray2[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                    byArray2[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                }
            }
            ++n3;
        }
        if (context.eof && context.modulus >= 2) {
            byte[] byArray3 = this.ensureBufferSize(this.decodeSize, context);
            switch (context.modulus) {
                case 2: {
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 2 & 0xFFL);
                    break;
                }
                case 3: {
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 7 & 0xFFL);
                    break;
                }
                case 4: {
                    context.lbitWorkArea >>= 4;
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                    break;
                }
                case 5: {
                    context.lbitWorkArea >>= 1;
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                    break;
                }
                case 6: {
                    context.lbitWorkArea >>= 6;
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                    break;
                }
                case 7: {
                    context.lbitWorkArea >>= 3;
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 24 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
        }
    }

    @Override
    void encode(byte[] byArray, int n, int n2, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n2 < 0) {
            context.eof = true;
            if (context.modulus == 0 && this.lineLength == 0) {
                return;
            }
            byte[] byArray2 = this.ensureBufferSize(this.encodeSize, context);
            int n3 = context.pos;
            switch (context.modulus) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 3) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea << 2) & 0x1F];
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                case 2: {
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 11) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 6) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 1) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea << 4) & 0x1F];
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                case 3: {
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 19) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 14) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 9) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 4) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea << 1) & 0x1F];
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                case 4: {
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 27) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 22) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 17) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 12) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 7) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 2) & 0x1F];
                    byArray2[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea << 3) & 0x1F];
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
            context.currentLinePos += context.pos - n3;
            if (this.lineLength > 0 && context.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, byArray2, context.pos, this.lineSeparator.length);
                context.pos += this.lineSeparator.length;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                int n5;
                byte[] byArray3 = this.ensureBufferSize(this.encodeSize, context);
                context.modulus = (context.modulus + 1) % 5;
                if ((n5 = byArray[n++]) < 0) {
                    n5 += 256;
                }
                context.lbitWorkArea = (context.lbitWorkArea << 8) + (long)n5;
                if (context.modulus == 0) {
                    byArray3[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 35) & 0x1F];
                    byArray3[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 30) & 0x1F];
                    byArray3[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 25) & 0x1F];
                    byArray3[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 20) & 0x1F];
                    byArray3[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 15) & 0x1F];
                    byArray3[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 10) & 0x1F];
                    byArray3[context.pos++] = this.encodeTable[(int)(context.lbitWorkArea >> 5) & 0x1F];
                    byArray3[context.pos++] = this.encodeTable[(int)context.lbitWorkArea & 0x1F];
                    context.currentLinePos += 8;
                    if (this.lineLength > 0 && this.lineLength <= context.currentLinePos) {
                        System.arraycopy(this.lineSeparator, 0, byArray3, context.pos, this.lineSeparator.length);
                        context.pos += this.lineSeparator.length;
                        context.currentLinePos = 0;
                    }
                }
                ++n4;
            }
        }
    }

    @Override
    public boolean isInAlphabet(byte by) {
        return by >= 0 && by < this.decodeTable.length && this.decodeTable[by] != -1;
    }
}

