/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.otp;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.otp.Base32;
import com.agfa.pacs.logging.ALogger;
import com.eatthepath.otp.TimeBasedOneTimePasswordGenerator;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class OneTimePassword {
    public static String generate(String string, Date date) throws NoSuchAlgorithmException, InvalidKeyException {
        return OneTimePasswordHelper.getInstance().generate(string, date);
    }

    public static String generate(String string) throws NoSuchAlgorithmException, InvalidKeyException {
        return OneTimePassword.generate(string, new Date());
    }

    public static boolean verify(String string, String string2) throws NoSuchAlgorithmException, InvalidKeyException {
        return OneTimePasswordHelper.getInstance().verify(string, string2);
    }

    public static String validateSharedPassword(String string) {
        Base32 base32 = new Base32();
        if (base32.isInAlphabet(string = string.toUpperCase(Locale.ENGLISH))) {
            return string;
        }
        ALogger.getLogger(OneTimePassword.class).error("Provided sharedPassword is not valid. Contains characters outside of A-Z0-7:" + string);
        return "";
    }

    public static String newKey() throws NoSuchAlgorithmException {
        return OneTimePasswordHelper.getInstance().newKey();
    }

    public static String removeInvalidCharacters(String string) {
        string = string.toUpperCase(Locale.ENGLISH);
        string = StringUtils.remove((String)string, (char)'_');
        string = StringUtils.remove((String)string, (char)'-');
        string = StringUtils.remove((String)string, (char)'8');
        if (!new Base32().isInAlphabet(string = StringUtils.remove((String)string, (char)'9'))) {
            ALogger.getLogger(OneTimePassword.class).error("Invalid characters in windows user:" + string);
            return "";
        }
        return string;
    }

    private static class OneTimePasswordConfig {
        private static final String BASE_PATH = "listtext.otp.";
        private static final String PASSWORD_LENGTH_PATH = "listtext.otp.passwordLength";
        private static final String PASSWORD_ALGORITHM_PATH = "listtext.otp.passwordAlgorithm";
        private static final String TIMESLOT_MILLIS_PATH = "listtext.otp.timeslotMillis";
        private static final String TIMESLOT_TOLERANCE_COUNTER_PATH = "listtext.otp.timeslotToleranceCounter";
        private static final IConfigurationProvider rootConfig = ConfigurationProviderFactory.getConfig();
        private static final int passwordLength = (int)rootConfig.getLong("listtext.otp.passwordLength");
        private static final String passwordAlgorithm = rootConfig.getString("listtext.otp.passwordAlgorithm");
        private static final long timeslotMillis = rootConfig.getLong("listtext.otp.timeslotMillis");
        private static final int timeslotToleranceCounter = (int)rootConfig.getLong("listtext.otp.timeslotToleranceCounter");

        private OneTimePasswordConfig() {
        }

        public static int getPasswordLength() {
            return passwordLength;
        }

        public static String getPasswordAlgorithm() {
            return passwordAlgorithm;
        }

        public static long getTimeslotMillis() {
            return timeslotMillis;
        }

        public static int getTimeslotToleranceCounter() {
            return timeslotToleranceCounter;
        }
    }

    private static class OneTimePasswordHelper {
        private static OneTimePasswordHelper instance;
        private TimeBasedOneTimePasswordGenerator generator = new TimeBasedOneTimePasswordGenerator(OneTimePasswordConfig.getTimeslotMillis(), TimeUnit.MILLISECONDS, OneTimePasswordConfig.getPasswordLength(), OneTimePasswordConfig.getPasswordAlgorithm());

        private OneTimePasswordHelper() throws NoSuchAlgorithmException {
        }

        public static synchronized OneTimePasswordHelper getInstance() throws NoSuchAlgorithmException {
            if (instance == null) {
                instance = new OneTimePasswordHelper();
            }
            return instance;
        }

        public String generate(String string, Date date) throws NoSuchAlgorithmException, InvalidKeyException {
            return this.formatPassword(this.generator.generateOneTimePassword((Key)this.toSecretKey(string), date));
        }

        public boolean verify(String string, String string2) throws NoSuchAlgorithmException, InvalidKeyException {
            long l = System.currentTimeMillis();
            long l2 = this.generator.getTimeStep(TimeUnit.MILLISECONDS);
            int n = OneTimePasswordConfig.getTimeslotToleranceCounter();
            int n2 = 0;
            while (n2 <= n) {
                String string3 = this.generate(string, new Date(l - (long)n2 * l2));
                if (Objects.equals(string2, string3)) {
                    return true;
                }
                string3 = this.generate(string, new Date(l + (long)n2 * l2));
                if (Objects.equals(string2, string3)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String newKey() throws NoSuchAlgorithmException {
            byte[] byArray = new byte[10];
            SecureRandom.getInstanceStrong().nextBytes(byArray);
            return StringUtils.remove((String)new Base32().encodeAsString(byArray), (String)"=");
        }

        private SecretKey toSecretKey(String string) throws NoSuchAlgorithmException {
            return new SecretKeySpec(new Base32().decode(string), this.generator.getAlgorithm());
        }

        private String formatPassword(int n) {
            String string = "%0" + this.generator.getPasswordLength() + 'd';
            return String.format(string, n);
        }
    }
}

