/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config;

import com.agfa.pacs.config.ConfigLevel;
import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.config.IConfigurationCache;
import com.agfa.pacs.config.ILookupSequenceProvider;
import com.agfa.pacs.config.provider.internal.StringSplit;
import com.agfa.pacs.logging.ALogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PacsConfigParser {
    private static final ALogger log = ALogger.getLogger(PacsConfigParser.class);
    private static SAXParserFactory sax = SAXParserFactory.newInstance();
    public static final String DEFAULT_ROLE_NAME = "Default";
    private static final String PACS_CONFIGURATION = "PacsConfiguration";
    private static final String LOOKUP_SEQUENCE = "LookupSequence";
    private static final String SEQUENCE = "Sequence";
    private static final String KEY_ATTRIB = "Key";
    private static final String VALUE_ATTRIB = "Value";
    private static final String CONFIG = "Config";
    private static final String CONFIGLIST = "ConfigList";
    private static final String TYPE = "Type";
    private static final String ORDER = "Order";

    static {
        try {
            sax.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            log.error("Could not enable security features");
        }
        try {
            sax.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            log.error("Could not set security", (Throwable)exception);
        }
    }

    public static ConfigLevel[] readModuleConfig(ILookupSequenceProvider iLookupSequenceProvider, InputStream inputStream, IConfigurationCache iConfigurationCache) throws ParserConfigurationException, SAXException, IOException {
        XMLHandler xMLHandler = new XMLHandler(iConfigurationCache, iLookupSequenceProvider);
        sax.newSAXParser().parse(inputStream, (DefaultHandler)xMLHandler);
        return xMLHandler.getAllLevels();
    }

    public static ConfigLevel[] readModuleConfig(ILookupSequenceProvider iLookupSequenceProvider, File file, IConfigurationCache iConfigurationCache) throws ParserConfigurationException, SAXException, IOException {
        XMLHandler xMLHandler = new XMLHandler(iConfigurationCache, iLookupSequenceProvider);
        sax.newSAXParser().parse(file, (DefaultHandler)xMLHandler);
        return xMLHandler.getAllLevels();
    }

    private static ConfigLevel[] getLevelsAsArray(String string) {
        String[] stringArray = StringSplit.split(string, '.');
        ConfigLevel[] configLevelArray = new ConfigLevel[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            configLevelArray[n] = ConfigLevel.valueOf(stringArray[n]);
            ++n;
        }
        return configLevelArray;
    }

    private static byte[] getLevelsAsByteArray(ConfigLevel[] configLevelArray) {
        byte[] byArray = new byte[configLevelArray.length];
        int n = 0;
        while (n < configLevelArray.length) {
            byArray[n] = (byte)configLevelArray[n].ordinal();
            ++n;
        }
        return byArray;
    }

    private static class XMLHandler
    extends DefaultHandler {
        private ILookupSequenceProvider provider;
        private IConfigurationCache cache;
        private Set<ConfigLevel> allLevels = new HashSet<ConfigLevel>();
        private Deque<String> pathElements = null;
        private Attributes attrib = null;
        private StringBuilder actualValue = null;
        private boolean parsingSequences;
        private boolean parsedSequences = false;
        private boolean parsingContent;
        private ConfigLevel actualLevel;
        private boolean parsingList = false;
        private boolean listContainsElement = false;

        public XMLHandler(IConfigurationCache iConfigurationCache, ILookupSequenceProvider iLookupSequenceProvider) {
            this.cache = iConfigurationCache;
            this.provider = iLookupSequenceProvider;
            this.pathElements = new ArrayDeque<String>(8);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.parsingSequences && string3.equalsIgnoreCase(PacsConfigParser.LOOKUP_SEQUENCE)) {
                this.parsingSequences = false;
                this.parsedSequences = true;
                return;
            }
            if (this.attrib == null && string3.equalsIgnoreCase(PacsConfigParser.CONFIG)) {
                this.pathElements.pollLast();
            } else if (this.attrib != null && string3.equalsIgnoreCase(PacsConfigParser.CONFIG)) {
                String string4 = this.attrib.getValue(PacsConfigParser.TYPE);
                ConfigType configType = null;
                try {
                    configType = ConfigType.valueOf(string4);
                }
                catch (Exception exception) {
                    log.error("No type specified for:" + XMLHandler.toFullPath(this.pathElements));
                    return;
                }
                String string5 = this.actualValue.toString();
                String string6 = XMLHandler.toFullPath(this.pathElements);
                String[] stringArray = StringSplit.split(string6, '.');
                this.cache.initValue(this.actualLevel, stringArray, configType, string5, PacsConfigParser.DEFAULT_ROLE_NAME);
                this.pathElements.pollLast();
                this.attrib = null;
                this.actualValue = null;
            } else if (string3.equalsIgnoreCase(PacsConfigParser.CONFIGLIST)) {
                if (this.parsingList && !this.listContainsElement) {
                    String string7 = this.pathElements.pollLast();
                    this.pathElements.addLast(String.valueOf(string7) + '#');
                    this.cache.initValue(this.actualLevel, this.pathElements.toArray(new String[this.pathElements.size()]), null, null, null);
                    this.parsingList = false;
                }
                this.pathElements.pollLast();
            } else {
                if (string3.equalsIgnoreCase(PacsConfigParser.SEQUENCE)) {
                    return;
                }
                if (string3.equalsIgnoreCase(PacsConfigParser.PACS_CONFIGURATION)) {
                    return;
                }
                try {
                    ConfigLevel configLevel = ConfigLevel.valueOf(string3);
                    if (this.parsingContent && configLevel != null) {
                        this.parsingContent = false;
                        return;
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        }

        private static String toFullPath(Deque<String> deque) {
            StringBuilder stringBuilder = new StringBuilder(128);
            for (String string : deque) {
                if (stringBuilder.length() > 0 && string.charAt(0) != '#') {
                    stringBuilder.append('.');
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.actualValue != null) {
                this.actualValue.append(cArray, n, n2);
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            log.error("SAX error", (Throwable)sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            log.error("SAX Fatal error", (Throwable)sAXParseException);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equalsIgnoreCase(PacsConfigParser.LOOKUP_SEQUENCE)) {
                this.parsingSequences = true;
                return;
            }
            if (this.parsingSequences && string3.equalsIgnoreCase(PacsConfigParser.SEQUENCE)) {
                ConfigLevel[] configLevelArray;
                String string4 = attributes.getValue(PacsConfigParser.KEY_ATTRIB);
                String string5 = attributes.getValue(PacsConfigParser.VALUE_ATTRIB);
                ConfigLevel[] configLevelArray2 = configLevelArray = PacsConfigParser.getLevelsAsArray(string5);
                int n = configLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ConfigLevel configLevel = configLevelArray2[n2];
                    this.allLevels.add(configLevel);
                    ++n2;
                }
                this.cache.putLookupSequence(PacsConfigParser.getLevelsAsByteArray(configLevelArray), string4);
                if (this.provider == null) return;
                this.provider.putLookupSequence(string4, configLevelArray);
                return;
            }
            if (this.parsingContent && (string3.equalsIgnoreCase(PacsConfigParser.CONFIG) || string3.equalsIgnoreCase(PacsConfigParser.CONFIGLIST))) {
                if (this.parsingList) {
                    this.listContainsElement = true;
                }
                if (string3.equalsIgnoreCase(PacsConfigParser.CONFIGLIST)) {
                    this.parsingList = true;
                    this.listContainsElement = false;
                }
                this.attrib = null;
                this.actualValue = null;
                if (attributes.getValue(PacsConfigParser.TYPE) == null && attributes.getValue(PacsConfigParser.KEY_ATTRIB) != null) {
                    this.pathElements.add(attributes.getValue(PacsConfigParser.KEY_ATTRIB));
                    return;
                } else if (attributes.getValue(PacsConfigParser.ORDER) != null) {
                    this.pathElements.add(String.valueOf('#') + attributes.getValue(PacsConfigParser.ORDER));
                    return;
                } else {
                    if (attributes.getValue(PacsConfigParser.TYPE) == null) throw new IllegalArgumentException("Illegal node");
                    this.pathElements.add(attributes.getValue(PacsConfigParser.KEY_ATTRIB));
                    this.attrib = attributes;
                    this.actualValue = new StringBuilder(128);
                }
                return;
            }
            if (string3.equalsIgnoreCase(PacsConfigParser.PACS_CONFIGURATION)) {
                return;
            }
            try {
                ConfigLevel configLevel = ConfigLevel.valueOf(string3);
                if (configLevel == null) return;
                if (!this.parsedSequences && configLevel == ConfigLevel.Manufacturer) {
                    throw new UnsupportedOperationException("Pacsconfig with no looukup sequences at start");
                }
                this.parsingContent = true;
                this.actualLevel = configLevel;
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw unsupportedOperationException;
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Unknow node:" + string3);
            }
        }

        public ConfigLevel[] getAllLevels() {
            return this.allLevels.toArray(new ConfigLevel[this.allLevels.size()]);
        }
    }
}

