/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config.provider.internal;

import com.agfa.pacs.config.ConfigLevel;
import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.config.IConfigurationCacheVisitor;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.provider.internal.ConfigNode;
import com.agfa.pacs.config.provider.internal.ConfigTree;
import com.agfa.pacs.config.provider.internal.StringSplit;
import com.agfa.pacs.config.provider.internal.ValueModificationReturn;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.BundleContext;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigLeafNode
extends ConfigNode {
    private static final ALogger log = ALogger.getLogger(ConfigLeafNode.class);
    private static final String GET_STRING_METHOD_NAME = "getString";
    private ConfigType type;
    private byte[] lookupSequence;
    private Object defaultValue;
    private Object value;
    private String role = null;

    ConfigLeafNode(ConfigType configType) {
        this.type = configType;
    }

    private String pathToString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            stringBuilder.append(string).append('.');
            ++n2;
        }
        return stringBuilder.toString();
    }

    @Override
    public void initValue(ConfigLevel configLevel, String[] stringArray, int n, ConfigType configType, String string, String string2) {
        block21: {
            if (stringArray.length != n + 1) {
                throw new IllegalArgumentException("config path too long");
            }
            if (configType != null && this.type == null) {
                this.type = configType;
            }
            if (this.lookupSequence == null) {
                this.lookupSequence = ConfigLeafNode.getLookupSequence(stringArray);
                if (this.lookupSequence == null) {
                    log.info("No lookup value for:" + this.pathToString(stringArray));
                    throw new IllegalArgumentException();
                }
            }
            int n2 = configLevel.ordinal();
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.lookupSequence.length) {
                if (n2 == this.lookupSequence[n4]) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            if (n3 == -1) {
                throw new IllegalArgumentException("Not allowed configlevel in key:" + this.pathToString(stringArray));
            }
            if (this.role == null || string2 != null && !string2.equals("Default")) {
                this.role = string2;
            }
            if (configType != null && string != null) {
                try {
                    if (ConfigType.Boolean == configType) {
                        string = string.trim();
                        this.setValueInternal(configLevel, "true".equalsIgnoreCase(string));
                    } else if (ConfigType.Double == configType) {
                        string = string.trim();
                        this.setValueInternal(configLevel, Double.parseDouble(string));
                    } else if (ConfigType.Long == configType) {
                        string = string.trim();
                        this.setValueInternal(configLevel, Long.parseLong(string));
                    } else {
                        this.setValueInternal(configLevel, string);
                    }
                }
                catch (Exception exception) {
                    n4 = 0;
                    if (configType == ConfigType.Long && string.contains("x")) {
                        try {
                            this.setValueInternal(configLevel, Long.parseLong(string.substring(2), 16));
                        }
                        catch (NumberFormatException numberFormatException) {
                            n4 = 1;
                        }
                    } else {
                        n4 = 1;
                    }
                    if (n4 == 0) break block21;
                    log.warn("Untype configuration key not possible:" + this.pathToString(stringArray));
                    this.setValueInternal(configLevel, string);
                }
            }
        }
    }

    @Override
    protected Object getValue(Iterator<String> iterator) {
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("config path too long");
        }
        return this.value != null ? this.value : this.defaultValue;
    }

    @Override
    protected String getRole(Iterator<String> iterator) {
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("config path too long");
        }
        return this.role;
    }

    @Override
    public Map<String, String> getLocalizedValues(Iterator<String> iterator) {
        LinkedHashMap<String, String> linkedHashMap = null;
        try {
            Class clazz = BundleContext.getBundleContext().loadClassFromBundle(0L, "Messages");
            Method method = clazz.getMethod(GET_STRING_METHOD_NAME, String.class);
            Object object = this.getValue(iterator);
            String string = null;
            if (!(object instanceof String)) {
                throw new IllegalStateException("LeafNode value is not of type string");
            }
            string = (String)object;
            String[] stringArray = StringSplit.split(string, ';');
            linkedHashMap = new LinkedHashMap<String, String>();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                String string3 = (String)method.invoke(null, stringArray[n]);
                linkedHashMap.put(string2, string3);
                ++n;
            }
        }
        catch (Exception exception) {
            log.error("Error in localization", (Throwable)exception);
            linkedHashMap = null;
        }
        return linkedHashMap;
    }

    @Override
    public ConfigTree getNode(ConfigTree configTree, String string, Iterator<String> iterator) {
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("config path too long");
        }
        throw new IllegalArgumentException("value not node");
    }

    @Override
    public IConfigurationList getList(ConfigTree configTree, String string, Iterator<String> iterator) {
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("config path too long");
        }
        throw new IllegalArgumentException("value not node");
    }

    @Override
    public ValueModificationReturn setValue(String[] stringArray, int n, String string, ConfigType configType, Object object, String string2) {
        if (stringArray.length > n) {
            throw new IllegalArgumentException("config path too long");
        }
        ValueModificationReturn valueModificationReturn = null;
        if (object != null && !object.equals(this.getValueInternal()) || this.role != null && !this.role.equals(string2)) {
            this.value = object;
            this.role = string2;
            this.dirty = true;
            valueModificationReturn = new ValueModificationReturn(ConfigLevel.values()[this.lookupSequence[0]], this.type);
        }
        return valueModificationReturn;
    }

    @Override
    public ValueModificationReturn removeValue(Iterator<String> iterator) {
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("config path too long");
        }
        ValueModificationReturn valueModificationReturn = null;
        if (this.value != null) {
            this.value = null;
            this.dirty = true;
            valueModificationReturn = new ValueModificationReturn(ConfigLevel.values()[this.lookupSequence[0]], this.type);
            this.role = this.defaultValue != null ? "Default" : null;
        }
        return valueModificationReturn;
    }

    @Override
    protected void internalScanCache(String string, IConfigurationCacheVisitor iConfigurationCacheVisitor, boolean bl, boolean bl2) {
        if (bl && !this.dirty) {
            return;
        }
        if (this.lookupSequence == null) {
            return;
        }
        if (this.value != null) {
            iConfigurationCacheVisitor.visitEntry(ConfigLevel.values()[this.lookupSequence[0]], 0L, string, this.type, this.value);
        } else if (this.defaultValue != null) {
            iConfigurationCacheVisitor.visitEntry(ConfigLevel.Manufacturer, 0L, string, this.type, this.defaultValue);
        }
        if (bl2) {
            this.dirty = false;
        }
    }

    @Override
    public IConfigurationList createList(ConfigTree configTree, String string, Iterator<String> iterator, String string2) {
        throw new IllegalArgumentException("Cannot create list in a leaf node");
    }

    @Override
    public void removeNode(Iterator<String> iterator) {
        throw new IllegalArgumentException("config path too long");
    }

    @Override
    public ConfigNode getNode(Iterator<String> iterator) {
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("config path too long");
        }
        throw new IllegalArgumentException("value not node");
    }

    @Override
    protected Map<ConfigLevel, Object> getMap(Iterator<String> iterator) {
        throw new UnsupportedOperationException();
    }

    private Object getValueInternal() {
        return this.value != null ? this.value : this.defaultValue;
    }

    private void setValueInternal(ConfigLevel configLevel, Object object) {
        if (configLevel != ConfigLevel.Manufacturer) {
            this.value = object;
        } else {
            this.defaultValue = object;
        }
    }
}

