/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config.provider.internal;

import com.agfa.pacs.config.ConfigLevel;
import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.config.ConfigurationSourceFactory;
import com.agfa.pacs.config.IConfigurationCache;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.config.IConfigurationSource;
import com.agfa.pacs.config.provider.internal.ConfigIntermediateNode;
import com.agfa.pacs.config.provider.internal.ConfigNode;
import com.agfa.pacs.config.provider.internal.ListDirectAccessException;
import com.agfa.pacs.config.provider.internal.MissingLookupSequence;
import com.agfa.pacs.config.provider.internal.StringSplit;
import com.agfa.pacs.config.provider.internal.ValueModificationReturn;
import com.agfa.pacs.logging.ALogger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConfigTree
implements IConfigurationProvider {
    private static final String DUMMY_PLUGIN = "";
    private static final ALogger log = ALogger.getLogger(ConfigTree.class);
    private ConfigNode rootNode;
    private GetProcessor processor = new GetProcessor();
    protected String prefix = "";
    protected ConfigTree master;
    private ReadWriteLock configListenerLock;
    private Map<String, Object> configurationListeners;
    private String role = null;

    public ConfigTree() {
        this.configurationListeners = new Hashtable<String, Object>();
        this.configListenerLock = new ReentrantReadWriteLock();
        this.rootNode = new ConfigIntermediateNode();
    }

    protected ConfigTree(ConfigTree configTree, ConfigNode configNode, String string) {
        if (configTree != null && configTree.master != null) {
            configTree = configTree.master;
        }
        this.prefix = string;
        this.master = configTree;
        if (configTree != null) {
            this.configurationListeners = configTree.configurationListeners;
            this.configListenerLock = configTree.configListenerLock;
            this.role = configTree.role;
        }
        this.rootNode = configNode;
    }

    public ConfigTree clone(ConfigNode configNode, String string) {
        return new ConfigTree(this, configNode, string);
    }

    private boolean requestKey(String string) {
        boolean bl = false;
        IConfigurationSource[] iConfigurationSourceArray = ConfigurationSourceFactory.getConfig();
        int n = iConfigurationSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationSource iConfigurationSource = iConfigurationSourceArray[n2];
            bl = this.master != null ? iConfigurationSource.requestKey(this.master.rootNode, String.valueOf(this.prefix) + '.' + string, DUMMY_PLUGIN, this.role) || bl : iConfigurationSource.requestKey(this.rootNode, string, DUMMY_PLUGIN, this.role) || bl;
            ++n2;
        }
        return bl;
    }

    private boolean notifyListener(IConfigurationChangeListener iConfigurationChangeListener, String string) {
        if (iConfigurationChangeListener != null) {
            try {
                iConfigurationChangeListener.configurationChanged(string);
            }
            catch (Exception exception) {
                log.error("Error in Configuration notification:", (Throwable)exception);
            }
            return true;
        }
        return false;
    }

    protected void valueModified(String string, ConfigLevel configLevel, Object object, ConfigType configType) {
        Object object2;
        IConfigurationSource[] iConfigurationSourceArray = ConfigurationSourceFactory.getConfig();
        int n = iConfigurationSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = iConfigurationSourceArray[n2];
            object2.valueModified(string, configLevel, this.role, object, configType);
            ++n2;
        }
        object2 = string;
        do {
            if (this.configurationListeners == null) {
                return;
            }
            this.configListenerLock.readLock().lock();
            Object object3 = this.configurationListeners.get(object2);
            this.configListenerLock.readLock().unlock();
            if (object3 instanceof WeakReference) {
                IConfigurationChangeListener iConfigurationChangeListener = (IConfigurationChangeListener)((WeakReference)object3).get();
                if (!this.notifyListener(iConfigurationChangeListener, string)) {
                    this.configListenerLock.writeLock().lock();
                    this.configurationListeners.remove(object2);
                    this.configListenerLock.writeLock().unlock();
                    ALogger.getLogger(ConfigTree.class).info("Not valid configuration listener");
                }
            } else if (object3 instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object3;
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    IConfigurationChangeListener iConfigurationChangeListener = (IConfigurationChangeListener)((WeakReference)arrayList.get(n3)).get();
                    if (!this.notifyListener(iConfigurationChangeListener, string)) {
                        ALogger.getLogger(ConfigTree.class).info("Not valid configuration listener");
                        if (n3 < arrayList.size() - 1) {
                            arrayList.set(n3, (WeakReference)arrayList.get(arrayList.size() - 1));
                        }
                        arrayList.remove(arrayList.size() - 1);
                        --n3;
                    }
                    ++n3;
                }
                if (arrayList.isEmpty()) {
                    this.configListenerLock.writeLock().lock();
                    this.configurationListeners.remove(object2);
                    this.configListenerLock.writeLock().unlock();
                }
            }
            n = ((String)object2).lastIndexOf(46);
            int n4 = ((String)object2).lastIndexOf(35);
            if (n4 <= n) continue;
            n = n4;
        } while ((object2 = n < 0 ? null : ((String)object2).substring(0, n)) != null);
    }

    public boolean exists(String string) {
        try {
            Object object = this.processor.getValue(string);
            return object != null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return true;
        }
        catch (ListDirectAccessException listDirectAccessException) {
            return listDirectAccessException.pathEnded;
        }
        catch (Exception exception) {
            log.error("exception while accessing config key " + string, (Throwable)exception);
            return false;
        }
    }

    public String getString(String string) throws IllegalArgumentException {
        Object object = this.processor.getValue(string);
        if (object == null) {
            throw new IllegalArgumentException("Path for value of type String not found: " + this.prefix + '.' + string + ", role is " + this.role);
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("Type not compatible");
    }

    public String getText(String string) throws IllegalArgumentException {
        Object object = this.processor.getValue(string);
        if (object == null) {
            throw new IllegalArgumentException("Path for value of type Text not found: " + this.prefix + '.' + string + ", role is " + this.role);
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("Type not compatible");
    }

    public IConfigurationProvider getNode(String string) {
        this.requestKey(String.valueOf(this.prefix) + '.' + string);
        IConfigurationProvider iConfigurationProvider = this.getNodeInternal(string);
        if (iConfigurationProvider == null) {
            throw new IllegalArgumentException("Path for Node not found: " + this.prefix + '.' + string + ", role is " + this.role);
        }
        return iConfigurationProvider;
    }

    public IConfigurationList createList(String string) {
        return this.getList(string);
    }

    private IConfigurationList createListInternal(String string) {
        String[] stringArray = StringSplit.split(string, '.');
        String[] stringArray2 = new String[stringArray.length - 1];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        return this.rootNode.createList(this, string, Arrays.asList(stringArray2).iterator(), stringArray[stringArray.length - 1]);
    }

    public IConfigurationList getList(String string) {
        IConfigurationList iConfigurationList = this.getListInternal(string);
        if (iConfigurationList == null) {
            boolean bl = this.requestKey(string);
            if (bl) {
                iConfigurationList = this.getListInternal(string);
            }
            if (iConfigurationList == null) {
                return this.createListInternal(string);
            }
        }
        return iConfigurationList;
    }

    private IConfigurationList getListInternal(String string) throws IllegalArgumentException {
        String[] stringArray = StringSplit.split(string, '.');
        return this.rootNode.getList(this, string, Arrays.asList(stringArray).iterator());
    }

    private IConfigurationProvider getNodeInternal(String string) throws IllegalArgumentException {
        String[] stringArray = StringSplit.split(string, '.');
        return this.rootNode.getNode(this, string, Arrays.asList(stringArray).iterator());
    }

    private ConfigNode getNodeDirectly(String string) throws IllegalArgumentException {
        String[] stringArray = StringSplit.split(string, '.');
        return this.rootNode.getNode(Arrays.asList(stringArray).iterator());
    }

    public void setString(String string, String string2) throws IllegalArgumentException {
        this.setValue(string, ConfigType.String, string2);
    }

    public void setText(String string, String string2) throws IllegalArgumentException {
        this.setValue(string, ConfigType.Text, string2);
    }

    private void setValue(String string, ConfigType configType, Object object) {
        String[] stringArray = StringSplit.split(string, '.');
        String string2 = string;
        if (this.master != null) {
            string2 = String.valueOf(this.prefix) + '.' + string2;
        }
        ValueModificationReturn valueModificationReturn = null;
        try {
            valueModificationReturn = this.rootNode.setValue(stringArray, 0, string2, configType, object, this.role == null ? DUMMY_PLUGIN : this.role);
        }
        catch (MissingLookupSequence missingLookupSequence) {
            throw new IllegalArgumentException("No lookup sequence specified for key:" + string);
        }
        if (valueModificationReturn != null && this.master != null) {
            this.valueModified(string.length() > 0 ? String.valueOf(this.prefix) + '.' + string : this.prefix, valueModificationReturn.level, object, valueModificationReturn.type);
        } else if (valueModificationReturn != null) {
            this.valueModified(string, valueModificationReturn.level, object, valueModificationReturn.type);
        }
    }

    public void removeValue(String string) throws IllegalArgumentException {
        try {
            this.getString(string);
        }
        catch (Exception exception) {}
        String[] stringArray = StringSplit.split(string, '.');
        ValueModificationReturn valueModificationReturn = this.rootNode.removeValue(Arrays.asList(stringArray).iterator());
        if (valueModificationReturn != null) {
            if (this.master != null) {
                this.valueModified(string.length() > 0 ? String.valueOf(this.prefix) + '.' + string : this.prefix, valueModificationReturn.level, null, null);
            } else {
                this.valueModified(string, valueModificationReturn.level, null, null);
            }
        }
    }

    public ConfigNode getRootNode() {
        return this.rootNode;
    }

    public double getDouble(String string) throws IllegalArgumentException {
        Object object = this.processor.getValue(string);
        if (object == null) {
            throw new IllegalArgumentException("Path not found " + string);
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        throw new IllegalArgumentException("Type mismatch " + string);
    }

    public long getLong(String string) throws IllegalArgumentException {
        Object object = this.processor.getValue(string);
        if (object == null) {
            throw new IllegalArgumentException("Path not found " + string);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new IllegalArgumentException("Type mismatch " + string);
    }

    public boolean getBoolean(String string) throws IllegalArgumentException {
        Object object = this.processor.getValue(string);
        if (object == null) {
            throw new IllegalArgumentException("Path not found: " + string);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new IllegalArgumentException("Type mismatch " + string);
    }

    public String getType(String string) throws IllegalArgumentException {
        Object object = this.processor.getValue(string);
        if (object == null) {
            throw new IllegalArgumentException("Path not found: " + string);
        }
        if (object instanceof String) {
            return "String";
        }
        if (object instanceof Boolean) {
            return "Boolean";
        }
        if (object instanceof Long) {
            return "Long";
        }
        if (object instanceof Double) {
            return "Double";
        }
        throw new IllegalArgumentException("Unknown type");
    }

    public void setDouble(String string, double d) throws IllegalArgumentException {
        this.setValue(string, ConfigType.Double, d);
    }

    public void setLong(String string, long l) throws IllegalArgumentException {
        this.setValue(string, ConfigType.Long, l);
    }

    public void setBoolean(String string, boolean bl) throws IllegalArgumentException {
        this.setValue(string, ConfigType.Boolean, bl);
    }

    public synchronized void registerConfigurationChangeListener(String string, IConfigurationChangeListener iConfigurationChangeListener) {
        if (this.master != null) {
            this.master.registerConfigurationChangeListener(String.valueOf(this.prefix) + '.' + string, iConfigurationChangeListener);
            return;
        }
        this.configListenerLock.writeLock().lock();
        try {
            ArrayList arrayList = this.configurationListeners.get(string);
            if (arrayList == null) {
                this.configurationListeners.put(string, new WeakReference<IConfigurationChangeListener>(iConfigurationChangeListener));
                return;
            }
            if (arrayList instanceof WeakReference) {
                ArrayList arrayList2 = new ArrayList();
                arrayList2.add(arrayList);
                this.configurationListeners.put(string, arrayList2);
                arrayList = arrayList2;
            }
            ((List)arrayList).add(new WeakReference<IConfigurationChangeListener>(iConfigurationChangeListener));
        }
        finally {
            this.configListenerLock.writeLock().unlock();
        }
    }

    public void deregisterConfigurationChangeListener(String string, IConfigurationChangeListener iConfigurationChangeListener) {
        block9: {
            if (this.master != null) {
                this.master.deregisterConfigurationChangeListener(String.valueOf(this.prefix) + '.' + string, iConfigurationChangeListener);
                return;
            }
            this.configListenerLock.writeLock().lock();
            try {
                Object object = this.configurationListeners.get(string);
                if (object == null) {
                    return;
                }
                if (object instanceof WeakReference) {
                    IConfigurationChangeListener iConfigurationChangeListener2 = (IConfigurationChangeListener)((WeakReference)object).get();
                    if (iConfigurationChangeListener2 != null && iConfigurationChangeListener == iConfigurationChangeListener2) {
                        this.configurationListeners.remove(string);
                    }
                    break block9;
                }
                if (!(object instanceof List)) break block9;
                List list = (List)object;
                for (WeakReference weakReference : list) {
                    IConfigurationChangeListener iConfigurationChangeListener3 = (IConfigurationChangeListener)weakReference.get();
                    if (iConfigurationChangeListener3 == null || iConfigurationChangeListener3 != iConfigurationChangeListener) continue;
                    list.remove(weakReference);
                    break;
                }
            }
            finally {
                this.configListenerLock.writeLock().unlock();
            }
        }
    }

    public void setRole(String string) {
        if (string != null && !this.isSupportingRoles()) {
            throw new IllegalArgumentException("Not supporting roles");
        }
        this.role = string;
    }

    public String toString() {
        return "Node:" + this.prefix;
    }

    public boolean isSupportingRoles() {
        return ConfigurationSourceFactory.isSupportingRoles();
    }

    public String getRole() {
        return this.role;
    }

    public IConfigurationProvider clone(String string) {
        ConfigTree configTree = new ConfigTree(this, this.rootNode, DUMMY_PLUGIN);
        configTree.setRole(string);
        configTree.master = null;
        return configTree;
    }

    public void storeAllConfiguration() {
        IConfigurationSource[] iConfigurationSourceArray = ConfigurationSourceFactory.getConfig();
        int n = iConfigurationSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationSource iConfigurationSource = iConfigurationSourceArray[n2];
            iConfigurationSource.storeConfig();
            ++n2;
        }
    }

    public void storeConfigurationForRole(String string) {
        IConfigurationSource[] iConfigurationSourceArray = ConfigurationSourceFactory.getConfig();
        int n = iConfigurationSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationSource iConfigurationSource = iConfigurationSourceArray[n2];
            iConfigurationSource.storeForRole(string);
            ++n2;
        }
    }

    public void updateCache(String string) {
        ConfigNode configNode = null;
        String string2 = string;
        do {
            try {
                configNode = this.getNodeDirectly(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (configNode != null) continue;
            int n = string.lastIndexOf(46);
            string = n != -1 ? string.substring(0, n) : DUMMY_PLUGIN;
        } while (configNode == null && string.length() > 0);
        if (configNode == null) {
            log.warn("Unable to update cache. Key not found '" + string2 + "'");
            return;
        }
        ConfigNode configNode2 = this.rootNode;
        if (this.master != null) {
            configNode2 = this.master.rootNode;
        }
        IConfigurationSource[] iConfigurationSourceArray = ConfigurationSourceFactory.getConfig();
        int n = iConfigurationSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationSource iConfigurationSource = iConfigurationSourceArray[n2];
            iConfigurationSource.requestKeyUpdate((IConfigurationCache)configNode2, string, new ArrayList<String>(), this.role);
            ++n2;
        }
    }

    public Map<String, String> getValuesWithLocalizedStrings(String string) throws IllegalArgumentException {
        Map map = this.processor.getLocalizedValues(string);
        if (map == null) {
            throw new IllegalArgumentException("Path for value of type String not found: " + this.prefix + '.' + string + ", role is " + this.role);
        }
        return map;
    }

    public String getRole(String string) {
        return this.processor.getRole(string);
    }

    private class GetProcessor {
        private GetProcessor() {
        }

        private Object getValue(String string) throws IllegalArgumentException {
            boolean bl;
            Object object = this.getValueInternal(string);
            if (object == null && (bl = this.findValue(string))) {
                object = this.getValueInternal(string);
            }
            return object;
        }

        public String getRole(String string) throws IllegalArgumentException {
            boolean bl;
            String string2 = this.getRoleInternal(string);
            if (string2 == null && (bl = this.findValue(string))) {
                string2 = this.getRoleInternal(string);
            }
            return string2;
        }

        private Map<String, String> getLocalizedValues(String string) throws IllegalArgumentException {
            boolean bl;
            Map<String, String> map = this.getLocalizedValuesInternal(string);
            if (map == null && (bl = this.findValue(string))) {
                map = this.getLocalizedValuesInternal(string);
            }
            return map;
        }

        private boolean findValue(String string) {
            return ConfigTree.this.requestKey(String.valueOf(ConfigTree.this.prefix) + '.' + string);
        }

        private Map<ConfigLevel, Object> getMap(String string) {
            String[] stringArray = StringSplit.split(string, '.');
            return ConfigTree.this.rootNode.getMap(Arrays.asList(stringArray).iterator());
        }

        private Object getValueInternal(String string) throws IllegalArgumentException {
            String[] stringArray = StringSplit.split(string, '.');
            return ConfigTree.this.rootNode.getValue(Arrays.asList(stringArray).iterator());
        }

        private String getRoleInternal(String string) throws IllegalArgumentException {
            String[] stringArray = StringSplit.split(string, '.');
            return ConfigTree.this.rootNode.getRole(Arrays.asList(stringArray).iterator());
        }

        private Map<String, String> getLocalizedValuesInternal(String string) {
            String[] stringArray = StringSplit.split(string, '.');
            return ConfigTree.this.rootNode.getLocalizedValues(Arrays.asList(stringArray).iterator());
        }
    }
}

