/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config.provider.internal;

import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.config.provider.internal.ConfigListNode;
import com.agfa.pacs.config.provider.internal.ConfigNode;
import com.agfa.pacs.config.provider.internal.ConfigTree;
import com.agfa.pacs.config.provider.internal.DeleteScanVisitor;
import com.agfa.pacs.config.provider.internal.DeletedItem;
import com.agfa.pacs.config.provider.internal.VirtualConfigTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConfigTreeList
extends ConfigTree
implements IConfigurationList {
    private ConfigListNode listNode;
    private String lastAddedId = null;

    protected ConfigTreeList(ConfigTree configTree, ConfigListNode configListNode, String string) {
        super(configTree, configListNode, string);
        this.listNode = configListNode;
    }

    public int size() {
        return this.listNode.getSize();
    }

    public boolean isEmpty() {
        return this.listNode.getSize() == 0;
    }

    public Iterator<IConfigurationProvider> iterator() {
        return new NodeIterator(this.listNode.getChildren().iterator(), this.listNode.getId2NodeMap());
    }

    public Map<String, IConfigurationProvider> getChildrenItems() {
        HashMap<String, IConfigurationProvider> hashMap = new HashMap<String, IConfigurationProvider>();
        Map<String, ConfigNode> map = this.listNode.getId2NodeMap();
        for (Map.Entry<String, ConfigNode> entry : map.entrySet()) {
            if (entry.getValue() instanceof ConfigListNode) {
                hashMap.put(entry.getKey(), new ConfigTreeList(this.master, (ConfigListNode)entry.getValue(), String.valueOf(this.prefix) + '#' + entry.getKey()));
                continue;
            }
            hashMap.put(entry.getKey(), new ConfigTree(this.master, entry.getValue(), String.valueOf(this.prefix) + '#' + entry.getKey()));
        }
        return hashMap;
    }

    public IConfigurationProvider appendItem() {
        VirtualConfigTree virtualConfigTree = new VirtualConfigTree(this, this.master, this.prefix);
        this.lastAddedId = virtualConfigTree.getId();
        return virtualConfigTree;
    }

    public IConfigurationProvider appendItem(String string) {
        VirtualConfigTree virtualConfigTree = new VirtualConfigTree(this, this.master, this.prefix, string);
        this.lastAddedId = string;
        return virtualConfigTree;
    }

    protected void appendDevirtualizedNode(ConfigNode configNode, String string, int n) {
        this.listNode.addChild(string, configNode, n);
    }

    public void clear() {
        Map<String, ConfigNode> map = this.listNode.getId2NodeMap();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        for (String string : arrayList) {
            this.remove(string);
        }
    }

    public void remove(int n) {
        String string = this.listNode.getIdFromIndex(n);
        this.remove(string);
    }

    public synchronized void remove(String string) {
        if (this.listNode.getNodeById(string) == null) {
            return;
        }
        DeleteScanVisitor deleteScanVisitor = new DeleteScanVisitor(String.valueOf(this.prefix) + '#' + string);
        this.listNode.getNodeById(string).scanCache(deleteScanVisitor, false, false);
        this.listNode.remove(string, this.prefix);
        for (DeletedItem deletedItem : deleteScanVisitor.getItemsToDelete()) {
            this.valueModified(deletedItem.path, deletedItem.level, null, null);
        }
    }

    public String getIdOfLastNewElement() {
        return this.lastAddedId;
    }

    private class NodeIterator
    implements Iterator<IConfigurationProvider> {
        private Iterator<? extends ConfigNode> nodeIterator;
        Map<ConfigNode, String> vtk;

        public NodeIterator(Iterator<? extends ConfigNode> iterator, Map<String, ConfigNode> map) {
            this.nodeIterator = iterator;
            this.vtk = new HashMap<ConfigNode, String>();
            for (Map.Entry<String, ConfigNode> entry : map.entrySet()) {
                this.vtk.put(entry.getValue(), entry.getKey());
            }
        }

        @Override
        public boolean hasNext() {
            return this.nodeIterator.hasNext();
        }

        @Override
        public IConfigurationProvider next() {
            ConfigNode configNode = this.nodeIterator.next();
            if (configNode instanceof ConfigListNode) {
                return new ConfigTreeList(ConfigTreeList.this.master, (ConfigListNode)configNode, String.valueOf(ConfigTreeList.this.prefix) + "#" + this.vtk.get(configNode));
            }
            return new ConfigTree(ConfigTreeList.this.master, configNode, String.valueOf(ConfigTreeList.this.prefix) + "#" + this.vtk.get(configNode));
        }

        @Override
        public void remove() {
            throw new RuntimeException("item remove not possible");
        }
    }
}

