/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.dicompm.dicom;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.print.PrinterConfigurationItem;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUTShape;
import com.agfa.pacs.listtext.dicomobject.print.BasicAnnotationBox;
import com.agfa.pacs.listtext.dicomobject.print.BasicFilmBox;
import com.agfa.pacs.listtext.dicomobject.print.BasicFilmSession;
import com.agfa.pacs.listtext.dicomobject.print.BasicImageBox;
import com.agfa.pacs.listtext.dicomobject.print.PresentationLookupTable;
import com.agfa.pacs.listtext.dicomobject.print.PrintJob;
import com.agfa.pacs.listtext.dicomobject.print.Printer;
import com.agfa.pacs.listtext.dicomobject.print.PrinterConfiguration;
import com.agfa.pacs.listtext.print.PrintColor;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmSessionConfiguration;
import com.agfa.pacs.listtext.print.dicompm.dicom.DicomPrintClient;
import com.agfa.pacs.listtext.print.dicompm.dicom.DicomPrinterListener;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.AbstractDicomService;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;

public class DicomPrinter {
    private static ALogger log = ALogger.getLogger(DicomPrinter.class);
    private DicomPrintClient printClient;
    private Printer printer;
    private BasicFilmSession filmSession;
    private BasicFilmBox filmBox;
    private int collation;
    private ReferencedSOP refPrintJob;
    private PrinterConfigurationItem printerConfigurationItem;
    private DicomFilmSessionConfiguration sessionConfiguration;
    private PrintJob printJob;
    private List<DicomPrinterListener> listener = new Vector<DicomPrinterListener>();
    private PresentationLookupTable presentationLookupTable;

    public DicomPrinter(IDicomNode iDicomNode) throws DicomException {
        this.printClient = new DicomPrintClient(iDicomNode, (DicomService)new EventReportService());
    }

    public PrinterConfiguration getPrinterConfiguration() {
        try {
            this.printClient.connect();
            PrinterConfiguration printerConfiguration = this.printClient.getPrinterConfiguration();
            this.printClient.disconnect();
            return printerConfiguration;
        }
        catch (Exception exception) {
            log.error("Printer configuration retrieval error", (Throwable)exception);
            return null;
        }
    }

    public void setPrintColor(PrintColor printColor) {
        this.printClient.setPrintColor(printColor);
    }

    public void initPrinting(PrinterConfigurationItem printerConfigurationItem) {
        this.printerConfigurationItem = printerConfigurationItem;
        this.printClient.setSetCharacterSet(printerConfigurationItem.isSetCharacterSet());
        this.collation = this.printerConfigurationItem.getMaximumCollatedFilms() != null ? this.printerConfigurationItem.getMaximumCollatedFilms() : 0;
    }

    public void beginPrinting() {
        try {
            this.printClient.connect();
            this.printer = this.printClient.getPrinter();
            this.notifyPrinterChanged(this.printer);
        }
        catch (Exception exception) {
            log.error("Printing start error", (Throwable)exception);
        }
    }

    public void endPrinting() {
        try {
            this.printClient.disconnect();
            this.printer = null;
            this.refPrintJob = null;
            this.printJob = null;
        }
        catch (Exception exception) {
            log.error("Printing end error", (Throwable)exception);
        }
    }

    public void beginFilmSession(BasicFilmSession basicFilmSession) {
        this.printClient.createBasicFilmSession(basicFilmSession);
        this.filmSession = basicFilmSession;
        if (this.sessionConfiguration.isCreatePresentationLUT()) {
            this.presentationLookupTable = this.createDefaultPresentationLookupTable();
            this.printClient.createPresentationLUT(this.presentationLookupTable);
        }
    }

    public void endFilmSession() {
        if (this.collation > 0) {
            this.refPrintJob = this.printClient.printBasicFilmSession(this.filmSession);
        }
        if (this.presentationLookupTable != null) {
            this.printClient.deletePresentationLUT(this.presentationLookupTable);
            this.printClient.deleteBasicFilmSession(this.filmSession);
        }
    }

    public void beginFilmBox(BasicFilmBox basicFilmBox) {
        basicFilmBox.setFilmSession(this.filmSession.getSOPCommon().createReferencedSOP());
        if (this.presentationLookupTable != null) {
            basicFilmBox.setPresentationLUT(this.presentationLookupTable.getSOPCommon().createReferencedSOP());
        }
        this.printClient.createBasicFilmBox(basicFilmBox);
        this.filmSession.filmBoxes().add(basicFilmBox.getSOPCommon().createReferencedSOP());
        this.filmBox = basicFilmBox;
    }

    public void endFilmBox() {
        if (this.collation == 0) {
            this.refPrintJob = this.printClient.printBasicFilmBox(this.filmBox);
            this.printClient.deleteBasicFilmBox(this.filmBox);
        }
    }

    public void setImageBox(BasicImageBox basicImageBox) {
        this.printClient.setBasicImageBox(basicImageBox);
    }

    public void setAnnotationBox(BasicAnnotationBox basicAnnotationBox) {
        this.printClient.setBasicAnnotationBox(basicAnnotationBox);
    }

    public BasicFilmBox createBasicFilmBox(BasicFilmSession basicFilmSession) {
        BasicFilmBox basicFilmBox = new BasicFilmBox();
        ReferencedSOP referencedSOP = new ReferencedSOP(basicFilmSession.getSOPClassUID(), basicFilmSession.getSOPInstanceUID());
        basicFilmBox.setFilmSession(referencedSOP);
        return basicFilmBox;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public PrinterConfigurationItem getPrinterConfigurationItem() {
        return this.printerConfigurationItem;
    }

    public PrintJob getPrintJob() {
        if (this.printJob == null && this.refPrintJob != null) {
            this.printJob = this.printClient.getPrintJob(this.refPrintJob);
            this.notifyPrintJobChanged(this.printJob);
        }
        return this.printJob;
    }

    private PresentationLookupTable createDefaultPresentationLookupTable() {
        PresentationLUT presentationLUT = new PresentationLUT();
        presentationLUT.setPresentationLUTShape(PresentationLUTShape.Identity);
        PresentationLookupTable presentationLookupTable = new PresentationLookupTable(null);
        presentationLookupTable.setPresentationLUT(presentationLUT);
        return presentationLookupTable;
    }

    public PrintColor[] getSupportedColors() {
        return this.printClient.getSupportedColors();
    }

    public void addListener(DicomPrinterListener dicomPrinterListener) {
        this.listener.add(dicomPrinterListener);
    }

    public void removeListener(DicomPrinterListener dicomPrinterListener) {
        this.listener.remove(dicomPrinterListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPrinterChanged(Printer printer) {
        List<DicomPrinterListener> list = this.listener;
        synchronized (list) {
            for (DicomPrinterListener dicomPrinterListener : this.listener) {
                dicomPrinterListener.printerUpdated(printer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPrintJobChanged(PrintJob printJob) {
        List<DicomPrinterListener> list = this.listener;
        synchronized (list) {
            for (DicomPrinterListener dicomPrinterListener : this.listener) {
                dicomPrinterListener.printJobUpdated(printJob);
            }
        }
    }

    public void setSessionConfiguration(DicomFilmSessionConfiguration dicomFilmSessionConfiguration) {
        this.sessionConfiguration = dicomFilmSessionConfiguration;
    }

    private class EventReportService
    extends AbstractDicomService {
        protected EventReportService() {
            super(new String[]{"1.2.840.10008.5.1.1.16", "1.2.840.10008.5.1.1.14"});
        }

        public void onDimseRQ(Association association, PresentationContext presentationContext, Dimse dimse, Attributes attributes, Attributes attributes2) throws IOException {
            if (dimse != Dimse.N_EVENT_REPORT_RQ) {
                Attributes attributes3 = Commands.mkNEventReportRSP((Attributes)attributes, (int)0);
                association.writeDimseRSP(presentationContext, attributes3);
                String string = attributes.getString(4096);
                String string2 = attributes.getString(2);
                if ("1.2.840.10008.5.1.1.16".equals(string2) && DicomPrinter.this.printer != null && string.equals(DicomPrinter.this.printer.getSOPInstanceUID())) {
                    DicomPrinter.this.printer.fromDataset(attributes2);
                    DicomPrinter.this.notifyPrinterChanged(DicomPrinter.this.printer);
                }
                if ("1.2.840.10008.5.1.1.14".equals(string2) && DicomPrinter.this.printJob != null && string.equals(DicomPrinter.this.printJob.getSOPInstanceUID())) {
                    DicomPrinter.this.printJob.fromDataset(attributes2);
                    DicomPrinter.this.notifyPrintJobChanged(DicomPrinter.this.printJob);
                }
            } else {
                throw new DicomServiceException(529);
            }
        }
    }
}

