/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomworklists.mwl;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.comm.DicomCFindSCU;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.listtext.dicomworklists.util.TagsMWL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;

public class DicomMWLCFindSCU
extends DicomCFindSCU {
    private static UIDMap initUIDMap() {
        UIDMap uIDMap = new UIDMap();
        Set set = UIDUtilities.getDefaultTransferSyntaxUIDs();
        uIDMap.addTransferSyntaxUIDs("1.2.840.10008.5.1.4.31", (Collection)set);
        return uIDMap;
    }

    public DicomMWLCFindSCU(IDicomNode iDicomNode) {
        super(iDicomNode, DicomMWLCFindSCU.initUIDMap(), false);
    }

    public synchronized void connect() throws DicomException {
        super.connect();
        this.qrTSUID = this.association.getTransferSyntaxesFor("1.2.840.10008.5.1.4.31");
        if (this.qrTSUID != null && !this.qrTSUID.isEmpty()) {
            this.qrSOPClass = "1.2.840.10008.5.1.4.31";
        }
    }

    private static Attributes getNestedDataset(int[] nArray, Attributes attributes, boolean bl) {
        int n = 0;
        while (n != nArray.length - 1) {
            Sequence sequence;
            if (attributes.contains(nArray[n])) {
                sequence = attributes.getSequence(nArray[n]);
            } else if (bl) {
                sequence = attributes.newSequence(nArray[n], 1);
            } else {
                return null;
            }
            if (sequence.size() > nArray[n + 1]) {
                attributes = (Attributes)sequence.get(nArray[n + 1]);
            } else if (bl) {
                attributes = new Attributes();
                sequence.add(attributes);
            } else {
                return null;
            }
            n += 2;
        }
        return attributes;
    }

    public synchronized List<Attributes> cFind(Attributes attributes) throws DicomException {
        try {
            if (!this.hasModalityWorklist()) {
                throw new Exception("Modality Work List not supported");
            }
            Attributes attributes2 = new Attributes(attributes);
            int[][] nArray = TagsMWL.Return;
            int n = TagsMWL.Return.length;
            int n2 = 0;
            while (n2 < n) {
                int[] nArray2 = nArray[n2];
                Attributes attributes3 = DicomMWLCFindSCU.getNestedDataset(nArray2, attributes2, true);
                if (!attributes3.contains(nArray2[nArray2.length - 1])) {
                    attributes3.setNull(nArray2[nArray2.length - 1], ElementDictionary.vrOf((int)nArray2[nArray2.length - 1], null));
                }
                ++n2;
            }
            return super.cFind(attributes2);
        }
        catch (Exception exception) {
            throw new DicomException((Throwable)exception);
        }
    }

    public synchronized boolean hasModalityWorklist() {
        if (this.association == null) {
            return false;
        }
        Set set = this.association.getTransferSyntaxesFor("1.2.840.10008.5.1.4.31");
        return set != null && !set.isEmpty();
    }

    public static class MWLTransferCapabilityProvider
    implements ITransferCapabilityProvider {
        public List<TransferCapability> getTransferCapabilities() {
            return DicomMWLCFindSCU.initUIDMap().getTransferCapabilitiesSCU();
        }

        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return Collections.emptyList();
        }
    }
}

