/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomworklists.mwl;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.device.config.DicomDeviceConfigurationFactory;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.SimpleDicomNode;
import com.agfa.pacs.listtext.dicomobject.mwl.MPPS;
import com.agfa.pacs.listtext.dicomobject.type.ProcedureStepStatus;
import com.agfa.pacs.listtext.dicomworklists.mwl.ModalityWorkItem;
import com.agfa.pacs.listtext.dicomworklists.mwl.ModalityWorkListException;
import com.agfa.pacs.listtext.dicomworklists.mwl.ModalityWorkListNServiceSCU;
import com.agfa.pacs.listtext.dicomworklists.mwl.ModalityWorkListNodeException;
import java.util.HashMap;
import java.util.Map;

public class ModalityWorkItemManager {
    private Map<SimpleDicomNode, ModalityWorkListNServiceSCU> nServiceSCUs = new HashMap<SimpleDicomNode, ModalityWorkListNServiceSCU>();

    private ModalityWorkListNServiceSCU getNServiceSCU(IDicomNode iDicomNode) throws DicomException {
        SimpleDicomNode simpleDicomNode = new SimpleDicomNode(iDicomNode);
        if (!this.nServiceSCUs.containsKey(simpleDicomNode)) {
            ModalityWorkListNServiceSCU modalityWorkListNServiceSCU = new ModalityWorkListNServiceSCU((IDicomNode)simpleDicomNode);
            modalityWorkListNServiceSCU.connect();
            this.nServiceSCUs.put(simpleDicomNode, modalityWorkListNServiceSCU);
        }
        return this.nServiceSCUs.get(simpleDicomNode);
    }

    public void createPerformedProcedureStep(ModalityWorkItem modalityWorkItem, boolean bl) throws ModalityWorkListException {
        ModalityWorkListNServiceSCU modalityWorkListNServiceSCU = null;
        try {
            try {
                modalityWorkListNServiceSCU = this.getNServiceSCU(modalityWorkItem.getDicomNode());
                MPPS mPPS = modalityWorkItem.getPerformedProcedureStep();
                mPPS.getInformation().setStationAETitle(DicomDeviceConfigurationFactory.getConfiguration().getDefaultAET());
                mPPS.getInformation().setStatus(ProcedureStepStatus.InProgress);
                modalityWorkListNServiceSCU.createPPS(mPPS);
                int n = modalityWorkListNServiceSCU.getLastStatus();
                if (n != 0) {
                    throw new ModalityWorkListNodeException(n);
                }
            }
            catch (Exception exception) {
                throw new ModalityWorkListException(exception);
            }
        }
        finally {
            this.releaseService(modalityWorkListNServiceSCU, modalityWorkItem.getDicomNode(), bl);
        }
    }

    private void releaseService(ModalityWorkListNServiceSCU modalityWorkListNServiceSCU, IDicomNode iDicomNode, boolean bl) throws ModalityWorkListException {
        if (modalityWorkListNServiceSCU != null) {
            try {
                SimpleDicomNode simpleDicomNode = new SimpleDicomNode(iDicomNode);
                this.nServiceSCUs.remove(simpleDicomNode);
                modalityWorkListNServiceSCU.close();
            }
            catch (Exception exception) {
                throw new ModalityWorkListException(exception);
            }
        }
    }

    public void setPerformedProcedureStep(ModalityWorkItem modalityWorkItem, ProcedureStepStatus procedureStepStatus, boolean bl) throws ModalityWorkListException {
        ModalityWorkListNServiceSCU modalityWorkListNServiceSCU = null;
        try {
            try {
                modalityWorkListNServiceSCU = this.getNServiceSCU(modalityWorkItem.getDicomNode());
                MPPS mPPS = modalityWorkItem.getPerformedProcedureStep();
                mPPS.getInformation().setStatus(procedureStepStatus);
                modalityWorkListNServiceSCU.setPPS(mPPS);
            }
            catch (Exception exception) {
                throw new ModalityWorkListException(exception);
            }
        }
        finally {
            this.releaseService(modalityWorkListNServiceSCU, modalityWorkItem.getDicomNode(), bl);
        }
    }

    public MPPS getPerformedProcedureStep(IDicomNode iDicomNode, String string, MPPS mPPS, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ModalityWorkListException {
        ModalityWorkListNServiceSCU modalityWorkListNServiceSCU = null;
        try {
            modalityWorkListNServiceSCU = this.getNServiceSCU(iDicomNode);
            MPPS mPPS2 = modalityWorkListNServiceSCU.getPPS(string);
            return mPPS2;
        }
        catch (Exception exception) {
            throw new ModalityWorkListException(exception);
        }
        finally {
            this.releaseService(modalityWorkListNServiceSCU, iDicomNode, bl4);
        }
    }
}

