/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomworklists.mwl;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.comm.DicomNServiceSCU;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.listtext.dicomobject.mwl.MPPS;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;

public class ModalityWorkListNServiceSCU
extends DicomNServiceSCU {
    private static UIDMap initUIDMap() {
        UIDMap uIDMap = new UIDMap();
        Set set = UIDUtilities.getDefaultTransferSyntaxUIDs();
        uIDMap.addTransferSyntaxUIDs("1.2.840.10008.3.1.2.3.3", (Collection)set);
        uIDMap.addTransferSyntaxUIDs("1.2.840.10008.3.1.2.3.4", (Collection)set);
        return uIDMap;
    }

    public ModalityWorkListNServiceSCU(IDicomNode iDicomNode) throws DicomException {
        super(iDicomNode);
        this.addTransferCapabilities(ModalityWorkListNServiceSCU.initUIDMap());
    }

    public void setPPS(MPPS mPPS) throws DicomException {
        this.nSet(null, mPPS.getSOPClassUID(), mPPS.getSOPInstanceUID(), mPPS.getNSetDicomObject());
    }

    public MPPS getPPS(String string) throws DicomException {
        Attributes attributes = this.nGet(null, "1.2.840.10008.3.1.2.3.4", string);
        if (attributes != null) {
            return new MPPS(attributes);
        }
        return null;
    }

    public MPPS createPPS(MPPS mPPS) throws DicomException {
        Attributes attributes = this.nCreate(null, mPPS.getSOPClassUID(), mPPS.getSOPInstanceUID(), mPPS.getNCreateDicomObject());
        if (attributes != null) {
            return new MPPS(attributes);
        }
        return null;
    }

    public static class MWLSetTransferCapabilityProvider
    implements ITransferCapabilityProvider {
        public List<TransferCapability> getTransferCapabilities() {
            return ModalityWorkListNServiceSCU.initUIDMap().getTransferCapabilitiesSCU();
        }

        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return Collections.emptyList();
        }
    }
}

