/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.hw.manager;

import com.agfa.pacs.data.hw.manager.IQueueEntry;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.WaitDicomDataListenerAdapter;
import com.agfa.pacs.data.shared.dicom.UIDConfiguration;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomRetriever;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class DicomDataRequest
extends WaitDicomDataListenerAdapter
implements IQueueEntry,
IDicomDataRequest {
    private static final ALogger log = ALogger.getLogger(DicomDataRequest.class);
    private final ILoadableInfo toLoad;
    private IObjectInfo object;
    private boolean fromCache;
    private IDicomDataListener listener;
    private List<IDicomDataListener> additionalListeners;
    private byte priority;
    private int passedFrames = 0;
    private Integer framesToPass;
    private boolean isMPEG2;
    private int numberOfInstances = 1;
    private State state = State.Initialized;
    private IDicomRetriever retriever;

    public DicomDataRequest(ILoadableInfo iLoadableInfo, byte by, List<IDicomDataListener> list) {
        this.toLoad = iLoadableInfo;
        this.priority = by;
        this.fromCache = iLoadableInfo.canBeCached();
        if (iLoadableInfo.getType() == ILoadableInfo.LoadableType.Object && iLoadableInfo instanceof IObjectInfo) {
            this.object = (IObjectInfo)iLoadableInfo;
        } else if (iLoadableInfo.getType() == ILoadableInfo.LoadableType.Serie) {
            List list2 = iLoadableInfo.getAllInstances();
            this.numberOfInstances = list2.size();
        }
        if (list != null) {
            this.additionalListeners = new ArrayList<IDicomDataListener>(list);
        }
    }

    public synchronized void setRetriever(IDicomRetriever iDicomRetriever) {
        this.retriever = iDicomRetriever;
    }

    public IInstanceInfo getInstanceInfo() {
        return this.toLoad.getInstanceInfo();
    }

    public IDataProviderIdentifier getDataProviderIdentifier() {
        return this.toLoad.getSource().getIdentifier();
    }

    public synchronized IDicomRetriever getDicomRetriever() {
        if (this.state == State.Canceled) {
            return null;
        }
        this.state = State.InProgress;
        return this.retriever;
    }

    public State getState() {
        return this.state;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(byte by) {
        this.priority = by;
    }

    public synchronized boolean setListener(IDicomDataListener iDicomDataListener) {
        if (this.passedFrames > 0) {
            return false;
        }
        this.listener = iDicomDataListener;
        return true;
    }

    public synchronized boolean addListener(IDicomDataListener iDicomDataListener) {
        if (this.state == State.Initialized) {
            if (this.additionalListeners == null) {
                this.additionalListeners = new LinkedList<IDicomDataListener>();
            }
            this.additionalListeners.add(iDicomDataListener);
            return true;
        }
        return false;
    }

    public boolean isStarted() {
        return this.state != State.Initialized;
    }

    public ILoadableInfo getLoadableInfo() {
        return this.toLoad;
    }

    public IObjectInfo getObjectInfo() {
        return this.object;
    }

    int getRequiredFrames() {
        if (this.object == null) {
            throw new IllegalStateException();
        }
        Attributes attributes = this.object.getAttributes();
        if (attributes.containsValue(0x280008)) {
            return attributes.getInt(0x280008, 0);
        }
        if (UIDConfiguration.getInstance().getBaseType(this.object.getSOPClassUID()) == UIDType.Image) {
            return 1;
        }
        return 0;
    }

    public boolean isFromCache() {
        return this.fromCache;
    }

    public void setFromCache(boolean bl) {
        this.fromCache = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.toLoad.getUID());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Object getKey() {
        return this.toLoad;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DicomDataRequest)) {
            return false;
        }
        DicomDataRequest dicomDataRequest = (DicomDataRequest)object;
        return this.toLoad.getUID().equals(dicomDataRequest.toLoad.getUID());
    }

    public int hashCode() {
        return this.toLoad.getUID().hashCode();
    }

    public synchronized void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        if (this.framesToPass == null) {
            this.framesToPass = attributes.getInt(0x280008, 0);
        }
        if (this.framesToPass == 0 && bl) {
            this.framesToPass = 1;
        }
        if (!bl) {
            this.framesToPass = 0;
        }
        if (this.listener != null) {
            boolean bl2 = false;
            if (attributes.contains(3276810) && "ANONYMIZING".equals(attributes.getString(3276810))) {
                bl2 = true;
                attributes.remove(3276810);
            }
            if (!bl2) {
                IPatientInfo iPatientInfo = this.toLoad.getPatient();
                if (this.toLoad.hasInstance(string)) {
                    attributes.addSelected(iPatientInfo.getAttributes(), null, 0x100010);
                    try {
                        attributes.addSelected(iPatientInfo.getAttributes(), null, 0x100030);
                        attributes.addSelected(iPatientInfo.getAttributes(), null, 1048626);
                    }
                    catch (Exception exception) {
                        log.warn("Could not copy patient birthdate from c-find");
                        attributes.setNull(0x100030, VR.DA);
                        attributes.setNull(1048626, VR.TM);
                    }
                    attributes.addSelected(iPatientInfo.getAttributes(), null, 0x100040);
                }
            }
            this.listener.dicomDataAvailable(string, attributes, bl);
            if (this.additionalListeners != null) {
                for (IDicomDataListener iDicomDataListener : this.additionalListeners) {
                    iDicomDataListener.dicomDataAvailable(string, attributes, bl);
                }
            }
        }
    }

    public synchronized void dicomDataError(String string, String string2, Throwable throwable) {
        if (string != null) {
            if (this.listener != null) {
                this.listener.dicomDataError(string, string2, throwable);
            }
            if (this.additionalListeners != null) {
                for (IDicomDataListener iDicomDataListener : this.additionalListeners) {
                    iDicomDataListener.dicomDataError(string, string2, throwable);
                }
            }
            super.dicomDataError(string, string2, throwable);
            log.error("Error on dicom retrieve:" + string, throwable);
        } else {
            for (IObjectInfo iObjectInfo : this.toLoad.getAllInstances()) {
                this.dicomDataError(iObjectInfo.getSOPInstanceUID(), string2, throwable);
            }
        }
    }

    public synchronized void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
        if (this.listener != null) {
            if (this.framesToPass != null && this.passedFrames < this.framesToPass && !this.isMPEG2 && !this.toLoad.isFrameSelection()) {
                Exception exception = new Exception("not enough pixel data events");
                this.listener.dicomDataError(string, "not enough pixel data events", (Throwable)exception);
                if (this.additionalListeners != null) {
                    for (IDicomDataListener iDicomDataListener : this.additionalListeners) {
                        iDicomDataListener.dicomDataError(string, "not enough pixel data events", (Throwable)exception);
                    }
                }
            } else {
                this.listener.dicomDataFinished(string, status, attributes);
                if (this.additionalListeners != null) {
                    for (IDicomDataListener iDicomDataListener : this.additionalListeners) {
                        iDicomDataListener.dicomDataFinished(string, status, attributes);
                    }
                }
            }
        } else {
            log.warn("Listener null in Dicom data finished");
        }
        --this.numberOfInstances;
        if (this.numberOfInstances <= 0) {
            super.dicomDataFinished(string, status, attributes);
            this.state = State.Finished;
            this.listener = null;
            if (this.additionalListeners != null) {
                this.additionalListeners.clear();
            }
        }
    }

    public synchronized void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
        if (this.listener != null) {
            this.listener.pixelDataAvailable(string, iPixelDataInfo, n);
        }
        if (this.additionalListeners != null) {
            for (Object object : this.additionalListeners) {
                object.pixelDataAvailable(string, iPixelDataInfo, n);
            }
        }
        ++this.passedFrames;
        if (this.passedFrames == 1) {
            Object object;
            object = iPixelDataInfo.getTransferSyntaxUID();
            this.isMPEG2 = UIDUtilities.isTransferSyntaxType((String)object, (UIDType)UIDType.Video);
        }
    }

    public synchronized boolean waitUntilFinished(int n) {
        if (!this.isFinished()) {
            try {
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {
                log.error("WaitUntil Data Listener", (Throwable)interruptedException);
            }
        }
        return this.isFinished();
    }

    static enum State {
        Initialized,
        InProgress,
        Finished,
        Canceled;

    }
}

