/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.thumbnail;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.shared.icon.IIconInfo;
import com.agfa.pacs.data.shared.icon.IIconProvider;
import com.agfa.pacs.data.shared.icon.IconException;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailFrame;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailLoaderDispatcher;
import com.agfa.pacs.logging.ALogger;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class ThumbnailLoader
extends Thread {
    private static final ALogger log = ALogger.getLogger(ThumbnailLoader.class);
    private static final double THUMBNAIL_SCALING_FACTOR = ConfigurationProviderFactory.getConfig().getDouble("listtext.thumbnailScalingFactor");
    public static final int MAX_ICON_WIDTH = (int)Math.round(64.0 * THUMBNAIL_SCALING_FACTOR);
    public static final int MAX_ICON_HEIGHT = (int)Math.round(64.0 * THUMBNAIL_SCALING_FACTOR);
    private static final boolean IS_SCALING_UP = THUMBNAIL_SCALING_FACTOR > 1.0;
    private ThumbnailLoaderDispatcher dispatcher;
    private BlockingQueue<ThumbnailFrame> queue = new LinkedBlockingQueue<ThumbnailFrame>();
    private ThumbnailFrame loadingObject = null;
    private boolean running;
    private boolean canceled;

    public ThumbnailLoader(ThumbnailLoaderDispatcher thumbnailLoaderDispatcher) {
        super("Thumbnail Loader");
        this.dispatcher = thumbnailLoaderDispatcher;
        this.running = false;
        this.canceled = false;
    }

    @Override
    public void run() {
        this.running = true;
        while (!this.canceled) {
            try {
                this.loadingObject = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                if (this.loadingObject == null) continue;
                BufferedImage bufferedImage = ThumbnailLoader.loadIcon(this.loadingObject);
                if (bufferedImage != null) {
                    Icon icon = ThumbnailLoader.createIcon(bufferedImage);
                    this.fireThumbnailLoaded(this.loadingObject, icon);
                }
                this.loadingObject = null;
            }
            catch (InterruptedException interruptedException) {
                log.warn("Loading thumbnail failed!", (Throwable)interruptedException);
            }
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
    }

    public void clearLoadingQueue() {
        if (log.isDebugEnabled()) {
            log.debug("Thumbnail loading queue cleared");
        }
        this.queue.clear();
    }

    public int getNumberOfQueuedRequests() {
        return this.queue.size();
    }

    public synchronized void removeFromLoadingQueue(Collection<ThumbnailFrame> collection) {
        for (ThumbnailFrame thumbnailFrame : collection) {
            this.removeFromLoadingQueue(thumbnailFrame);
        }
    }

    public synchronized void addToLoadingQueue(Collection<ThumbnailFrame> collection) {
        for (ThumbnailFrame thumbnailFrame : collection) {
            this.addToLoadingQueue(thumbnailFrame);
        }
    }

    public synchronized boolean addToLoadingQueue(ThumbnailFrame thumbnailFrame) {
        try {
            if (thumbnailFrame != null && !this.isQueuedOrLoading(thumbnailFrame)) {
                this.queue.put(thumbnailFrame);
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            log.warn("Adding object into thumbnail loading queue failed!", (Throwable)interruptedException);
        }
        return false;
    }

    public synchronized boolean removeFromLoadingQueue(ThumbnailFrame thumbnailFrame) {
        if (this.queue.contains(thumbnailFrame)) {
            return this.queue.remove(thumbnailFrame);
        }
        return false;
    }

    public boolean isQueuedOrLoading(ThumbnailFrame thumbnailFrame) {
        return this.queue.contains(thumbnailFrame) || thumbnailFrame.equals(this.loadingObject);
    }

    public static Icon getDefaultThumbnail(IObjectInfo iObjectInfo) {
        IIconProvider iIconProvider;
        if (iObjectInfo != null && (iIconProvider = iObjectInfo.getSource().getIconProvider()) != null) {
            try {
                IIconInfo iIconInfo = iIconProvider.getDefaultIcon(iObjectInfo);
                if (iIconInfo != null) {
                    return ThumbnailLoader.createIcon(iIconInfo.getImage());
                }
                log.warn("No default thumbnail icon for SOP class '" + iObjectInfo.getSOPClassUID() + "'");
            }
            catch (Exception exception) {
                log.error("Getting default thumbnail icon failed!", (Throwable)exception);
            }
        }
        return null;
    }

    private static BufferedImage loadIcon(ThumbnailFrame thumbnailFrame) {
        Object object;
        if (thumbnailFrame == null) {
            return null;
        }
        IObjectInfo iObjectInfo = thumbnailFrame.getObject();
        if (iObjectInfo instanceof IIconInfo) {
            try {
                object = ((IIconInfo)iObjectInfo).getImage();
                if (object != null) {
                    return object;
                }
            }
            catch (IconException iconException) {}
        }
        object = thumbnailFrame.getFrameNumber();
        IIconProvider iIconProvider = iObjectInfo.getSource().getIconProvider();
        if (iIconProvider == null) {
            return null;
        }
        IIconInfo iIconInfo = iIconProvider.getIcon(iObjectInfo, object != null ? (Integer)object : 0);
        if (iIconInfo == null) {
            iIconInfo = iIconProvider.getDefaultIcon(iObjectInfo);
        }
        try {
            return iIconInfo.getImage();
        }
        catch (IconException iconException) {
            return null;
        }
    }

    private static Icon createIcon(BufferedImage bufferedImage) {
        try {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            if (IS_SCALING_UP && (n == MAX_ICON_WIDTH || n2 == MAX_ICON_HEIGHT) || !IS_SCALING_UP && n <= MAX_ICON_WIDTH && n2 <= MAX_ICON_HEIGHT) {
                return new ImageIcon(bufferedImage);
            }
            int n3 = MAX_ICON_WIDTH;
            int n4 = MAX_ICON_HEIGHT;
            if (n > MAX_ICON_WIDTH && n2 > MAX_ICON_HEIGHT || n < MAX_ICON_WIDTH && n2 < MAX_ICON_HEIGHT) {
                float f = (float)(n - MAX_ICON_WIDTH) / (float)(n2 - MAX_ICON_HEIGHT);
                if (f >= 1.0f) {
                    n4 = (int)((float)n2 * ((float)MAX_ICON_WIDTH / (float)n));
                } else {
                    n3 = (int)((float)n * ((float)MAX_ICON_HEIGHT / (float)n2));
                }
            } else if (n > MAX_ICON_WIDTH) {
                n4 = (int)((float)n2 * (float)MAX_ICON_WIDTH / (float)n);
            } else {
                n3 = (int)((float)n * (float)MAX_ICON_HEIGHT / (float)n2);
            }
            return new ImageIcon(bufferedImage.getScaledInstance(n3, n4, 2));
        }
        catch (Exception exception) {
            return UIManager.getIcon("dicom.image");
        }
    }

    private void fireThumbnailLoaded(ThumbnailFrame thumbnailFrame, Icon icon) {
        this.dispatcher.fireThumbnailLoaded(thumbnailFrame, icon);
    }
}

