/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.thumbnail.plaf;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.lta.thumbnail.IThumbnailLoadingSelector;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailCache;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailFrame;
import com.agfa.pacs.listtext.lta.thumbnail.plaf.ThumbnailListCellRenderer;
import com.agfa.pacs.listtext.lta.thumbnail.plaf.ThumbnailListModel;
import com.agfa.pacs.listtext.lta.thumbnail.plaf.ThumbnailTransferHandler;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class ThumbnailList
extends JList<Icon> {
    private final IThumbnailLoadingSelector selector;
    private List<ThumbnailFrame> lastVisibleFrames = new ArrayList<ThumbnailFrame>(0);
    private ThumbnailCache cache = ThumbnailCache.getInstance();

    public ThumbnailList(ThumbnailListModel thumbnailListModel, IThumbnailLoadingSelector iThumbnailLoadingSelector, ThumbnailTransferHandler thumbnailTransferHandler) {
        super(thumbnailListModel);
        this.selector = iThumbnailLoadingSelector;
        this.setCellRenderer(new ThumbnailListCellRenderer());
        this.setSelectionMode(2);
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(0);
        this.setSelectionBackground(ColorUtils.getSelection1());
        if (thumbnailTransferHandler != null) {
            this.setDragEnabled(true);
            this.setTransferHandler((TransferHandler)((Object)thumbnailTransferHandler));
        }
    }

    public void dispose() {
        ((ThumbnailListModel)this.getModel()).dispose();
    }

    @Override
    public void paint(Graphics graphics) {
        this.updateThumbnailModel();
        super.paint(graphics);
    }

    public List<IObjectInfo> getSelectedObjects() {
        return ReferencedObjectUtilities.extractReferencedObjects(this.getSelectedThumbnailFrames());
    }

    List<ThumbnailFrame> getSelectedThumbnailFrames() {
        ArrayList<ThumbnailFrame> arrayList = new ArrayList<ThumbnailFrame>();
        int[] nArray = super.getSelectedIndices();
        if (nArray != null) {
            ThumbnailListModel thumbnailListModel = (ThumbnailListModel)this.getModel();
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray2[n2];
                ThumbnailFrame thumbnailFrame = thumbnailListModel.getThumbnailFrameAt(n3);
                if (thumbnailFrame != null && !arrayList.contains(thumbnailFrame)) {
                    arrayList.add(thumbnailFrame);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    private void updateThumbnailModel() {
        ThumbnailListModel thumbnailListModel = (ThumbnailListModel)this.getModel();
        int n = this.getFirstVisibleIndex();
        int n2 = this.getLastVisibleIndex();
        ArrayList<ThumbnailFrame> arrayList = new ArrayList<ThumbnailFrame>();
        int n3 = n;
        while (n3 <= n2) {
            ThumbnailFrame thumbnailFrame = thumbnailListModel.getThumbnailFrameAt(n3);
            if (thumbnailFrame != null && this.selector.isThumbnailLoadingEnabled(thumbnailFrame)) {
                arrayList.add(thumbnailFrame);
            }
            ++n3;
        }
        ArrayList<ThumbnailFrame> arrayList2 = new ArrayList<ThumbnailFrame>(this.lastVisibleFrames);
        arrayList2.removeAll(arrayList);
        this.lastVisibleFrames = arrayList;
        if (!arrayList2.isEmpty()) {
            this.cache.cancelThumbnailLoading(arrayList2);
        }
        if (!arrayList.isEmpty()) {
            this.cache.requestThumbnailLoading(arrayList);
        }
    }
}

