/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.thumbnail.plaf;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.listtext.lta.thumbnail.IThumbnailLoadingListener;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailCache;
import com.agfa.pacs.listtext.lta.thumbnail.ThumbnailFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ThumbnailListModel
extends AbstractListModel<Icon> {
    private ISeriesInfo series;
    private List<ThumbnailFrame> frames;
    private IThumbnailLoadingListener cacheListener;
    private ThumbnailCache cache;

    public ThumbnailListModel(ISeriesInfo iSeriesInfo, Collection<ThumbnailFrame> collection) {
        this.series = iSeriesInfo;
        this.cache = ThumbnailCache.getInstance();
        this.cacheListener = new ThumbnailLoadingListener();
        this.cache.addLoadingListener(this.cacheListener);
        this.frames = new ArrayList<ThumbnailFrame>();
        if (collection != null) {
            this.frames.addAll(collection);
        }
    }

    public ISeriesInfo getSeries() {
        return this.series;
    }

    public IObjectInfo getObjectAt(int n) {
        ThumbnailFrame thumbnailFrame = this.getThumbnailFrameAt(n);
        return thumbnailFrame != null ? thumbnailFrame.getObject() : null;
    }

    public ThumbnailFrame getThumbnailFrameAt(int n) {
        if (n >= 0 && n < this.frames.size()) {
            return this.frames.get(n);
        }
        return null;
    }

    public void dispose() {
        this.cache.removeLoadingListener(this.cacheListener);
        this.cache = null;
        this.cacheListener = null;
        this.frames.clear();
    }

    @Override
    public Icon getElementAt(int n) {
        return this.cache.getThumbnail(this.getThumbnailFrameAt(n));
    }

    @Override
    public int getSize() {
        return this.frames.size();
    }

    private class ThumbnailLoadingListener
    implements IThumbnailLoadingListener {
        private ThumbnailLoadingListener() {
        }

        @Override
        public void thumbnailLoaded(final ThumbnailFrame thumbnailFrame, Icon icon) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n;
                    if (thumbnailFrame != null && (n = ThumbnailListModel.this.frames.indexOf(thumbnailFrame)) >= 0 && n < ThumbnailListModel.this.frames.size()) {
                        ThumbnailListModel.this.fireContentsChanged(this, n, n);
                    }
                }
            });
        }
    }
}

