/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.FileUtil;
import com.sun.jna.platform.win32.Kernel32;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.filechooser.FileSystemView;

public class RemovableDriveUtil {
    private static FileSystemView fsv = FileSystemView.getFileSystemView();
    private static Set<String> drives2ignore = new HashSet<String>();
    private static final int REMOVABLE = 2;
    private static final int CDROM = 5;

    public static boolean removableDrivesInstalled() {
        File[] fileArray;
        File[] fileArray2 = fileArray = File.listRoots();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (RemovableDriveUtil.isRemovableDrive(file, true)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isRemovableDrive(File file) {
        return RemovableDriveUtil.isRemovableDrive(file, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRemovableDrive(File file, boolean bl) {
        try {
            if (drives2ignore.contains(file.getAbsolutePath())) {
                return false;
            }
            if (fsv.isFloppyDrive(file)) {
                drives2ignore.add(file.getAbsolutePath());
                return false;
            }
            try {
                int n = Kernel32.INSTANCE.GetDriveType(file.getAbsolutePath());
                if (n != 5 && n != 2) {
                    drives2ignore.add(file.getAbsolutePath());
                    return false;
                }
            }
            catch (Error error) {
                ALogger.getLogger(RemovableDriveUtil.class).error("Could not detect drive type", (Throwable)error);
            }
            if (bl) {
                return true;
            }
            if (!file.exists()) {
                return false;
            }
            String string = fsv.getSystemDisplayName(file);
            return string.length() > 0;
        }
        catch (Exception exception) {
            ALogger.getLogger(FileUtil.class).warn("Could not check Drive", (Throwable)exception);
            return true;
        }
    }
}

