/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.busylabel;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class GraphicsUtilities {
    private GraphicsUtilities() {
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static BufferedImage createColorModelCompatibleImage(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage) {
        return GraphicsUtilities.createCompatibleImage(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage, int n, int n2) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(n, n2, bufferedImage.getType()) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(n, n2, bufferedImage.getTransparency());
    }

    public static BufferedImage createCompatibleImage(int n, int n2) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(n, n2, 1) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(n, n2);
    }

    public static BufferedImage createCompatibleTranslucentImage(int n, int n2) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(n, n2, 2) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(n, n2, 3);
    }

    public static BufferedImage loadCompatibleImage(URL uRL) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(uRL);
        return GraphicsUtilities.toCompatibleImage(bufferedImage);
    }

    public static BufferedImage toCompatibleImage(BufferedImage bufferedImage) {
        if (GraphicsUtilities.isHeadless()) {
            return bufferedImage;
        }
        if (bufferedImage.getColorModel().equals(GraphicsUtilities.getGraphicsConfiguration().getColorModel())) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        return bufferedImage2;
    }

    public static BufferedImage createThumbnailFast(BufferedImage bufferedImage, int n) {
        int n2;
        int n3 = bufferedImage.getWidth();
        if (n3 > (n2 = bufferedImage.getHeight())) {
            if (n >= n3) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float f = (float)n3 / (float)n2;
            n3 = n;
            n2 = (int)((float)n / f);
        } else {
            if (n >= n2) {
                throw new IllegalArgumentException("newSize must be lower than the image height");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float f = (float)n2 / (float)n3;
            n2 = n;
            n3 = (int)((float)n / f);
        }
        BufferedImage bufferedImage2 = GraphicsUtilities.createCompatibleImage(bufferedImage, n3, n2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage createThumbnailFast(BufferedImage bufferedImage, int n, int n2) {
        if (n >= bufferedImage.getWidth() || n2 >= bufferedImage.getHeight()) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage bufferedImage2 = GraphicsUtilities.createCompatibleImage(bufferedImage, n, n2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage createThumbnail(BufferedImage bufferedImage, int n) {
        boolean bl;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        boolean bl2 = bufferedImage.getTransparency() != 1;
        boolean bl3 = bl = n2 > n3;
        if (bl) {
            if (n >= n2) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
        } else if (n >= n3) {
            throw new IllegalArgumentException("newSize must be lower than the image height");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("newSize must be greater than 0");
        }
        float f = (float)n2 / (float)n3;
        float f2 = (float)n3 / (float)n2;
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = null;
        Graphics graphics = null;
        int n4 = n2;
        int n5 = n3;
        do {
            if (bl) {
                if ((n2 /= 2) < n) {
                    n2 = n;
                }
                n3 = (int)((float)n2 / f);
            } else {
                if ((n3 /= 2) < n) {
                    n3 = n;
                }
                n2 = (int)((float)n3 / f2);
            }
            if (bufferedImage3 == null || bl2) {
                if (graphics != null) {
                    graphics.dispose();
                }
                bufferedImage3 = GraphicsUtilities.createCompatibleImage(bufferedImage, n2, n3);
                graphics = bufferedImage3.createGraphics();
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            graphics.drawImage(bufferedImage2, 0, 0, n2, n3, 0, 0, n4, n5, null);
            n4 = n2;
            n5 = n3;
            bufferedImage2 = bufferedImage3;
        } while (n != (bl ? n2 : n3));
        graphics.dispose();
        if (n2 != bufferedImage2.getWidth() || n3 != bufferedImage2.getHeight()) {
            bufferedImage3 = GraphicsUtilities.createCompatibleImage(bufferedImage, n2, n3);
            graphics = bufferedImage3.createGraphics();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.drawImage(bufferedImage2, 0, 0, n2, n3, 0, 0, n2, n3, null);
            graphics.dispose();
            bufferedImage2 = bufferedImage3;
        }
        return bufferedImage2;
    }

    public static BufferedImage createThumbnail(BufferedImage bufferedImage, int n, int n2) {
        boolean bl;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        boolean bl2 = bl = bufferedImage.getTransparency() != 1;
        if (n >= n3 || n2 >= n4) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = null;
        Graphics graphics = null;
        int n5 = n3;
        int n6 = n4;
        do {
            if ((n3 /= 2) < n) {
                n3 = n;
            }
            if ((n4 /= 2) < n2) {
                n4 = n2;
            }
            if (bufferedImage3 == null || bl) {
                if (graphics != null) {
                    graphics.dispose();
                }
                bufferedImage3 = GraphicsUtilities.createCompatibleImage(bufferedImage, n3, n4);
                graphics = bufferedImage3.createGraphics();
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            graphics.drawImage(bufferedImage2, 0, 0, n3, n4, 0, 0, n5, n6, null);
            n5 = n3;
            n6 = n4;
            bufferedImage2 = bufferedImage3;
        } while (n3 != n || n4 != n2);
        graphics.dispose();
        if (n3 != bufferedImage2.getWidth() || n4 != bufferedImage2.getHeight()) {
            bufferedImage3 = GraphicsUtilities.createCompatibleImage(bufferedImage, n3, n4);
            graphics = bufferedImage3.createGraphics();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.drawImage(bufferedImage2, 0, 0, n3, n4, 0, 0, n3, n4, null);
            graphics.dispose();
            bufferedImage2 = bufferedImage3;
        }
        return bufferedImage2;
    }

    public static int[] getPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (n3 == 0 || n4 == 0) {
            return new int[0];
        }
        if (nArray == null) {
            nArray = new int[n3 * n4];
        } else if (nArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            return (int[])writableRaster.getDataElements(n, n2, n3, n4, nArray);
        }
        return bufferedImage.getRGB(n, n2, n3, n4, nArray, 0, n3);
    }

    public static void setPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (nArray == null || n3 == 0 || n4 == 0) {
            return;
        }
        if (nArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.setDataElements(n, n2, n3, n4, nArray);
        } else {
            bufferedImage.setRGB(n, n2, n3, n4, nArray, 0, n3);
        }
    }
}

