/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.busylabel;

import com.agfa.pacs.base.swing.busylabel.BusyPainter;
import com.agfa.pacs.base.swing.busylabel.LookAndFeelAddons;
import com.agfa.pacs.base.swing.busylabel.PainterIcon;
import com.agfa.pacs.base.swing.busylabel.plaf.BusyLabelAddon;
import com.agfa.pacs.base.swing.busylabel.plaf.BusyLabelUI;
import com.agfa.pacs.base.swing.util.GUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.LabelUI;

public class JXBusyLabel
extends JLabel {
    private static final int DEFAULT_DELAY = 500;
    private static final long serialVersionUID = 5979268460848257147L;
    private BusyPainter busyPainter;
    private Timer busy;
    private int delay = 500;
    private boolean wasBusyOnNotify = false;
    public static final String uiClassID = "BusyLabelUI";
    private Direction direction;

    static {
        LookAndFeelAddons.contribute(new BusyLabelAddon());
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
        this.getBusyPainter().setDirection(direction);
    }

    public JXBusyLabel() {
        this(GUI.getScaledDimension(24, 24));
    }

    public JXBusyLabel(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.getBusyPainter();
    }

    protected void initPainter(Dimension dimension) {
        BusyPainter busyPainter = this.getBusyPainter();
        if (busyPainter != null) {
            busyPainter.setCacheable(false);
        }
        PainterIcon painterIcon = new PainterIcon(dimension);
        painterIcon.setPainter(busyPainter);
        this.setPreferredSize(dimension);
        this.setIcon(painterIcon);
        if (busyPainter != null) {
            busyPainter.setBaseColor(new Color(120, 120, 120));
        }
    }

    protected BusyPainter createBusyPainter(Dimension dimension) {
        BusyPainter busyPainter = null;
        BusyLabelUI busyLabelUI = (BusyLabelUI)((Object)this.getUI());
        if (busyLabelUI != null) {
            busyPainter = busyLabelUI.getBusyPainter(dimension);
        }
        return busyPainter;
    }

    public boolean isBusy() {
        return this.busy != null;
    }

    public void setBusy(boolean bl) {
        boolean bl2 = this.isBusy();
        if (!bl2 && bl) {
            this.startAnimation();
            this.firePropertyChange("busy", bl2, this.isBusy());
        } else if (bl2 && !bl) {
            this.stopAnimation();
            this.firePropertyChange("busy", bl2, this.isBusy());
        }
    }

    private void startAnimation() {
        if (this.busy != null) {
            this.stopAnimation();
        }
        this.busy = new Timer(this.delay, new ActionListener(){
            BusyPainter busyPainter;
            int frame;
            {
                this.busyPainter = JXBusyLabel.this.getBusyPainter();
                this.frame = this.busyPainter.getPoints();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.frame = (this.frame + 1) % this.busyPainter.getPoints();
                this.busyPainter.setFrame(JXBusyLabel.this.direction == Direction.LEFT ? this.busyPainter.getPoints() - this.frame : this.frame);
                JXBusyLabel.this.frameChanged();
            }
        });
        this.busy.start();
    }

    private void stopAnimation() {
        if (this.busy != null) {
            this.busy.stop();
            this.getBusyPainter().setFrame(-1);
            this.repaint();
            this.busy = null;
        }
    }

    @Override
    public void removeNotify() {
        this.wasBusyOnNotify = this.isBusy();
        this.stopAnimation();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.wasBusyOnNotify) {
            this.startAnimation();
        }
    }

    protected void frameChanged() {
        this.repaint();
    }

    public final BusyPainter getBusyPainter() {
        if (this.busyPainter == null) {
            Dimension dimension = this.getPreferredSize();
            this.busyPainter = this.createBusyPainter(dimension);
            if (this.busyPainter != null) {
                if (dimension == null) {
                    Rectangle rectangle = this.busyPainter.getTrajectory().getBounds();
                    Rectangle rectangle2 = this.busyPainter.getPointShape().getBounds();
                    int n = Math.max(rectangle2.width, rectangle2.height);
                    dimension = new Dimension(rectangle.width + n, rectangle.height + n);
                }
                this.initPainter(dimension);
            }
        }
        return this.busyPainter;
    }

    public final void setBusyPainter(BusyPainter busyPainter) {
        this.busyPainter = busyPainter;
        this.initPainter(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        int n2 = this.getDelay();
        this.delay = n;
        if (n2 != this.getDelay()) {
            if (this.busy != null && this.busy.isRunning()) {
                this.busy.setDelay(this.getDelay());
            }
            this.firePropertyChange("delay", n2, this.getDelay());
        }
    }

    @Override
    public void updateUI() {
        this.setUI((LabelUI)LookAndFeelAddons.getUI(this, BusyLabelUI.class));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public static enum Direction {
        RIGHT,
        LEFT;

    }
}

