/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.lists.models;

import com.agfa.pacs.base.swing.lists.models.AbstractMutableListModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class GenericDataMutableListModel<T>
extends AbstractMutableListModel<T> {
    private List<T> data;
    private Comparator<? super T> comparator;
    private List<T> dataAsUnmodifiableList;

    public GenericDataMutableListModel(List<T> list, Comparator<? super T> comparator) {
        this.data = list;
        this.comparator = comparator;
        this.dataAsUnmodifiableList = Collections.unmodifiableList(list);
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
    }

    public GenericDataMutableListModel(List<T> list) {
        this(list, null);
    }

    @Override
    public T getElementAt(int n) {
        if (n >= 0 && n < this.data.size()) {
            return this.data.get(n);
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public void addAll(Collection<T> collection) {
        this.data.addAll(collection);
        if (this.comparator != null) {
            Collections.sort(this.data, this.comparator);
        }
        this.fireListChanged();
    }

    @Override
    public final int addElement(T t) {
        return this.addElementImpl(this.data.size(), t);
    }

    @Override
    public final int addElement(int n, T t) {
        return this.addElementImpl(n, t);
    }

    protected int addElementImpl(int n, T t) {
        return this.addElementInternal(n, t);
    }

    @Override
    protected int addElementInternal(int n, T t) {
        if (this.comparator != null) {
            n = Collections.binarySearch(this.data, t, this.comparator);
            if (n < 0) {
                n = -n - 1;
            }
            this.data.add(n, t);
        } else {
            this.data.add(n, t);
        }
        this.fireIntervalAdded(this, n, n);
        return n;
    }

    @Override
    public List<T> getAll() {
        return this.dataAsUnmodifiableList;
    }

    @Override
    public int getIndexOf(T t) {
        return this.data.indexOf(t);
    }

    @Override
    public void removeAll() {
        this.data.clear();
        this.fireListChanged();
    }

    @Override
    public boolean removeElement(T t) {
        int n = this.data.indexOf(t);
        if (n >= 0) {
            this.data.remove(n);
            this.fireIntervalRemoved(this, n, n);
            return true;
        }
        return false;
    }

    @Override
    public T removeElementAt(int n) {
        return this.removeElementAtInternal(n);
    }

    @Override
    protected T removeElementAtInternal(int n) {
        T t = this.data.remove(n);
        this.fireIntervalRemoved(this, n, n);
        return t;
    }

    @Override
    public boolean canHandleSwap() {
        return this.comparator == null;
    }

    @Override
    public int elementChanged(int n) {
        if (this.comparator == null) {
            T t = this.removeElementAtInternal(n);
            return this.addElementInternal(this.data.size(), t);
        }
        this.fireContentsChanged(this, n, n);
        return n;
    }

    public boolean containsElement(T t) {
        if (this.comparator == null) {
            return this.data.contains(t);
        }
        return Collections.binarySearch(this.data, t, this.comparator) >= 0;
    }
}

