/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.listsearch;

import com.agfa.pacs.base.swing.Messages;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class ListSearchEngine
implements ListDataListener {
    private ListModel listModel;
    private ListSelectionModel selectionModel;
    private boolean caseSensitive;
    private int currentItem;
    private String searchString;

    ListSearchEngine(ListModel listModel, ListSelectionModel listSelectionModel, boolean bl) {
        this.selectionModel = listSelectionModel;
        this.setListModel(listModel);
    }

    private void findNext() {
        if (this.searchString == null) {
            this.searchString = "";
        }
        String string = !this.caseSensitive ? this.searchString.toUpperCase(Locale.getDefault()) : this.searchString;
        int n = this.currentItem + 1;
        while (n < this.listModel.getSize()) {
            String string2 = !this.caseSensitive ? this.listModel.getElementAt(n).toString().toUpperCase(Locale.getDefault()) : this.listModel.getElementAt(n).toString();
            int n2 = string2.indexOf(string);
            if (n2 > -1) {
                this.currentItem = n;
                if (this.selectionModel != null) {
                    this.selectionModel.setSelectionInterval(n, n);
                }
                return;
            }
            ++n;
        }
    }

    private void findPrevious() {
        if (this.searchString == null) {
            this.searchString = "";
        }
        String string = !this.caseSensitive ? this.searchString.toUpperCase(Locale.getDefault()) : this.searchString;
        int n = this.currentItem - 1;
        while (n >= 0) {
            String string2 = !this.caseSensitive ? this.listModel.getElementAt(n).toString().toUpperCase(Locale.getDefault()) : this.listModel.getElementAt(n).toString();
            int n2 = string2.indexOf(string);
            if (n2 > -1) {
                this.currentItem = n;
                if (this.selectionModel != null) {
                    this.selectionModel.setSelectionInterval(n, n);
                }
                return;
            }
            --n;
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() <= this.currentItem && listDataEvent.getIndex1() >= this.currentItem) {
            this.reset();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() <= this.currentItem) {
            this.reset();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() <= this.currentItem) {
            this.reset();
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String string) {
        if (this.searchString != null) {
            if (this.caseSensitive) {
                if (this.searchString.equals(string)) {
                    return;
                }
                this.searchString = string;
            } else {
                if (this.searchString.equalsIgnoreCase(string)) {
                    return;
                }
                this.searchString = string;
            }
        } else {
            this.searchString = string;
        }
        this.reset();
        this.findNext();
    }

    public Action[] getActions() {
        Action[] actionArray = new Action[]{new FindPreviousAction(), new FindNextAction()};
        return actionArray;
    }

    private void reset() {
        this.currentItem = -1;
    }

    public void setListModel(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("List model must not be null.");
        }
        this.listModel = listModel;
        this.reset();
    }

    private class FindNextAction
    extends AbstractAction {
        public FindNextAction() {
            super(Messages.getString("ListSearchEngine.Next"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListSearchEngine.this.findNext();
        }
    }

    private class FindPreviousAction
    extends AbstractAction {
        public FindPreviousAction() {
            super(Messages.getString("ListSearchEngine.Previous"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListSearchEngine.this.findPrevious();
        }
    }
}

