/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.monitor;

import com.agfa.pacs.base.swing.monitor.IMonitorConfiguration;
import com.agfa.pacs.base.swing.monitor.MonitorPosition;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.logging.ALogger;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class MonitorConfiguration
implements IMonitorConfiguration {
    private static MonitorConfiguration configuration = new MonitorConfiguration();
    private List<List<MonitorPosition>> monitors;
    private GraphicsConfiguration[] availableScreens = null;

    public static IMonitorConfiguration getConfiguration() {
        return configuration;
    }

    @Override
    public MonitorPosition getLTAPosition(Integer n) {
        List<List<MonitorPosition>> list = this.getMonitorPositions();
        MonitorPosition monitorPosition = null;
        if (n == null) {
            monitorPosition = list.get(list.size() - 1).get(0);
        } else {
            monitorPosition = this.getMonitorByIndex(list, n - 1);
            if (monitorPosition == null) {
                monitorPosition = this.getDefaultMonitor(list);
            }
        }
        monitorPosition.setGraphicsConfiguration(this.availableScreens[monitorPosition.graphicsDeviceIndex]);
        return monitorPosition;
    }

    private MonitorPosition getMonitorByIndex(List<List<MonitorPosition>> list, int n) {
        for (List<MonitorPosition> list2 : list) {
            for (MonitorPosition monitorPosition : list2) {
                if (monitorPosition.graphicsDeviceIndex != n) continue;
                return monitorPosition;
            }
        }
        return null;
    }

    private MonitorPosition getDefaultMonitor(List<List<MonitorPosition>> list) {
        for (List<MonitorPosition> list2 : list) {
            for (MonitorPosition monitorPosition : list2) {
                if (!monitorPosition.isDefault) continue;
                return monitorPosition;
            }
        }
        return null;
    }

    @Override
    public int getIndexOfGraphicsConfiguration(GraphicsConfiguration graphicsConfiguration) {
        if (this.availableScreens == null) {
            this.initMonitors();
        }
        int n = 0;
        while (n < this.availableScreens.length) {
            if (this.availableScreens[n] == graphicsConfiguration) {
                return n + 1;
            }
            ++n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<MonitorPosition>> getMonitorPositions() {
        if (this.monitors == null) {
            MonitorConfiguration monitorConfiguration = this;
            synchronized (monitorConfiguration) {
                if (this.monitors == null) {
                    try {
                        EventUtil.invokeSynchronous(new Runnable(){

                            @Override
                            public void run() {
                                MonitorConfiguration.this.initMonitors();
                            }
                        });
                    }
                    catch (Exception exception) {
                        ALogger.getLogger(MonitorConfiguration.class).error("Could not obtain monitor configuration", (Throwable)exception);
                    }
                }
            }
        }
        return this.monitors;
    }

    private void initMonitors() {
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.availableScreens = new GraphicsConfiguration[graphicsDeviceArray.length];
        ArrayList<GraphicsDevice> arrayList = new ArrayList<GraphicsDevice>(graphicsDeviceArray.length);
        int n = 0;
        while (n < graphicsDeviceArray.length) {
            if (graphicsDeviceArray[n].getType() == 0) {
                arrayList.add(graphicsDeviceArray[n]);
                this.availableScreens[n] = graphicsDeviceArray[n].getDefaultConfiguration();
            }
            ++n;
        }
        GraphicsDevice[] graphicsDeviceArray2 = arrayList.toArray(new GraphicsDevice[arrayList.size()]);
        Arrays.sort(graphicsDeviceArray2, new DeviceSorter());
        ArrayList<List<MonitorPosition>> arrayList2 = new ArrayList<List<MonitorPosition>>(1);
        ArrayList<MonitorPosition> arrayList3 = new ArrayList<MonitorPosition>(3);
        arrayList2.add(arrayList3);
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < graphicsDeviceArray2.length) {
            boolean bl;
            GraphicsDevice graphicsDevice2 = graphicsDeviceArray2[n3];
            Rectangle rectangle = graphicsDevice2.getDefaultConfiguration().getBounds();
            boolean bl2 = bl = graphicsDevice2 == graphicsDevice;
            if (n3 == 0 || n2 >= rectangle.x) {
                n2 = rectangle.x;
                if (n3 > 0) {
                    arrayList3 = new ArrayList();
                    arrayList2.add(arrayList3);
                }
            }
            arrayList3.add(new MonitorPosition(MonitorConfiguration.getOriginalIndex(graphicsDeviceArray, graphicsDevice2), rectangle, bl));
            ++n3;
        }
        this.monitors = arrayList2;
    }

    private static int getOriginalIndex(GraphicsDevice[] graphicsDeviceArray, GraphicsDevice graphicsDevice) {
        int n = 0;
        while (n < graphicsDeviceArray.length) {
            if (graphicsDeviceArray[n] == graphicsDevice) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Device not found!");
    }

    private MonitorConfiguration() {
    }

    @Override
    public Rectangle getBoundsOfScreenWithPoint(Point point) {
        if (point != null) {
            GraphicsConfiguration[] graphicsConfigurationArray = this.availableScreens;
            int n = this.availableScreens.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[n2];
                if (graphicsConfiguration.getBounds().contains(point)) {
                    return graphicsConfiguration.getBounds();
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfigurationByBounds(Rectangle rectangle) {
        if (this.availableScreens == null) {
            this.initMonitors();
        }
        int n = rectangle.x + rectangle.width / 2;
        int n2 = rectangle.y + rectangle.height / 2;
        GraphicsConfiguration[] graphicsConfigurationArray = this.availableScreens;
        int n3 = this.availableScreens.length;
        int n4 = 0;
        while (n4 < n3) {
            GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[n4];
            if (graphicsConfiguration.getBounds().contains(n, n2)) {
                return graphicsConfiguration;
            }
            ++n4;
        }
        return null;
    }

    private static class DeviceSorter
    implements Comparator<GraphicsDevice> {
        private DeviceSorter() {
        }

        @Override
        public int compare(GraphicsDevice graphicsDevice, GraphicsDevice graphicsDevice2) {
            int n = graphicsDevice.getDefaultConfiguration().getBounds().y - graphicsDevice2.getDefaultConfiguration().getBounds().y;
            if (n != 0) {
                return n;
            }
            int n2 = graphicsDevice.getDefaultConfiguration().getBounds().x - graphicsDevice2.getDefaultConfiguration().getBounds().x;
            return n2;
        }
    }
}

