/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.progress.impl;

import com.agfa.pacs.base.swing.progress.IActivityIndicator;
import com.agfa.pacs.base.swing.progress.impl.ActivityDisplay;
import com.agfa.pacs.base.swing.progress.impl.ActivityDisplayContainerListener;
import com.agfa.pacs.base.swing.progress.impl.DialogActivityDisplayContainer;
import com.agfa.pacs.base.swing.progress.impl.IActivityDisplayContainer;
import com.agfa.pacs.base.swing.progress.impl.LayeredActivityDisplayContainer;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JRootPane;

class ActivityDisplayContainerFactory {
    private static ActivityDisplayContainerFactory instance = null;
    private Map<JRootPane, IActivityDisplayContainer> map = new HashMap<JRootPane, IActivityDisplayContainer>();
    private ActivityDisplayContainerListener adContainerListener = new InternalADContainerListener();

    private ActivityDisplayContainerFactory() {
    }

    public static synchronized ActivityDisplayContainerFactory getInstance() {
        if (instance == null) {
            instance = new ActivityDisplayContainerFactory();
        }
        return instance;
    }

    public synchronized IActivityDisplayContainer getActivityDisplayContainer(Component component, IActivityIndicator.DisplayMode displayMode) {
        IActivityDisplayContainer iActivityDisplayContainer = this.map.get(component);
        if (iActivityDisplayContainer == null) {
            iActivityDisplayContainer = this.createActivityDisplayContainer(component, displayMode);
        }
        return iActivityDisplayContainer;
    }

    public synchronized boolean hasActivityDisplayContainer(Component component) {
        return this.map.containsKey(component);
    }

    private IActivityDisplayContainer createActivityDisplayContainer(Component component, IActivityIndicator.DisplayMode displayMode) {
        IActivityDisplayContainer iActivityDisplayContainer = null;
        iActivityDisplayContainer = IActivityIndicator.DisplayMode.DIALOG.equals((Object)displayMode) ? new DialogActivityDisplayContainer(component) : new LayeredActivityDisplayContainer(component);
        iActivityDisplayContainer.addActivityDisplayContainerListener(this.adContainerListener);
        this.map.put(iActivityDisplayContainer.getRootPane(), iActivityDisplayContainer);
        return iActivityDisplayContainer;
    }

    private void removeActivityDisplayContainer(IActivityDisplayContainer iActivityDisplayContainer) {
        JRootPane jRootPane;
        if (iActivityDisplayContainer != null && (jRootPane = iActivityDisplayContainer.getRootPane()) != null) {
            iActivityDisplayContainer.removeActivityDisplayContainerListener(this.adContainerListener);
            this.map.remove(jRootPane);
        }
    }

    private class InternalADContainerListener
    implements ActivityDisplayContainerListener {
        private InternalADContainerListener() {
        }

        @Override
        public void activityDisplayAdded(IActivityDisplayContainer iActivityDisplayContainer, ActivityDisplay activityDisplay) {
        }

        @Override
        public void activityDisplayRemoved(IActivityDisplayContainer iActivityDisplayContainer, ActivityDisplay activityDisplay) {
            if (iActivityDisplayContainer.getActivityDisplayCount() == 0) {
                ActivityDisplayContainerFactory.this.removeActivityDisplayContainer(iActivityDisplayContainer);
            }
        }
    }
}

