/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.progress.impl;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.progress.IActivityIndicator;
import com.agfa.pacs.base.swing.progress.impl.ActivityDisplay;
import com.agfa.pacs.base.swing.progress.impl.ActivityDisplayContainerFactory;
import com.agfa.pacs.base.swing.progress.impl.IActivityDisplayContainer;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.JobState;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Arrays;

public class ActivityIndicator
implements IActivityIndicator {
    protected final IComponentFactory componentFactory;
    private IActivityDisplayContainer adc;
    protected ActivityDisplay[] displays;

    public ActivityIndicator(Component component, IComponentFactory iComponentFactory, int n, IActivityIndicator.DisplayMode displayMode) {
        this.componentFactory = iComponentFactory;
        this.adc = ActivityDisplayContainerFactory.getInstance().getActivityDisplayContainer(component, displayMode);
        this.displays = new ActivityDisplay[n];
        int n2 = 0;
        while (n2 < n) {
            this.displays[n2] = this.createDisplay();
            ++n2;
        }
        this.adc.addActivityDisplays(Arrays.asList(this.displays));
    }

    @Override
    public void close() {
        if (this.displays != null) {
            this.setState(JobState.FINISHED);
            this.adc.removeActivityDisplays(Arrays.asList(this.displays));
            this.displays = null;
        }
    }

    @Override
    public void show() {
        EventUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (ActivityIndicator.this.displays != null) {
                    ActivityDisplay[] activityDisplayArray = ActivityIndicator.this.displays;
                    int n = ActivityIndicator.this.displays.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ActivityDisplay activityDisplay = activityDisplayArray[n2];
                        activityDisplay.setVisible(true);
                        ++n2;
                    }
                }
            }
        });
    }

    @Override
    public void setState(JobState jobState) {
        ActivityDisplay[] activityDisplayArray = this.displays;
        int n = this.displays.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityDisplay activityDisplay = activityDisplayArray[n2];
            activityDisplay.getActivityState().setState(jobState);
            ++n2;
        }
    }

    @Override
    public void setText(String string) {
        ActivityDisplay[] activityDisplayArray = this.displays;
        int n = this.displays.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityDisplay activityDisplay = activityDisplayArray[n2];
            activityDisplay.getActivityState().setText(string);
            ++n2;
        }
    }

    public void setHideable(final boolean bl) {
        EventUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (ActivityIndicator.this.displays != null) {
                    ActivityDisplay[] activityDisplayArray = ActivityIndicator.this.displays;
                    int n = ActivityIndicator.this.displays.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ActivityDisplay activityDisplay = activityDisplayArray[n2];
                        activityDisplay.setHideable(bl);
                        ++n2;
                    }
                }
            }
        });
    }

    public void addHideListener(ActionListener actionListener) {
        if (this.displays != null) {
            ActivityDisplay[] activityDisplayArray = this.displays;
            int n = this.displays.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityDisplay activityDisplay = activityDisplayArray[n2];
                activityDisplay.addHideListener(actionListener);
                ++n2;
            }
        }
    }

    protected ActivityDisplay createDisplay() {
        return new ActivityDisplay(this.componentFactory);
    }
}

