/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.progress.impl;

import com.agfa.pacs.base.swing.progress.impl.ActivityDisplay;
import com.agfa.pacs.base.swing.progress.impl.ActivityDisplayContainerListener;
import com.agfa.pacs.base.swing.progress.impl.IActivityDisplayContainer;
import com.agfa.pacs.base.swing.util.EventUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

class LayeredActivityDisplayContainer
implements IActivityDisplayContainer {
    private JRootPane rootPane;
    private Component client;
    private static final int PROGRESS_LAYER = 450;
    private List<ActivityDisplay> displays;
    private Collection<ActivityDisplayContainerListener> listener;
    private JPanel displayLayer;
    private ResizeListener resizeListener;

    protected LayeredActivityDisplayContainer(Component component) {
        this.client = component;
        this.rootPane = SwingUtilities.getRootPane(component);
        this.displays = new ArrayList<ActivityDisplay>();
        this.resizeListener = new ResizeListener();
        this.listener = new ArrayList<ActivityDisplayContainerListener>();
        this.createComponents();
    }

    @Override
    public int getActivityDisplayCount() {
        return this.displays.size();
    }

    @Override
    public ActivityDisplay getActivityDisplay(int n) throws IllegalArgumentException {
        return this.displays.get(n);
    }

    @Override
    public Iterable<ActivityDisplay> getActivityDisplays() {
        return this.displays;
    }

    @Override
    public Component getClient() {
        return this.client;
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    @Override
    public synchronized void addActivityDisplays(Collection<ActivityDisplay> collection) {
        assert (collection != null) : "param displays is null!";
        if (!collection.isEmpty()) {
            this.displays.addAll(collection);
            for (ActivityDisplay activityDisplay : collection) {
                activityDisplay.setActivityDisplayContainer(this);
            }
            this.updateContainer();
            for (ActivityDisplay activityDisplay : collection) {
                this.fireActivityDisplayAdded(activityDisplay);
            }
        }
    }

    @Override
    public synchronized void removeActivityDisplays(Collection<ActivityDisplay> collection) {
        assert (collection != null) : "param displays is null!";
        if (!this.displays.isEmpty()) {
            ArrayList<ActivityDisplay> arrayList = new ArrayList<ActivityDisplay>();
            for (ActivityDisplay activityDisplay : collection) {
                if (!this.displays.contains(activityDisplay)) continue;
                activityDisplay.setActivityDisplayContainer(null);
                arrayList.add(activityDisplay);
            }
            this.displays.removeAll(arrayList);
            this.updateContainer();
            for (ActivityDisplay activityDisplay : arrayList) {
                this.fireActivityDisplayRemoved(activityDisplay);
            }
        }
    }

    @Override
    public void addActivityDisplayContainerListener(ActivityDisplayContainerListener activityDisplayContainerListener) {
        if (activityDisplayContainerListener != null && !this.listener.contains(activityDisplayContainerListener)) {
            this.listener.add(activityDisplayContainerListener);
        }
    }

    @Override
    public void removeActivityDisplayContainerListener(ActivityDisplayContainerListener activityDisplayContainerListener) {
        if (activityDisplayContainerListener != null && this.listener.contains(activityDisplayContainerListener)) {
            this.listener.remove(activityDisplayContainerListener);
        }
    }

    private void createComponents() {
        this.displayLayer = new JPanel();
        this.displayLayer.setOpaque(false);
    }

    private void updateContainer() {
        try {
            EventUtil.invoke(new Runnable(){

                @Override
                public void run() {
                    if (LayeredActivityDisplayContainer.this.rootPane != null) {
                        LayeredActivityDisplayContainer.this.updateProgressLayerLayout();
                        LayeredActivityDisplayContainer.this.updateProgressLayerSize();
                        if (LayeredActivityDisplayContainer.this.shouldInstallProgressLayer()) {
                            LayeredActivityDisplayContainer.this.installProgressLayer();
                        } else if (LayeredActivityDisplayContainer.this.shouldUninstallProgressLayer()) {
                            LayeredActivityDisplayContainer.this.uninstallProgressLayer();
                        }
                        LayeredActivityDisplayContainer.this.rootPane.revalidate();
                        LayeredActivityDisplayContainer.this.rootPane.repaint();
                    }
                }
            });
        }
        catch (Exception exception) {}
    }

    private void installProgressLayer() {
        JLayeredPane jLayeredPane = this.rootPane.getLayeredPane();
        jLayeredPane.add((Component)this.displayLayer, 450);
        this.client.addComponentListener(this.resizeListener);
    }

    private void uninstallProgressLayer() {
        JLayeredPane jLayeredPane = this.rootPane.getLayeredPane();
        jLayeredPane.remove(this.displayLayer);
        this.client.removeComponentListener(this.resizeListener);
    }

    private boolean shouldInstallProgressLayer() {
        return this.rootPane != null && this.displayLayer.getParent() != this.rootPane.getLayeredPane() && !this.displays.isEmpty();
    }

    private boolean shouldUninstallProgressLayer() {
        return this.rootPane != null && this.displayLayer.getParent() == this.rootPane.getLayeredPane() && this.displays.isEmpty();
    }

    private void updateProgressLayerLayout() {
        this.displayLayer.removeAll();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.displayLayer.setLayout(gridBagLayout);
        int n = 0;
        for (ActivityDisplay activityDisplay : this.displays) {
            gridBagLayout.setConstraints(activityDisplay, new GridBagConstraints(n, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.displayLayer.add(activityDisplay);
            ++n;
        }
    }

    private void updateProgressLayerSize() {
        if (this.rootPane != null) {
            Point point = SwingUtilities.convertPoint(this.client, 0, 0, this.rootPane.getLayeredPane());
            this.displayLayer.setLocation(point);
            Insets insets = this.client instanceof JComponent ? ((JComponent)this.client).getInsets() : new Insets(0, 0, 0, 0);
            int n = this.client.getWidth() - insets.left - insets.right;
            int n2 = this.client.getHeight() - insets.top - insets.bottom;
            this.displayLayer.setSize(n, n2);
        }
    }

    private void fireActivityDisplayAdded(ActivityDisplay activityDisplay) {
        for (ActivityDisplayContainerListener activityDisplayContainerListener : this.listener) {
            activityDisplayContainerListener.activityDisplayAdded(this, activityDisplay);
        }
    }

    private void fireActivityDisplayRemoved(ActivityDisplay activityDisplay) {
        ArrayList<ActivityDisplayContainerListener> arrayList = new ArrayList<ActivityDisplayContainerListener>(this.listener);
        for (ActivityDisplayContainerListener activityDisplayContainerListener : arrayList) {
            activityDisplayContainerListener.activityDisplayRemoved(this, activityDisplay);
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (LayeredActivityDisplayContainer.this.rootPane != null && component == LayeredActivityDisplayContainer.this.client) {
                LayeredActivityDisplayContainer.this.updateProgressLayerSize();
                LayeredActivityDisplayContainer.this.displayLayer.revalidate();
                LayeredActivityDisplayContainer.this.displayLayer.repaint();
            }
        }
    }
}

