/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.progress.impl;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.progress.IActivityIndicator;
import com.agfa.pacs.base.swing.progress.IProgressIndicator;
import com.agfa.pacs.base.swing.progress.impl.ActivityDisplay;
import com.agfa.pacs.base.swing.progress.impl.ActivityIndicator;
import com.agfa.pacs.base.swing.progress.impl.ProgressDisplay;
import java.awt.Component;

public class ProgressIndicator
extends ActivityIndicator
implements IProgressIndicator {
    private long progressAmount;
    private long progressCounter;

    public ProgressIndicator(Component component, IComponentFactory iComponentFactory, int n, IActivityIndicator.DisplayMode displayMode) {
        super(component, iComponentFactory, n, displayMode);
    }

    @Override
    public void setProgress(float f) {
        ActivityDisplay[] activityDisplayArray = this.displays;
        int n = this.displays.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityDisplay activityDisplay = activityDisplayArray[n2];
            ((ProgressDisplay)activityDisplay).getProgressState().setProgress(f);
            ++n2;
        }
    }

    @Override
    public void advanceProgress() {
        ++this.progressCounter;
        this.setProgress((float)this.progressCounter / (float)this.progressAmount);
    }

    @Override
    public void reset() {
        this.progressAmount = 0L;
        this.progressCounter = 0L;
        this.setProgress(0.0f);
    }

    @Override
    public void setTotalProgressAmount(long l) {
        this.progressAmount = l;
    }

    @Override
    protected ProgressDisplay createDisplay() {
        return new ProgressDisplay(this.componentFactory);
    }
}

