/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.twolists;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.Messages;
import com.agfa.pacs.base.swing.listsearch.ListSearchPanel;
import com.agfa.pacs.base.swing.twolists.IFilter;
import com.agfa.pacs.base.swing.twolists.IListItemEditor;
import com.agfa.pacs.base.swing.twolists.IMutableListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TwoLists<T>
extends JPanel {
    private JList listSource;
    private JList listDest;
    private IMutableListModel<T> listModelSource;
    private IMutableListModel<T> listModelDestination;
    private ListSearchPanel listSearchPanelDest;
    private ListSearchPanel listSearchPanelSource;
    private UpAction sourceUpAction;
    private UpAction destUpAction;
    private DownAction sourceDownAction;
    private DownAction destDownAction;
    private IListItemEditor<T> listItemEditorSource;
    private IListItemEditor<T> listItemEditorDestination;
    private List<T> excludedItems;
    private boolean manualEditPossible;

    public TwoLists(IMutableListModel<T> iMutableListModel, IMutableListModel<T> iMutableListModel2, IComponentFactory iComponentFactory) {
        this(iMutableListModel, iMutableListModel2, null, null, iComponentFactory, false);
    }

    public TwoLists(IMutableListModel<T> iMutableListModel, IMutableListModel<T> iMutableListModel2, IListItemEditor<T> iListItemEditor, IListItemEditor<T> iListItemEditor2, IComponentFactory iComponentFactory) {
        this(iMutableListModel, iMutableListModel2, iListItemEditor, iListItemEditor2, iComponentFactory, true);
    }

    public TwoLists(IMutableListModel<T> iMutableListModel, IMutableListModel<T> iMutableListModel2, IListItemEditor<T> iListItemEditor, IListItemEditor<T> iListItemEditor2, IComponentFactory iComponentFactory, boolean bl) {
        if (iMutableListModel == null) {
            throw new IllegalArgumentException("Source list model must not be null.");
        }
        if (iMutableListModel2 == null) {
            throw new IllegalArgumentException("Destination list model must not be null.");
        }
        this.listModelSource = iMutableListModel;
        this.listModelDestination = iMutableListModel2;
        this.listItemEditorSource = iListItemEditor;
        this.listItemEditorDestination = iListItemEditor2;
        this.manualEditPossible = bl;
        this.init(iComponentFactory);
    }

    public IMutableListModel<T> getListModelDestination() {
        return this.listModelDestination;
    }

    public IMutableListModel<T> getListModelSource() {
        return this.listModelSource;
    }

    void initEditSource(JPanel jPanel) {
        this.addSourceListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TwoLists.this.listSource.getSelectedIndex();
                if (n >= 0 && n < TwoLists.this.listModelSource.getSize()) {
                    Object e = TwoLists.this.listModelSource.getElementAt(n);
                    TwoLists.this.listItemEditorSource.setItem(e);
                } else {
                    TwoLists.this.listItemEditorSource.setItem(null);
                }
            }
        });
        jPanel.add((Component)this.listItemEditorSource.getEditorComponent(), "South");
        this.listItemEditorSource.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                if (changeEvent.getSource() != null && changeEvent.getSource() == TwoLists.this.listItemEditorSource.getItem() && (n = TwoLists.this.listModelSource.getIndexOf(TwoLists.this.listItemEditorSource.getItem())) >= 0) {
                    TwoLists.this.listModelSource.removeElementAt(n);
                    TwoLists.this.listModelSource.addElement(n, TwoLists.this.listItemEditorSource.getItem());
                }
            }
        });
    }

    void initEditorDestination(JPanel jPanel) {
        this.addDestinationListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TwoLists.this.listDest.getSelectedIndex();
                if (n >= 0 && n < TwoLists.this.listModelDestination.getSize()) {
                    Object e = TwoLists.this.listModelDestination.getElementAt(n);
                    TwoLists.this.listItemEditorDestination.setItem(e);
                } else {
                    TwoLists.this.listItemEditorDestination.setItem(null);
                }
            }
        });
        jPanel.add((Component)this.listItemEditorDestination.getEditorComponent(), "South");
        this.listItemEditorDestination.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() != null && changeEvent.getSource() == TwoLists.this.listItemEditorDestination.getItem()) {
                    Object t = TwoLists.this.listItemEditorDestination.getItem();
                    int n = TwoLists.this.listModelDestination.getIndexOf(TwoLists.this.listItemEditorDestination.getItem());
                    if (n >= 0) {
                        TwoLists.this.listModelDestination.removeElementAt(n);
                        TwoLists.this.listModelDestination.addElement(n, t);
                    }
                    TwoLists.this.listDest.setSelectedValue(t, true);
                }
            }
        });
    }

    private void init(IComponentFactory iComponentFactory) {
        JPanel jPanel = this.createPanel(new GridLayout(1, 2));
        JPanel jPanel2 = this.createPanel(new BorderLayout());
        JPanel jPanel3 = this.createPanel(new BorderLayout());
        JPanel jPanel4 = this.createPanel(new FlowLayout(1));
        JPanel jPanel5 = this.createPanel(new GridLayout());
        JPanel jPanel6 = this.createPanel();
        JPanel jPanel7 = this.createPanel();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        this.listSource = iComponentFactory.createList(this.listModelSource);
        this.listDest = iComponentFactory.createList(this.listModelDestination);
        this.listSource.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TwoLists.this.listSource.ensureIndexIsVisible(TwoLists.this.listSource.getSelectedIndex());
            }
        });
        this.listDest.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TwoLists.this.listDest.ensureIndexIsVisible(TwoLists.this.listDest.getSelectedIndex());
            }
        });
        JScrollPane jScrollPane = iComponentFactory.createScrollPane(this.listSource);
        JScrollPane jScrollPane2 = iComponentFactory.createScrollPane(this.listDest);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.setSize(100, Math.max(dimension.height, 100));
        jScrollPane.setPreferredSize(dimension);
        jPanel2.setBorder(iComponentFactory.createTitledBorder(new EtchedBorder(1), Messages.getString("TwoLists.Available")));
        jPanel3.setBorder(iComponentFactory.createTitledBorder(new EtchedBorder(1), Messages.getString("TwoLists.Selected")));
        jPanel2.add((Component)jScrollPane, "Center");
        this.listSearchPanelSource = new ListSearchPanel(this.listSource.getModel(), this.listSource.getSelectionModel(), false, iComponentFactory);
        jPanel2.add((Component)this.listSearchPanelSource, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        this.listSearchPanelDest = new ListSearchPanel(this.listDest.getModel(), this.listDest.getSelectionModel(), false, iComponentFactory);
        jPanel3.add((Component)this.listSearchPanelDest, "North");
        if (this.manualEditPossible) {
            jPanel5.add(iComponentFactory.createButton(new AllToLeftAction()));
            jPanel5.add(iComponentFactory.createButton(new ToLeftAction()));
            jPanel5.add(iComponentFactory.createButton(new ToRightAction()));
            jPanel5.add(iComponentFactory.createButton(new AllToRightAction()));
        }
        if (this.listModelSource.canHandleSwap()) {
            this.sourceUpAction = new UpAction(this.listModelSource, this.listSource.getSelectionModel());
            this.sourceDownAction = new DownAction(this.listModelSource, this.listSource.getSelectionModel());
            jPanel6.add(iComponentFactory.createButton(this.sourceUpAction));
            jPanel6.add(iComponentFactory.createButton(this.sourceDownAction));
            jPanel2.add((Component)jPanel6, "West");
        }
        if (this.listModelDestination.canHandleSwap()) {
            this.destUpAction = new UpAction(this.listModelDestination, this.listDest.getSelectionModel());
            this.destDownAction = new DownAction(this.listModelDestination, this.listDest.getSelectionModel());
            jPanel7.add(iComponentFactory.createButton(this.destUpAction));
            jPanel7.add(iComponentFactory.createButton(this.destDownAction));
            jPanel3.add((Component)jPanel7, "East");
        }
        if (this.listItemEditorSource != null) {
            this.initEditSource(jPanel2);
        }
        if (this.listItemEditorDestination != null) {
            this.initEditorDestination(jPanel3);
        }
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        if (this.manualEditPossible) {
            jPanel4.add(jPanel5);
        }
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel4, "South");
    }

    public void setListModelDestination(IMutableListModel<T> iMutableListModel) {
        if (iMutableListModel == null) {
            throw new IllegalArgumentException("Destination list model must not be null.");
        }
        this.listModelDestination = iMutableListModel;
        this.listDest.setModel(iMutableListModel);
        this.listSearchPanelDest.setListModel(iMutableListModel);
        if (this.destUpAction != null) {
            this.destUpAction.setListModel(iMutableListModel);
        }
        if (this.destDownAction != null) {
            this.destDownAction.setListModel(iMutableListModel);
        }
    }

    public void setListModelSource(IMutableListModel<T> iMutableListModel) {
        if (iMutableListModel == null) {
            throw new IllegalArgumentException("Source list model must not be null.");
        }
        this.listModelSource = iMutableListModel;
        this.listSource.setModel(iMutableListModel);
        this.listSearchPanelSource.setListModel(iMutableListModel);
        if (this.sourceUpAction != null) {
            this.sourceUpAction.setListModel(iMutableListModel);
        }
        if (this.sourceDownAction != null) {
            this.sourceDownAction.setListModel(iMutableListModel);
        }
    }

    public void setFilter(IFilter<T> iFilter) {
        if (this.excludedItems != null) {
            this.listModelSource.addAll(this.excludedItems);
        }
        this.excludedItems = new ArrayList<T>();
        if (iFilter != null) {
            T t;
            int n = this.listModelSource.getSize() - 1;
            while (n >= 0) {
                if (!iFilter.include(this.listModelSource.getElementAt(n)) && (t = this.listModelSource.removeElementAt(n)) != null) {
                    this.excludedItems.add(t);
                }
                --n;
            }
            n = this.listModelDestination.getSize() - 1;
            while (n >= 0) {
                if (!iFilter.include(this.listModelDestination.getElementAt(n)) && (t = this.listModelDestination.removeElementAt(n)) != null) {
                    this.excludedItems.add(t);
                }
                --n;
            }
        }
    }

    private void addSourceListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSource.addListSelectionListener(listSelectionListener);
    }

    private void addDestinationListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listDest.addListSelectionListener(listSelectionListener);
    }

    private JPanel createPanel(LayoutManager layoutManager) {
        JPanel jPanel = new JPanel();
        if (layoutManager != null) {
            jPanel.setLayout(layoutManager);
        }
        jPanel.setOpaque(false);
        return jPanel;
    }

    private JPanel createPanel() {
        return this.createPanel(null);
    }

    private class AllToLeftAction
    extends AbstractAction {
        public AllToLeftAction() {
            super("<<");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TwoLists.this.listDest.removeSelectionInterval(0, TwoLists.this.listModelDestination.getSize() - 1);
            TwoLists.this.listModelSource.addAll(TwoLists.this.listModelDestination.getAll());
            TwoLists.this.listModelDestination.removeAll();
        }
    }

    private class AllToRightAction
    extends AbstractAction {
        public AllToRightAction() {
            super(">>");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TwoLists.this.listSource.removeSelectionInterval(0, TwoLists.this.listModelSource.getSize() - 1);
            TwoLists.this.listModelDestination.addAll(TwoLists.this.listModelSource.getAll());
            TwoLists.this.listModelSource.removeAll();
        }
    }

    private class DownAction
    extends AbstractAction
    implements ListSelectionListener {
        IMutableListModel<T> listModel;
        ListSelectionModel selectionModel;

        public DownAction(IMutableListModel<T> iMutableListModel, ListSelectionModel listSelectionModel) {
            super("\u25bc");
            this.listModel = iMutableListModel;
            this.selectionModel = listSelectionModel;
            listSelectionModel.addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.selectionModel.getLeadSelectionIndex();
            int n2 = this.listModel.increaseIndexOfElementAt(n);
            this.selectionModel.setSelectionInterval(n2, n2);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getFirstIndex();
            if (n < 0 || n2 != n) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }

        public void setListModel(IMutableListModel<T> iMutableListModel) {
            this.listModel = iMutableListModel;
        }
    }

    private class ToLeftAction
    extends AbstractAction {
        public ToLeftAction() {
            super("<");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TwoLists.this.listDest.getSelectedIndices();
            int n = nArray.length - 1;
            while (n >= 0) {
                TwoLists.this.listDest.removeSelectionInterval(nArray[n], nArray[n]);
                Object t = TwoLists.this.listModelDestination.removeElementAt(nArray[n]);
                TwoLists.this.listModelSource.addElement(t);
                --n;
            }
        }
    }

    private class ToRightAction
    extends AbstractAction {
        public ToRightAction() {
            super(">");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TwoLists.this.listSource.getSelectedIndices();
            int n = nArray.length - 1;
            while (n >= 0) {
                TwoLists.this.listSource.removeSelectionInterval(nArray[n], nArray[n]);
                Object t = TwoLists.this.listModelSource.removeElementAt(nArray[n]);
                TwoLists.this.listModelDestination.addElement(t);
                --n;
            }
        }
    }

    private class UpAction
    extends AbstractAction
    implements ListSelectionListener {
        IMutableListModel<T> listModel;
        ListSelectionModel selectionModel;

        public UpAction(IMutableListModel<T> iMutableListModel, ListSelectionModel listSelectionModel) {
            super("\u25b2");
            this.listModel = iMutableListModel;
            this.selectionModel = listSelectionModel;
            listSelectionModel.addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.selectionModel.getLeadSelectionIndex();
            int n2 = this.listModel.decreaseIndexOfElementAt(n);
            this.selectionModel.setSelectionInterval(n2, n2);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getFirstIndex();
            if (n < 0 || n2 != n) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }

        public void setListModel(IMutableListModel<T> iMutableListModel) {
            this.listModel = iMutableListModel;
        }
    }
}

