/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.util;

import com.agfa.pacs.base.swing.util.ComponentUtil;
import com.agfa.pacs.base.swing.util.EventUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.RootPaneContainer;

public class CursorUtil {
    private static final Map<RootPaneContainer, Integer> rootPaneMap = new Hashtable<RootPaneContainer, Integer>();
    private static final Map<Component, RootPaneContainer[]> actionSourceMap = new Hashtable<Component, RootPaneContainer[]>();

    public static synchronized boolean isWaitCursor(Component component) {
        Component component2 = ComponentUtil.getTopLevelParentOrWindow(component);
        if (!(component2 instanceof RootPaneContainer)) {
            return false;
        }
        return rootPaneMap.get(component2) != null;
    }

    public static void setWaitCursor(Component component) {
        CursorUtil.setCursor(component, 3);
    }

    public static void setCursor(Component component, int n) {
        CursorUtil.setCursor(component, Cursor.getPredefinedCursor(n));
    }

    private static void setCursor(Component component, Cursor cursor) {
        CursorUtil.setCursor(component, true, cursor);
    }

    public static void resetWaitCursor(Component component) {
        CursorUtil.resetCursor(component, true);
    }

    public static void resetCursor(Component component) {
        CursorUtil.resetCursor(component, true);
    }

    private static synchronized void setCursor(Component component, boolean bl, Cursor cursor) {
        RootPaneContainer[] rootPaneContainerArray = CursorUtil.findRootPaneContainerParents(component, bl);
        assert (rootPaneContainerArray != null) : "The passed set-Component was null or did not have any Window/Applet parent!";
        RootPaneContainer[] rootPaneContainerArray2 = rootPaneContainerArray;
        int n = rootPaneContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            RootPaneContainer rootPaneContainer = rootPaneContainerArray2[n2];
            if (CursorUtil.incrementCallCounter(rootPaneContainer) <= 1) {
                CursorUtil.setGlassPaneCursor(rootPaneContainer, cursor);
            }
            actionSourceMap.put(component, rootPaneContainerArray);
            ++n2;
        }
    }

    private static synchronized void resetCursor(Component component, boolean bl) {
        RootPaneContainer[] rootPaneContainerArray = null;
        if (component != null) {
            rootPaneContainerArray = actionSourceMap.get(component);
        }
        if (rootPaneContainerArray == null) {
            rootPaneContainerArray = CursorUtil.findRootPaneContainerParents(component, bl);
        } else {
            actionSourceMap.remove(component);
        }
        assert (rootPaneContainerArray != null) : "The passed reset-Component was null or did not have any Window/Applet parent!";
        RootPaneContainer[] rootPaneContainerArray2 = rootPaneContainerArray;
        int n = rootPaneContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            RootPaneContainer rootPaneContainer = rootPaneContainerArray2[n2];
            if (CursorUtil.decrementCallCounter(rootPaneContainer) <= 0) {
                CursorUtil.setGlassPaneCursor(rootPaneContainer, Cursor.getDefaultCursor());
                rootPaneMap.remove(rootPaneContainer);
            }
            ++n2;
        }
    }

    private static RootPaneContainer[] findRootPaneContainerParents(Component component, boolean bl) {
        ArrayList<RootPaneContainer> arrayList = new ArrayList<RootPaneContainer>();
        CursorUtil.findRootPaneContainerParents(component, arrayList, bl);
        return arrayList.toArray(new RootPaneContainer[arrayList.size()]);
    }

    private static void findRootPaneContainerParents(Component component, List<RootPaneContainer> list, boolean bl) {
        Component component2;
        if (component instanceof RootPaneContainer) {
            list.add((RootPaneContainer)((Object)component));
            if (!bl || component instanceof Dialog && ((Dialog)component).isModal()) {
                return;
            }
        }
        if ((component2 = ComponentUtil.getTopLevelParentOrWindow(component)) != null && component2 != component) {
            CursorUtil.findRootPaneContainerParents(component2, list, bl);
        }
    }

    private static void setGlassPaneCursor(final RootPaneContainer rootPaneContainer, final Cursor cursor) {
        EventUtil.invoke(new Runnable(){

            @Override
            public void run() {
                boolean bl = cursor != Cursor.getDefaultCursor();
                rootPaneContainer.getGlassPane().setCursor(cursor);
                rootPaneContainer.getGlassPane().setVisible(bl);
            }
        });
    }

    private static int incrementCallCounter(RootPaneContainer rootPaneContainer) {
        return CursorUtil.changeCallCounter(rootPaneContainer, true);
    }

    private static int decrementCallCounter(RootPaneContainer rootPaneContainer) {
        return CursorUtil.changeCallCounter(rootPaneContainer, false);
    }

    private static int changeCallCounter(RootPaneContainer rootPaneContainer, boolean bl) {
        Integer n = rootPaneMap.get(rootPaneContainer);
        if (n == null) {
            if (bl) {
                n = 0;
            } else {
                throw new IllegalStateException("There is no Window/Applet for passed rootPane in Map: " + rootPaneMap + ", rootPane is " + rootPaneContainer);
            }
        }
        n = bl ? Integer.valueOf(n + 1) : Integer.valueOf(n - 1);
        rootPaneMap.put(rootPaneContainer, n);
        return n;
    }
}

