/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.util;

import com.agfa.pacs.base.data.action.DataActionFactory;
import com.agfa.pacs.base.data.action.IDataAction;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DataActionMenu {
    private List<IDataAction> actions = new ArrayList<IDataAction>(4);
    private List<JMenuItem> additionalMenuItems;

    private DataActionMenu() {
    }

    public static DataActionMenu createMenu(boolean bl, Collection<String> collection, Collection<String> collection2) {
        DataActionMenu dataActionMenu = new DataActionMenu();
        if (bl) {
            boolean bl2 = collection2 != null && collection2.contains("ADD_TO_WORKLIST");
            for (IDataAction iDataAction : DataActionFactory.getInstance().getActions()) {
                String string = iDataAction.getActionCode();
                if (collection2 != null && collection2.contains(string) || bl2 && (string.equals("ADD_TO_LEGACY_WORKLIST") || string.startsWith("ADD_TO_UWL_WORKIST")) || !iDataAction.isAllowed()) continue;
                dataActionMenu.actions.add(iDataAction);
            }
        }
        if (collection != null) {
            for (String string : collection) {
                IDataAction iDataAction = DataActionFactory.getInstance().getActionForCode(string);
                if (iDataAction == null) continue;
                dataActionMenu.actions.add(iDataAction);
            }
        }
        Collections.sort(dataActionMenu.actions, new ActionComp());
        return dataActionMenu;
    }

    public void addMenuItem(IDataAction iDataAction) {
        this.actions.add(iDataAction);
    }

    public DataActionMenu addMenuItem(JMenuItem jMenuItem) {
        if (this.additionalMenuItems == null) {
            this.additionalMenuItems = new ArrayList<JMenuItem>(4);
        }
        this.additionalMenuItems.add(jMenuItem);
        return this;
    }

    public void showMenu(int n, int n2, Component component, List<? extends IDataInfo> list) {
        this.showMenu(n, n2, component, list, null);
    }

    public void showMenu(int n, int n2, Component component, List<? extends IDataInfo> list, Object object) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (IDataAction iDataAction : this.actions) {
            jPopupMenu.add(new JMenuItem(new PopupAction(iDataAction, object, component, list)));
        }
        if (this.additionalMenuItems != null) {
            this.additionalMenuItems.forEach(jMenuItem -> {
                JMenuItem jMenuItem2 = jPopupMenu.add((JMenuItem)jMenuItem);
            });
        }
        jPopupMenu.show(component, n, n2);
    }

    private static class ActionComp
    implements Comparator<IDataAction> {
        private ActionComp() {
        }

        @Override
        public int compare(IDataAction iDataAction, IDataAction iDataAction2) {
            return iDataAction2.getPriority() - iDataAction.getPriority();
        }
    }

    public static class PopupAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IDataAction action;
        private Object executionContext;
        private Component comp;
        private List<? extends IDataInfo> selectedData;

        public PopupAction(IDataAction iDataAction, Object object, Component component, List<? extends IDataInfo> list) {
            super(iDataAction.toString());
            this.comp = component;
            this.selectedData = list;
            this.executionContext = object;
            this.action = iDataAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CursorUtil.setWaitCursor(this.comp);
            try {
                this.action.perform((IDataAction.IActionContext)new IDataAction.DefaultActionContext(this.comp, this.executionContext), this.selectedData);
            }
            finally {
                CursorUtil.resetWaitCursor(this.comp);
            }
        }
    }
}

