/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.util;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.IComponentFactoryProvider;
import com.agfa.pacs.base.swing.StartupLFCheckpoint;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.jna.wintools.TouchUtils;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Window;
import java.awt.image.DirectColorModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.SynthLookAndFeel;

public class GUI {
    private static double scale = 1.0;
    private static double scaleDiagnostic = 1.0;
    private static boolean scalingDiagnosticComputed = false;
    private static boolean scalingLTAEnabled;
    private static boolean scalingDiagnosticEnabled;

    public static boolean isOnColorMonitor(Window window) {
        if (window == null) {
            return true;
        }
        return GUI.isOnColorMonitor(window.getGraphicsConfiguration());
    }

    public static boolean isOnColorMonitor(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration.getColorModel().getColorSpace().getType() == 6) {
            return false;
        }
        int n = GUI.getBitDepth(graphicsConfiguration);
        if (n > 0 && n <= 10) {
            return false;
        }
        return graphicsConfiguration.getColorModel() instanceof DirectColorModel;
    }

    private static int getBitDepth(GraphicsConfiguration graphicsConfiguration) {
        DisplayMode displayMode;
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        if (graphicsDevice != null && (displayMode = graphicsDevice.getDisplayMode()) != null) {
            return displayMode.getBitDepth();
        }
        return -1;
    }

    public static void computeFactor(Dimension dimension, boolean bl, double d) {
        scale = GUI.computeFontScaleFactor(dimension.width, dimension.height, bl, d);
        scalingLTAEnabled = GUI.isNonDefaultScalingFactor(scale);
        if (scalingLTAEnabled) {
            boolean bl2 = UIManager.getLookAndFeel() instanceof SynthLookAndFeel;
            if (bl2) {
                EventUtil.invokeSynchronous(new Runnable(){

                    @Override
                    public void run() {
                        GUI.resetAgfaSystemFontDefaults(scale);
                        GUI.resetAgfaComponentFontDefaults(scale);
                        Window[] windowArray = Window.getWindows();
                        if (windowArray != null) {
                            Window[] windowArray2 = windowArray;
                            int n = windowArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Window window = windowArray2[n2];
                                SwingUtilities.updateComponentTreeUI(window);
                                ++n2;
                            }
                        }
                    }
                });
            } else {
                GUI.resetAgfaSystemFontDefaults(scale);
                GUI.resetAgfaComponentFontDefaults(scale);
            }
        }
        StartupLFCheckpoint.setLFReady();
    }

    public static boolean isLTAScalingEnabled() {
        return scalingLTAEnabled;
    }

    public static boolean isScalingDiagnosticEnabled() {
        return scalingDiagnosticEnabled;
    }

    private static boolean isNonDefaultScalingFactor(double d) {
        return Math.abs(d - 1.0) > 0.01;
    }

    public static synchronized void computeDiagnosticScalingFactor(Dimension dimension, boolean bl, double d) {
        if (scalingDiagnosticComputed) {
            return;
        }
        scaleDiagnostic = GUI.computeFontScaleFactor(dimension.width, dimension.height, bl, d);
        scalingDiagnosticEnabled = GUI.isNonDefaultScalingFactor(scaleDiagnostic);
        scalingDiagnosticComputed = true;
        ALogger.getLogger(GUI.class).info("Scaling factor for IA:" + scaleDiagnostic);
    }

    public static double getScaleFactor() {
        return scale;
    }

    public static double getScaleDiagnosticFactor() {
        return scaleDiagnostic;
    }

    public static Dimension getScaledDimension(int n, int n2) {
        return GUI.getScaledDimension(new Dimension(n, n2));
    }

    public static Dimension getScaledDiagnosticDimension(int n, int n2) {
        return GUI.getScaledDiagnosticDimension(new Dimension(n, n2));
    }

    public static Dimension getScaledDimension(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(0, 0);
        }
        return new Dimension((int)((double)dimension.width * scale + 0.5), (int)((double)dimension.height * scale + 0.5));
    }

    public static Dimension getScaledDiagnosticDimension(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(0, 0);
        }
        return new Dimension((int)((double)dimension.width * scaleDiagnostic + 0.5), (int)((double)dimension.height * scaleDiagnostic + 0.5));
    }

    public static int getScaledInt(int n) {
        return (int)((double)n * scale + 0.5);
    }

    public static int getScaledDiagnosticInt(int n) {
        return (int)((double)n * scaleDiagnostic + 0.5);
    }

    public static IComponentFactory getComponentFactory(Component component) {
        Component component2 = component;
        while (!(component2 instanceof IComponentFactoryProvider)) {
            component2 = component2.getParent();
        }
        return ((IComponentFactoryProvider)((Object)component2)).getComponentFactory();
    }

    private static double computeFontScaleFactor(int n, int n2, boolean bl, double d) {
        double d2 = TouchUtils.supportsTouchInput() ? 1.8 : 1.0;
        long l = n * n2;
        if (!bl && l > 3140610L) {
            d = Math.sqrt((double)l / 3140610.0);
            ALogger.getLogger(GUI.class).warn("Monitor very large, starting automatic font scaling:" + d);
            return d * d2;
        }
        if (!bl) {
            return d2;
        }
        return d * d2;
    }

    private static void resetAgfaSystemFontDefaults(double d) {
        if (scale != 1.0) {
            Font font = UIManager.getFont("agfaFontSmall");
            Font font2 = UIManager.getFont("agfaFontDefault");
            Font font3 = UIManager.getFont("agfaFontLarge");
            Font font4 = UIManager.getFont("agfaFontXLarge");
            FontUIResource fontUIResource = new FontUIResource(font.deriveFont((float)((double)font.getSize() * d)));
            FontUIResource fontUIResource2 = new FontUIResource(font2.deriveFont((float)((double)font2.getSize() * d)));
            FontUIResource fontUIResource3 = new FontUIResource(font3.deriveFont((float)((double)font3.getSize() * d)));
            FontUIResource fontUIResource4 = new FontUIResource(font4.deriveFont((float)((double)font4.getSize() * d)));
            UIManager.put("agfaFontSmall", fontUIResource);
            UIManager.put("agfaFontDefault", fontUIResource2);
            UIManager.put("agfaFontLarge", fontUIResource3);
            UIManager.put("agfaFontXLarge", fontUIResource4);
        }
    }

    public static void setAgfaFontDefaults(FontUIResource fontUIResource) {
        UIManager.put("Button.font", fontUIResource);
        UIManager.put("CheckBox.font", fontUIResource);
        UIManager.put("CheckBoxMenuItem.font", fontUIResource);
        UIManager.put("ColorChooser.font", fontUIResource);
        UIManager.put("ComboBox.font", fontUIResource);
        UIManager.put("EditorPane.font", fontUIResource);
        UIManager.put("FormattedTextField.font", fontUIResource);
        UIManager.put("InternalFrame.dialogFont", fontUIResource);
        UIManager.put("Label.font", fontUIResource);
        UIManager.put("List.font", fontUIResource);
        UIManager.put("Menu.font", fontUIResource);
        UIManager.put("MenuBar.font", fontUIResource);
        UIManager.put("MenuItem.font", fontUIResource);
        UIManager.put("OptionPane.font", fontUIResource);
        UIManager.put("Panel.font", fontUIResource);
        UIManager.put("PasswordField.font", fontUIResource);
        UIManager.put("PopuMenu.font", fontUIResource);
        UIManager.put("ProgressBar.font", fontUIResource);
        UIManager.put("RadioButton.font", fontUIResource);
        UIManager.put("RadioButtonMenuItem.font", fontUIResource);
        UIManager.put("ScrollPane.font", fontUIResource);
        UIManager.put("Spinner.font", fontUIResource);
        UIManager.put("TabbedPane.font", fontUIResource);
        UIManager.put("Table.font", fontUIResource);
        UIManager.put("TableHeader.font", fontUIResource);
        UIManager.put("TextArea.font", fontUIResource);
        UIManager.put("TextField.font", fontUIResource);
        UIManager.put("TextPane.font", fontUIResource);
        UIManager.put("TitledBorder.font", fontUIResource);
        UIManager.put("ToggleButton.font", fontUIResource);
        UIManager.put("ToolBar.font", fontUIResource);
        UIManager.put("ToolTip.font", fontUIResource);
        UIManager.put("Tree.font", fontUIResource);
        UIManager.put("Viewport.font", fontUIResource);
    }

    private static void resetAgfaComponentFontDefaults(double d) {
        Font font = UIManager.getFont("agfaFontDefault");
        FontUIResource fontUIResource = new FontUIResource(font);
        GUI.setAgfaFontDefaults(fontUIResource);
    }
}

