/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.xds;

import com.agfa.pacs.base.swing.Messages;
import com.agfa.pacs.base.swing.xds.IPrintableCode;
import com.agfa.pacs.base.swing.xds.MetadataCodes;
import com.agfa.pacs.base.swing.xds.XDSRepository;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MetadataCodePanel
extends JPanel {
    private JLabel intituteNameLabel;
    private JLabel eventCodeLabel;
    private JLabel xdsRepositoryLabel;
    private JLabel confidentialityCodeLabel;
    private JLabel contentTypeCodeLabel;
    private JLabel healthcareTypeCodeLabel;
    private JLabel practiceSettingCodeLabel;
    private JLabel classCodeLabel;
    private JLabel typeCodeLabel;
    private JLabel formatCodeLabel;
    private JTextField documentTitleField;
    private JComboBox<String> instituteNameComboBox;
    private JComboBox<XDSRepository> targetRepositoryComboBox;
    private JComboBox<IPrintableCode> contentTypeCode;
    private JComboBox<IPrintableCode> classCode;
    private JComboBox<IPrintableCode> confidentialityCode;
    private JComboBox<IPrintableCode> healthcareTypeCode;
    private JComboBox<IPrintableCode> practiceSettingCode;
    private JComboBox<IPrintableCode> eventCode;
    private JComboBox<IPrintableCode> typeCode;
    private JComboBox<IPrintableCode> formatCode;
    private MetadataCodes metadataCodes;
    private List<XDSRepository> xdsRepositories;
    private List<String> institutNames;
    private Set<XDSCodesFields> usedFields;
    private ISelectionChangedListener listener;

    public MetadataCodePanel(MetadataCodes metadataCodes, List<XDSRepository> list, List<String> list2, XDSCodesFields ... xDSCodesFieldsArray) {
        this.metadataCodes = metadataCodes;
        this.xdsRepositories = list;
        this.institutNames = list2;
        this.usedFields = new HashSet<XDSCodesFields>();
        XDSCodesFields[] xDSCodesFieldsArray2 = xDSCodesFieldsArray;
        int n = xDSCodesFieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            XDSCodesFields xDSCodesFields = xDSCodesFieldsArray2[n2];
            this.usedFields.add(xDSCodesFields);
            ++n2;
        }
        this.createPanel();
    }

    public void registerSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listener = iSelectionChangedListener;
    }

    private void createPanel() {
        Vector<Object> vector;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        int n = 0;
        if (this.usedFields.contains((Object)XDSCodesFields.DOCUMENT_TITLE)) {
            this.addCompToGrid(new JLabel(Messages.getString("MetadataCodePanel.DocumentTitle")), 0, n);
            this.documentTitleField = new JTextField();
            this.documentTitleField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MetadataCodePanel.this.listener != null) {
                        MetadataCodePanel.this.listener.selectionChanged();
                    }
                }
            });
            this.addCompToGrid(this.documentTitleField, 1, n++);
        }
        if (this.usedFields.contains((Object)XDSCodesFields.INSTITUTE)) {
            this.intituteNameLabel = new JLabel(Messages.getString("MetadataCodePanel.InstituteName"));
            this.addCompToGrid(this.intituteNameLabel, 0, n);
            vector = new Vector<String>(this.institutNames);
            this.instituteNameComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(vector));
            this.addCompToGrid(this.instituteNameComboBox, 1, n++);
            this.instituteNameComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MetadataCodePanel.this.listener != null) {
                        MetadataCodePanel.this.listener.selectionChanged();
                    }
                }
            });
        }
        if (this.usedFields.contains((Object)XDSCodesFields.EVENT)) {
            this.eventCodeLabel = new JLabel(Messages.getString("MetadataCodePanel.EventCodeLabel"));
            this.addCompToGrid(this.eventCodeLabel, 0, n);
            this.eventCode = this.createCodeComboBox(this.metadataCodes.getEventCodes());
            this.addCompToGrid(this.eventCode, 1, n++);
        }
        if (this.usedFields.contains((Object)XDSCodesFields.REPOSITORY)) {
            this.xdsRepositoryLabel = new JLabel(Messages.getString("MetadataCodePanel.TargetRepository"));
            this.addCompToGrid(this.xdsRepositoryLabel, 0, n);
            vector = new Vector<XDSRepository>(this.xdsRepositories);
            this.targetRepositoryComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(vector));
            this.addCompToGrid(this.targetRepositoryComboBox, 1, n++);
        }
        if (this.usedFields.contains((Object)XDSCodesFields.CONFIDENTIALITY)) {
            this.confidentialityCodeLabel = new JLabel(Messages.getString("MetadataCodePanel.ConfidentialityCodeLabel"));
            this.addCompToGrid(this.confidentialityCodeLabel, 0, n);
            this.confidentialityCode = this.createCodeComboBox(this.metadataCodes.getConfidentialityCodes());
            this.addCompToGrid(this.confidentialityCode, 1, n++);
        }
        if (this.usedFields.contains((Object)XDSCodesFields.CONTENT)) {
            this.contentTypeCodeLabel = new JLabel(Messages.getString("MetadataCodePanel.ContentTypeCodeLabel"));
            this.addCompToGrid(this.contentTypeCodeLabel, 0, n);
            this.contentTypeCode = this.createCodeComboBox(this.metadataCodes.getContentTypeCodes());
            this.addCompToGrid(this.contentTypeCode, 1, n++);
        }
        if (this.usedFields.contains((Object)XDSCodesFields.HEALTHCARE_TYPE)) {
            this.healthcareTypeCodeLabel = new JLabel(Messages.getString("MetadataCodePanel.HealthcareFacilityTypeCodeLabel"));
            this.addCompToGrid(this.healthcareTypeCodeLabel, 0, n);
            this.healthcareTypeCode = this.createCodeComboBox(this.metadataCodes.getHealthcareFacilityTypeCodes());
            this.addCompToGrid(this.healthcareTypeCode, 1, n++);
        }
        if (this.usedFields.contains((Object)XDSCodesFields.PRACTICE_SETTING)) {
            this.practiceSettingCodeLabel = new JLabel(Messages.getString("MetadataCodePanel.PracticeSettingCodeLabel"));
            this.addCompToGrid(this.practiceSettingCodeLabel, 0, n);
            this.practiceSettingCode = this.createCodeComboBox(this.metadataCodes.getPracticeSettingCodes());
            this.addCompToGrid(this.practiceSettingCode, 1, n++);
        }
        if (this.usedFields.contains((Object)XDSCodesFields.CLASS)) {
            this.classCodeLabel = new JLabel(Messages.getString("MetadataCodePanel.ClassCodeLabel"));
            this.addCompToGrid(this.classCodeLabel, 0, n);
            this.classCode = this.createCodeComboBox(this.metadataCodes.getClassCodes());
            this.addCompToGrid(this.classCode, 1, n++);
        }
        if (this.usedFields.contains((Object)XDSCodesFields.TYPE_CODE)) {
            this.typeCodeLabel = new JLabel(Messages.getString("MetadataCodePanel.TypeCodeLabel"));
            this.addCompToGrid(this.typeCodeLabel, 0, n);
            this.typeCode = this.createCodeComboBox(this.metadataCodes.getTypeCodes());
            this.addCompToGrid(this.typeCode, 1, n++);
        }
        if (this.usedFields.contains((Object)XDSCodesFields.FORMAT)) {
            this.formatCodeLabel = new JLabel(Messages.getString("MetadataCodePanel.FormatCodeLabel"));
            this.addCompToGrid(this.formatCodeLabel, 0, n);
            this.formatCode = this.createCodeComboBox(this.metadataCodes.getFormatCodes());
            this.addCompToGrid(this.formatCode, 1, n++);
        }
    }

    private JComboBox<IPrintableCode> createCodeComboBox(List<IPrintableCode> list) {
        Vector<IPrintableCode> vector = new Vector<IPrintableCode>(list);
        JComboBox<IPrintableCode> jComboBox = new JComboBox<IPrintableCode>(new DefaultComboBoxModel<IPrintableCode>(vector));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MetadataCodePanel.this.listener != null) {
                    MetadataCodePanel.this.listener.selectionChanged();
                }
            }
        });
        return jComboBox;
    }

    private void addCompToGrid(JComponent jComponent, int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        this.add((Component)jComponent, gridBagConstraints);
    }

    private Object getValueForField(XDSCodesFields xDSCodesFields) {
        switch (xDSCodesFields) {
            case INSTITUTE: {
                return this.instituteNameComboBox.getSelectedItem();
            }
            case EVENT: {
                return this.eventCode.getSelectedItem();
            }
            case REPOSITORY: {
                return this.targetRepositoryComboBox.getSelectedItem();
            }
            case CONFIDENTIALITY: {
                return this.confidentialityCode.getSelectedItem();
            }
            case CONTENT: {
                return this.contentTypeCode.getSelectedItem();
            }
            case HEALTHCARE_TYPE: {
                return this.healthcareTypeCode.getSelectedItem();
            }
            case PRACTICE_SETTING: {
                return this.practiceSettingCode.getSelectedItem();
            }
            case CLASS: {
                return this.classCode.getSelectedItem();
            }
            case TYPE_CODE: {
                return this.typeCode.getSelectedItem();
            }
            case FORMAT: {
                return this.formatCode.getSelectedItem();
            }
            case DOCUMENT_TITLE: {
                return this.documentTitleField.getText();
            }
        }
        return null;
    }

    private static String toPrintable(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof XDSRepository) {
            return ((XDSRepository)object).getUID();
        }
        if (object instanceof IPrintableCode) {
            IPrintableCode iPrintableCode = (IPrintableCode)object;
            return "{\"code\":\"" + iPrintableCode.getValue() + "\",\"display\":\"" + iPrintableCode.getMeaning() + "\",\"codingScheme\":\"" + iPrintableCode.getDesignator() + "\"}";
        }
        return "";
    }

    public void writeToProperties(Properties properties) {
        for (XDSCodesFields xDSCodesFields : this.usedFields) {
            Object object = this.getValueForField(xDSCodesFields);
            properties.put(xDSCodesFields.getName(), MetadataCodePanel.toPrintable(object));
        }
    }

    private void setCodeSelection(JComboBox<IPrintableCode> jComboBox, String string) {
        if (string != null && !string.isEmpty()) {
            int n = string.indexOf("\"code\":\"") + 8;
            int n2 = string.indexOf("\"codingScheme\":\"") + 16;
            if (n >= 0 && n2 >= 0) {
                String string2 = string.substring(n, string.indexOf(34, n));
                String string3 = string.substring(n2, string.indexOf(34, n2));
                int n3 = 0;
                while (n3 < jComboBox.getItemCount()) {
                    IPrintableCode iPrintableCode = jComboBox.getItemAt(n3);
                    if (iPrintableCode.getValue().equals(string2) && iPrintableCode.getDesignator().equals(string3)) {
                        jComboBox.setSelectedIndex(n3);
                        break;
                    }
                    ++n3;
                }
            }
        }
    }

    public void readFromProperties(Properties properties) {
        for (XDSCodesFields xDSCodesFields : this.usedFields) {
            switch (xDSCodesFields) {
                case INSTITUTE: {
                    this.setSelectedInstituteName(properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case REPOSITORY: {
                    this.setSelectedRepository(properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case DOCUMENT_TITLE: {
                    this.documentTitleField.setText(properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case EVENT: {
                    this.setCodeSelection(this.eventCode, properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case CONFIDENTIALITY: {
                    this.setCodeSelection(this.confidentialityCode, properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case CONTENT: {
                    this.setCodeSelection(this.contentTypeCode, properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case HEALTHCARE_TYPE: {
                    this.setCodeSelection(this.healthcareTypeCode, properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case PRACTICE_SETTING: {
                    this.setCodeSelection(this.practiceSettingCode, properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case CLASS: {
                    this.setCodeSelection(this.classCode, properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case TYPE_CODE: {
                    this.setCodeSelection(this.typeCode, properties.getProperty(xDSCodesFields.getName()));
                    break;
                }
                case FORMAT: {
                    this.setCodeSelection(this.formatCode, properties.getProperty(xDSCodesFields.getName()));
                }
            }
        }
    }

    public boolean containsAllProperties(Properties properties) {
        for (XDSCodesFields xDSCodesFields : this.usedFields) {
            if (properties.contains(xDSCodesFields.getName())) continue;
            return false;
        }
        return true;
    }

    public void setSelectedRepository(String string) {
        int n = 0;
        while (n < this.targetRepositoryComboBox.getItemCount()) {
            XDSRepository xDSRepository = this.targetRepositoryComboBox.getItemAt(n);
            if (xDSRepository.getUID().equals(string)) {
                this.targetRepositoryComboBox.setSelectedIndex(n);
                break;
            }
            ++n;
        }
    }

    public void setSelectedInstituteName(String string) {
        int n = 0;
        while (n < this.instituteNameComboBox.getItemCount()) {
            String string2 = this.instituteNameComboBox.getItemAt(n);
            if (string2.equals(string)) {
                this.instituteNameComboBox.setSelectedIndex(n);
                break;
            }
            ++n;
        }
    }

    public JLabel getIntituteNameLabel() {
        return this.intituteNameLabel;
    }

    public JLabel getEventCodeLabel() {
        return this.eventCodeLabel;
    }

    public JLabel getXdsRepositoryLabel() {
        return this.xdsRepositoryLabel;
    }

    public JLabel getConfidentialityCodeLabel() {
        return this.confidentialityCodeLabel;
    }

    public JLabel getContentTypeCodeLabel() {
        return this.contentTypeCodeLabel;
    }

    public JLabel getHealthcareTypeCodeLabel() {
        return this.healthcareTypeCodeLabel;
    }

    public JLabel getPracticeSettingCodeLabel() {
        return this.practiceSettingCodeLabel;
    }

    public JLabel getClassCodeLabel() {
        return this.classCodeLabel;
    }

    public JLabel getTypeCodeLabel() {
        return this.typeCodeLabel;
    }

    public JLabel getFormatCodeLabel() {
        return this.formatCodeLabel;
    }

    public JTextField getDocumentTitleField() {
        return this.documentTitleField;
    }

    public JComboBox<String> getInstituteNameComboBox() {
        return this.instituteNameComboBox;
    }

    public JComboBox<XDSRepository> getTargetRepositoryComboBox() {
        return this.targetRepositoryComboBox;
    }

    public JComboBox<IPrintableCode> getPracticeSettingCode() {
        return this.practiceSettingCode;
    }

    public JComboBox<IPrintableCode> getEventCodeComboBox() {
        return this.eventCode;
    }

    public JComboBox<IPrintableCode> getConfidentialityCodeComboBox() {
        return this.confidentialityCode;
    }

    public JComboBox<IPrintableCode> getContentTypeCodeComboBox() {
        return this.contentTypeCode;
    }

    public JComboBox<IPrintableCode> getClassCodeComboBox() {
        return this.classCode;
    }

    public JComboBox<IPrintableCode> getHealthcareTypeCodeComboBox() {
        return this.healthcareTypeCode;
    }

    public JComboBox<IPrintableCode> getTypeCodeComboBox() {
        return this.typeCode;
    }

    public JComboBox<IPrintableCode> getFormatCodeComboBox() {
        return this.formatCode;
    }

    public static interface ISelectionChangedListener {
        public void selectionChanged();
    }

    public static enum XDSCodesFields {
        INSTITUTE("institution"),
        EVENT("eventCode"),
        REPOSITORY("repositoryID"),
        CONFIDENTIALITY("confidentialityCode"),
        CONTENT("contentTypeCode"),
        HEALTHCARE_TYPE("healthcareTypeCode"),
        PRACTICE_SETTING("practiceSettingCode"),
        CLASS("classCode"),
        TYPE_CODE("typeCode"),
        FORMAT("formatCode"),
        DOCUMENT_TITLE("documentTitle");

        private String name;

        private XDSCodesFields(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }
}

