/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.xds;

import com.agfa.pacs.base.swing.xds.IPrintableCode;
import com.agfa.pacs.base.swing.xds.IPrintableCodeFactory;
import com.agfa.pacs.base.swing.xds.MetadataCodes;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MetadataCodeParser {
    private InputStream xmlStream;
    private MetadataCodes metadataCodes = new MetadataCodes();

    private MetadataCodeParser() {
    }

    public MetadataCodeParser(InputStream inputStream) {
        this();
        this.xmlStream = inputStream;
    }

    public void parseDocument(IPrintableCodeFactory iPrintableCodeFactory) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(this.xmlStream);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("CodeType");
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                Element element = (Element)nodeList.item(n);
                String string = element.getAttributes().getNamedItem("name").getTextContent();
                NodeList nodeList2 = element.getElementsByTagName("Code");
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    if (nodeList2.item(n2).getNodeType() == 1) {
                        Element element2 = (Element)nodeList2.item(n2);
                        Node node = element2.getAttributes().getNamedItem("code");
                        Node node2 = element2.getAttributes().getNamedItem("display");
                        Node node3 = element2.getAttributes().getNamedItem("codingScheme");
                        if (node != null && node2 != null && node3 != null) {
                            IPrintableCode iPrintableCode = iPrintableCodeFactory.createPrintableCode(node.getTextContent(), node3.getTextContent(), node2.getTextContent());
                            this.addCode(string, iPrintableCode);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.metadataCodes.sort();
    }

    public MetadataCodes getMetadataCodes() {
        return this.metadataCodes;
    }

    private void addCode(String string, IPrintableCode iPrintableCode) {
        if (string.equals("contentTypeCode")) {
            this.metadataCodes.addContentTypeCode(iPrintableCode);
        } else if (string.equals("classCode")) {
            this.metadataCodes.addClassCode(iPrintableCode);
        } else if (string.equals("confidentialityCode")) {
            this.metadataCodes.addConfidentialityCode(iPrintableCode);
        } else if (string.equals("formatCode")) {
            this.metadataCodes.addFormatCode(iPrintableCode);
        } else if (string.equals("healthcareFacilityTypeCode")) {
            this.metadataCodes.addHealthcareFacilityTypeCode(iPrintableCode);
        } else if (string.equals("practiceSettingCode")) {
            this.metadataCodes.addPracticeSettingCode(iPrintableCode);
        } else if (string.equals("eventCodeList")) {
            this.metadataCodes.addEventCode(iPrintableCode);
        } else if (string.equals("typeCode")) {
            this.metadataCodes.addTypeCode(iPrintableCode);
        }
    }
}

