/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.config.xml.minijaxb;

import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.AbstractXmlElement;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoadable;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlLoader
extends DefaultHandler {
    private static final ALogger log = ALogger.getLogger(XmlLoader.class);
    private static SAXParserFactory saxFactory;
    private static Map<String, Map<String, Class<?>>> elementCache;
    private XmlLoadable model;
    private Class<?> rootClass;
    private Stack<XmlLoadable> elementStack;
    private Map<String, Class<?>> elementClassMap;

    static {
        elementCache = new Hashtable();
    }

    public XmlLoader() {
        saxFactory = SAXParserFactory.newInstance();
        try {
            saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {}
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(true);
        this.elementStack = new Stack();
    }

    public Object load(InputStream inputStream, Class<?> clazz) throws MarshalException {
        this.init(clazz);
        try {
            SAXParser sAXParser = saxFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (Exception exception) {
            this.exceptionHandling(exception);
        }
        return this.model;
    }

    public Object load(String string, Class<?> clazz) throws MarshalException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        return this.load(byteArrayInputStream, clazz);
    }

    public Object load(URL uRL, Class<?> clazz) throws MarshalException {
        this.init(clazz);
        try {
            SAXParser sAXParser = saxFactory.newSAXParser();
            sAXParser.parse(uRL.toExternalForm(), (DefaultHandler)this);
        }
        catch (Exception exception) {
            this.exceptionHandling(exception);
        }
        return this.model;
    }

    private void init(Class<?> clazz) {
        if (!AbstractXmlElement.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("ERROR: Can handle only instances of AbstractReflectionXmlLoadable: " + this.rootClass);
        }
        this.rootClass = clazz;
        this.elementClassMap = elementCache.containsKey(this.rootClass.getName()) ? new HashMap(elementCache.get(this.rootClass.getName())) : new HashMap(20);
    }

    private void exceptionHandling(Exception exception) throws MarshalException {
        if (exception instanceof SAXException && ((SAXException)exception).getException() != null) {
            exception = ((SAXException)exception).getException();
        }
        throw new MarshalException(exception);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Class<?> clazz = this.getJavaClass4XmlElement(string3);
        if (XmlLoadable.class.isAssignableFrom(clazz)) {
            try {
                XmlLoadable xmlLoadable = (XmlLoadable)clazz.newInstance();
                xmlLoadable.defineTagName(string3);
                int n = 0;
                while (attributes != null && n < attributes.getLength()) {
                    String string4 = attributes.getQName(n);
                    if (!string4.startsWith("xsi:") && !string4.startsWith("xsd:")) {
                        String string5 = attributes.getValue(n);
                        xmlLoadable.defineAttribute(string4, string5);
                    }
                    ++n;
                }
                this.elementStack.push(xmlLoadable);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        } else {
            throw new SAXException("XML element must have an associated Java class: " + string3 + " within " + this.elementStack.peek());
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            String string;
            XmlLoadable xmlLoadable;
            XmlLoadable xmlLoadable2 = xmlLoadable = this.elementStack.size() > 0 ? this.elementStack.peek() : null;
            if (xmlLoadable != null && StringUtils.isNotBlank((CharSequence)(string = new String(cArray, n, n2)))) {
                xmlLoadable.appendText(string);
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Class<?> clazz = this.getJavaClass4XmlElement(string3);
        if (clazz != null) {
            try {
                XmlLoadable xmlLoadable;
                XmlLoadable xmlLoadable2 = this.elementStack.pop();
                XmlLoadable xmlLoadable3 = xmlLoadable = this.elementStack.size() > 0 ? this.elementStack.peek() : null;
                if (xmlLoadable != null) {
                    xmlLoadable.appendChild(string3, xmlLoadable2);
                } else {
                    this.model = xmlLoadable2;
                }
            }
            catch (MarshalException marshalException) {
                log.error("XmlLoader", (Throwable)marshalException);
                throw new SAXException(marshalException);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!elementCache.containsKey(this.rootClass.getName())) {
            elementCache.put(this.rootClass.getName(), this.elementClassMap);
        }
    }

    protected Class<?> getJavaClass4XmlElement(String string) throws SAXException {
        Class<?> clazz;
        Class<?> clazz2 = this.elementClassMap.get(string);
        if (clazz2 != null) {
            return clazz2;
        }
        if (this.elementStack.size() <= 0) {
            this.elementClassMap.put(string, this.rootClass);
            return this.rootClass;
        }
        XmlSaveable xmlSaveable = (XmlSaveable)((Object)this.elementStack.peek());
        StringBuilder stringBuilder = new StringBuilder("get").append(Character.toUpperCase(string.charAt(0)));
        stringBuilder.append(string.substring(1));
        String string2 = stringBuilder.toString();
        try {
            Method method = xmlSaveable.getClass().getMethod(string2, new Class[0]);
            clazz = method.getReturnType();
        }
        catch (Exception exception) {
            try {
                Method method = xmlSaveable.getClass().getMethod(string2, Integer.TYPE);
                clazz = method.getReturnType();
            }
            catch (Exception exception2) {
                throw new SAXException(exception);
            }
        }
        this.elementClassMap.put(string, clazz);
        return clazz;
    }
}

